/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.ZipUtils;
import com.wowza.wms.httpstreamer.model.HTTPStreamerList;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.ApplicationsConfig;
import com.wowza.wms.rest.vhosts.applications.drm.DRMConfig;
import com.wowza.wms.rest.vhosts.applications.dvr.DVRConfig;
import com.wowza.wms.rest.vhosts.applications.modules.ModulesConfig;
import com.wowza.wms.rest.vhosts.applications.security.SecurityConfig;
import com.wowza.wms.rest.vhosts.applications.streamconfiguration.StreamConfigurationConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderAppConfig;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Application")
@WMSDescription(text="Application", get="Retrieves the specified Application configuration", put="Updates the specified Application configuration", post="Adds the specified Application configuration", delete="Deletes the specified Application configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="Application.xml")
public class ApplicationConfig
extends ApplicationConfigBase {
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Application/Name/text()")
    protected String name;
    @JsonProperty(value="appType")
    @XStreamAlias(value="AppType")
    @WMSXMLVariable(xpath="/Root/Application/AppType/text()")
    protected String appType;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Application/Description/text()")
    protected String description;
    @JsonProperty(value="applicationTimeout")
    @XStreamAlias(value="ApplicationTimeout")
    @WMSXMLVariable(xpath="/Root/Application/ApplicationTimeout/text()")
    protected int applicationTimeout;
    @JsonProperty(value="pingTimeout")
    @XStreamAlias(value="PingTimeout")
    @WMSXMLVariable(xpath="/Root/Application/PingTimeout/text()")
    protected int pingTimeout;
    @JsonProperty(value="repeaterOriginURL")
    @XStreamAlias(value="RepeaterOriginURL")
    @WMSXMLVariable(xpath="/Root/Application/Repeater/OriginURL/text()")
    protected String repeaterOriginURL;
    @JsonProperty(value="repeaterQueryString")
    @XStreamAlias(value="RepeaterQueryString")
    @WMSXMLVariable(xpath="/Root/Application/Repeater/QueryString/text()")
    protected String repeaterQueryString;
    @JsonProperty(value="clientStreamReadAccess")
    @XStreamAlias(value="ClientStreamReadAccess")
    @WMSXMLVariable(xpath="/Root/Application/Client/Access/StreamReadAccess/text()")
    protected String clientStreamReadAccess;
    @JsonProperty(value="clientStreamWriteAccess")
    @XStreamAlias(value="ClientStreamWriteAccess")
    @WMSXMLVariable(xpath="/Root/Application/Client/Access/StreamWriteAccess/text()")
    protected String clientStreamWriteAccess;
    @JsonProperty(value="avSyncMethod")
    @XStreamAlias(value="AVSyncMethod")
    @WMSXMLVariable(xpath="/Root/Application/RTP/AVSyncMethod/text()")
    protected String avSyncMethod;
    @JsonProperty(value="httpStreamers")
    @XStreamAlias(value="HTTPStreamers")
    @WMSXMLVariable(xpath="/Root/Application/HTTPStreamers/text()")
    protected List<String> httpStreamers;
    @JsonProperty(value="mediaCacheSourceList")
    @XStreamAlias(value="MediaCacheSourceList")
    @WMSXMLVariable(xpath="/Root/Application/MediaCache/MediaCacheSourceList/text()")
    protected List<String> mediaCacheSourceList;
    @JsonProperty(value="mediaReaderRandomAccessReaderClass")
    @XStreamAlias(value="MediaReaderRandomAccessReaderClass")
    @WMSXMLProperty(root="/Root/Application/MediaReader", name="randomAccessReaderClass", defaultValue="")
    protected String mediaReaderRandomAccessReaderClass;
    @JsonProperty(value="httpOptimizeFileReads")
    @XStreamAlias(value="HTTPOptimizeFileReads")
    @WMSXMLProperty(root="/Root/Application/HTTPStreamer", name="httpOptimizeFileReads", defaultValue="false")
    protected boolean httpOptimizeFileReads;
    @JsonProperty(value="mediaReaderBufferSeekIO")
    @XStreamAlias(value="MediaReaderBufferSeekIO")
    @WMSXMLProperty(root="/Root/Application/MediaReader", name="bufferSeekIO", defaultValue="false")
    protected boolean mediaReaderBufferSeekIO;
    @JsonProperty(value="captionLiveIngestType")
    @XStreamAlias(value="CaptionLiveIngestType")
    @WMSXMLProperty(root="/Root/Application/TimedText", name="captionLiveIngestType", defaultValue="")
    protected String captionLiveIngestType;
    @JsonProperty(value="vodTimedTextProviders")
    @XStreamAlias(value="VODTimedTextProviders")
    @WMSXMLVariable(xpath="/Root/Application/TimedText/VODTimedTextProviders/text()")
    protected List<String> vodTimedTextProviders;
    @XStreamOmitField
    protected List<String> httpStreamersOptions;
    @JsonProperty(value="securityConfig")
    @XStreamAlias(value="SecuirtyConfig")
    protected SecurityConfig securityConfig;
    @JsonProperty(value="streamConfig")
    @XStreamAlias(value="StreamConfig")
    protected StreamConfigurationConfig streamConfig;
    @JsonProperty(value="dvrConfig")
    @XStreamAlias(value="DVRConfig")
    protected DVRConfig dvrConfig;
    @JsonProperty(value="drmConfig")
    @XStreamAlias(value="DRMConfig")
    protected DRMConfig drmConfig;
    @JsonProperty(value="transcoderConfig")
    @XStreamAlias(value="TranscoderConfig")
    protected TranscoderAppConfig transcoderConfig;
    @JsonProperty(value="modules")
    @XStreamAlias(value="Modules")
    protected ModulesConfig modules;

    public ApplicationConfig() {
        this.avSyncMethod = Utils.substring("}j~uwafpfxjm", -37 - 45);
    }

    public ApplicationConfig(String string, String string2) {
        super(string, string2);
        this.avSyncMethod = Severity.valueOf(1267 / 217, "vcillxyi}a}d");
        this.name = string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String string) {
        this.appType = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getApplicationTimeout() {
        return this.applicationTimeout;
    }

    public void setApplicationTimeout(int n) {
        this.applicationTimeout = n;
    }

    public int getPingTimeout() {
        return this.pingTimeout;
    }

    public void setPingTimeout(int n) {
        this.pingTimeout = n;
    }

    public StreamConfigurationConfig getStreamConfig() {
        return this.streamConfig;
    }

    public void setStreamConfig(StreamConfigurationConfig streamConfigurationConfig) {
        this.streamConfig = streamConfigurationConfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    public DRMConfig getDrmConfig() {
        return this.drmConfig;
    }

    public TranscoderAppConfig getTranscoderConfig() {
        return this.transcoderConfig;
    }

    public void setTranscoderConfig(TranscoderAppConfig transcoderAppConfig) {
        this.transcoderConfig = transcoderAppConfig;
    }

    public void setDrmConfig(DRMConfig dRMConfig) {
        this.drmConfig = dRMConfig;
    }

    public String getRepeaterOriginURL() {
        return this.repeaterOriginURL;
    }

    public void setRepeaterOriginURL(String string) {
        this.repeaterOriginURL = string;
    }

    public String getRepeaterQueryString() {
        return this.repeaterQueryString;
    }

    public void setRepeaterQueryString(String string) {
        this.repeaterQueryString = string;
    }

    public DVRConfig getDvrConfig() {
        return this.dvrConfig;
    }

    public void setDvrConfig(DVRConfig dVRConfig) {
        this.dvrConfig = dVRConfig;
    }

    public List<String> getHttpStreamers() {
        return this.httpStreamers;
    }

    public void setHttpStreamers(List<String> list) {
        this.httpStreamers = list;
    }

    public List<String> getHttpStreamersOptions() {
        return this.httpStreamersOptions;
    }

    public void setHttpStreamersOptions(List<String> list) {
        this.httpStreamersOptions = list;
    }

    public String getClientStreamReadAccess() {
        return this.clientStreamReadAccess;
    }

    public void setClientStreamReadAccess(String string) {
        this.clientStreamReadAccess = string;
    }

    public String getClientStreamWriteAccess() {
        return this.clientStreamWriteAccess;
    }

    public void setClientStreamWriteAccess(String string) {
        this.clientStreamWriteAccess = string;
    }

    public String getMediaReaderRandomAccessReaderClass() {
        return this.mediaReaderRandomAccessReaderClass;
    }

    public List<String> getMediaCacheSourceList() {
        return this.mediaCacheSourceList;
    }

    public void setMediaCacheSourceList(List<String> list) {
        this.mediaCacheSourceList = list;
    }

    public void setMediaReaderRandomAccessReaderClass(String string) {
        this.mediaReaderRandomAccessReaderClass = string;
    }

    public boolean isMediaReaderBufferSeekIO() {
        return this.mediaReaderBufferSeekIO;
    }

    public void setMediaReaderBufferSeekIO(boolean bl) {
        this.mediaReaderBufferSeekIO = bl;
    }

    public boolean isHttpOptimizeFileReads() {
        return this.httpOptimizeFileReads;
    }

    public void setHttpOptimizeFileReads(boolean bl) {
        this.httpOptimizeFileReads = bl;
    }

    public String getCaptionLiveIngestType() {
        return this.captionLiveIngestType;
    }

    public void setCaptionLiveIngestType(String string) {
        this.captionLiveIngestType = string;
    }

    public List<String> getVodTimedTextProviders() {
        return this.vodTimedTextProviders;
    }

    public String getAvSyncMethod() {
        return this.avSyncMethod;
    }

    public void setAvSyncMethod(String string) {
        this.avSyncMethod = string;
    }

    public void setVodTimedTextProviders(List<String> list) {
        this.vodTimedTextProviders = list;
    }

    public ModulesConfig getModules() {
        return this.modules;
    }

    public void setModules(ModulesConfig modulesConfig) {
        this.modules = modulesConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        try {
            Class.forName(Utils.substring("fij&~e|vl x}b<e|zec6PLSsnj", 468 / 84));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost == null) return;
            this.httpStreamersOptions = new ArrayList<String>();
            HTTPStreamerList hTTPStreamerList = iVHost.getHTTPStreamerList();
            Map map = hTTPStreamerList.getHTTPStreamerDefs();
            Iterator iterator = map.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Collections.sort(this.httpStreamersOptions);
                    return;
                }
                String string = (String)iterator.next();
                this.httpStreamersOptions.add(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    @Override
    public boolean loadObject() {
        this.a();
        boolean bl = super.loadObject();
        return bl;
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        ApplicationsConfig.updateAppplicationInfoCache(this.vhostName, this.appName, this);
        return super.saveObject();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveNewObject() {
        var1_1 = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Utils.substring("\u0013\u0007\u0010\u0010e\u0007\u0017\u0001sj\n()'!7q\u0013#$9?49-342}~w", 33 * 33) + this.name + Utils.substring("6:!Km$qtfll*xdby/}~vv:56Ywm:zxywq'a$*( h", 11 * 61)));
            var1_1.success = true;
            var1_1.message = Utils.substring("Dbcmm", 363 / 62);
            return var1_1;
        }
        var2_6 = this.name;
        var3_7 = this.getStringVariable(Severity.valueOf(87 + 122, "':<'!\u001865<"));
        var4_8 = this.getFilename();
        var4_8 = var4_8.substring(0, var4_8.lastIndexOf(47));
        var5_9 = new File(var4_8.replace(Severity.valueOf(-50 - 53, "6ytr{1"), "/applications/"));
        var5_9.mkdir();
        var6_10 = new File(var4_8);
        var6_10.mkdir();
        try {
            ApplicationConfig.copyFile(VHostsConfig.getVHostDir(var3_7) + Severity.valueOf(21 * 43, "(kfdm#") + this.getXMLFilename(), this.getFilename());
            var1_1 = this.saveObject();
            if (!var1_1.isSuccess()) ** GOTO lbl42
            var7_3 = StatsManager.getInstance();
            if (!var7_3.isEnabled()) ** GOTO lbl28
            ** GOTO lbl32
        }
        catch (FileNotFoundException var7_2) {
            block6: {
                var1_1.message = var7_2.getMessage();
                ConfigBase.log.warn((Object)Utils.substring("\f\u001aSU\"BTL<'M{xd~-m``h{}s5wghusx}iwpn", 64 + 62), (Throwable)var7_2);
                break block6;
lbl28:
                // 2 sources

                while (true) {
                    var1_1.message = Utils.substring("Btujnkh~bcc.'", 156 / 47) + var2_6 + Utils.substring("jd&4\")=//l>;,34! 2 :;!w", 53 * 23);
                    ApplicationsConfig.updateAppplicationInfoCache(var3_7, var2_6, this);
                    break block6;
                    break;
                }
lbl32:
                // 1 sources

                var7_3.getStatsDatabaseManager().applicationGetDatabase(var3_7, var2_6);
                ** continue;
                catch (IOException var7_4) {
                    var1_1.message = var7_4.getMessage();
                    ConfigBase.log.warn((Object)Utils.substring("WCT\\)K[E7.Jbc}a4vygapt|<|no,(!\"0,))", -18 - -55), (Throwable)var7_4);
                    break block6;
                }
                catch (ConfigBase.ConfigBaseException var7_5) {
                    var1_1.message = var7_5.getMessage();
                    ConfigBase.log.warn((Object)Severity.valueOf(122 + 124, "\u0004\u0012\u000b\rz\u001a\f\u0014d\u007fEsplv%ehxpcek-o\u007f`}{pua\u007fxv"), (Throwable)var7_5);
                }
            }
            if (var1_1.isSuccess() == false) return var1_1;
            ConfigBase.log.info((Object)(Severity.valueOf(-35 - -49, "\\JCE2RD\\,7") + var1_1.message));
            return var1_1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse;
        block4: {
            String string = this.getStringVariable(Utils.substring("&89\u0004*!(", 48 - -55));
            String string2 = this.getStringVariable(Severity.valueOf(-33 + 85, "b}ydlW{vy"));
            wMSResponse = new WMSResponse();
            if (ConfigBase.inTradeShowMode) {
                ConfigBase.log.warn((Object)(Utils.substring("\u0013\u0007\u0010\u0010e\u0007\u0017\u0001sj\u000f)!+;9?5s\u0015%&wp", 15 * 47) + string + Utils.substring("1#:Rr=jmaeg#wmip(deoi#./^~f3ppzrlpt|<\\non", 34 + 118)));
                wMSResponse.success = true;
                wMSResponse.message = Severity.valueOf(-18 + 116, "\u0006&( 2\",");
                return wMSResponse;
            }
            try {
                String string3;
                block6: {
                    String string4;
                    String string5;
                    block7: {
                        block5: {
                            Class.forName(Severity.valueOf(667 / 111, "ehe'}d{wo!g|a=b}ydl7SMTrmk"));
                            IVHost iVHost = VHostSingleton.getInstance((String)string2);
                            if (iVHost == null) break block5;
                            iVHost.shutdownApplication(string, true);
                            string3 = this.getFilename();
                            string3 = string3.substring(0, string3.lastIndexOf(47));
                            string5 = string + "_" + DateTime.now().toString(Utils.substring("rutwB]uv>\\]{zkj", 26 - 15)) + Severity.valueOf(34 + 68, "h=!9");
                            string4 = iVHost.getHomePath() + Severity.valueOf(-48 - 8, "g++('8>`3><5");
                            if (ZipUtils.zipDirectory((String)string3, (String)string4, (String)string5)) break block6;
                            break block7;
                        }
                        wMSResponse.message = Severity.valueOf(27 * 53, "Twlv\u007f<sqk egoaqc'iyzgeno{y~|");
                        break block4;
                    }
                    ConfigBase.log.error((Object)(Utils.substring("Qkgedl*\u007fc-o}sy{eq5wghusx}iwpn!", 750 / 157) + string + Severity.valueOf(23 * 21, "c0*f") + string4 + "/" + string5));
                }
                File file = new File(string3);
                ApplicationConfig.deleteFolder(file);
                File file2 = new File(string3.replace(Severity.valueOf(61 - -37, "m ++ h"), "/applications/"));
                ApplicationConfig.deleteFolder(file2);
                wMSResponse.success = true;
                wMSResponse.message = Utils.substring("Gwxechmyg`~1:", 1561 / 230) + string + Utils.substring("6 egoaqcc(z\u007fhoh}|vd~\u007fm", 53 + 106);
                ApplicationsConfig.deleteAppplicationInfoCache(string2, string);
            }
            catch (Exception exception) {
                wMSResponse.success = false;
                wMSResponse.message = exception.getMessage();
            }
        }
        if (wMSResponse.isSuccess()) {
            ConfigBase.log.info((Object)(Severity.valueOf(562 / 115, "V@US(HZB6-Jj|tfv4Tfgtpyzhtqq:!") + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.error((Object)(Severity.valueOf(124 + -55, "\u0017\u0003\u0014\u001ci\u000b\u001b\u0005wn\u000b5=7'1u\u0017'(538=)70.{b") + wMSResponse.message));
        return wMSResponse;
    }

    public static ApplicationConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("+60suLbi`", 47 - 50), string);
        hashMap.put(Severity.valueOf(58 + 19, ",>?\u001e0?6"), string2);
        return (ApplicationConfig)ApplicationConfig.getObjectFromREST(ApplicationConfig.getUrl(hashMap, ApplicationConfig.class), ApplicationConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        if (this.saveFieldList != null && !this.saveFieldList.contains(Severity.valueOf(10 + 37, "aq|w")) || this.name != null) {
            // empty if block
        }
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Severity.valueOf(40 + 70, "**#2 :$!?86"))) return bl;
        }
        if (this.description == null) return bl;
        if (!this.description.startsWith(Severity.valueOf(29 * 5, "fsaz"))) return bl;
        this.addWarningMessage(Utils.substring("22+:(2,)70.", 51 + 35), "Testing, can't start with 'warn'");
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isValid(ConstraintValidatorContext var1_1) {
        block8: {
            block7: {
                var2_2 = super.isValid(var1_1);
                if (this.saveFieldList != null && !this.saveFieldList.contains(Utils.substring("%:; \u0002&!14;2**", 89 + -12)) || this.httpStreamers == null || this.httpStreamersOptions == null) ** GOTO lbl25
                var3_3 = new ArrayList<String>();
                var4_4 = this.httpStreamers.iterator();
                break block8;
lbl6:
                // 1 sources

                while (true) {
                    this.addErrorMessage(var1_1, Utils.substring("ns|yY\u007f~hobuca", 537 / 85), Utils.substring("Vjnhh\u007fg*cxy~\\dcwrypd-8", 376 / 114) + var5_5);
                    var2_2 = false;
                    break block7;
                    break;
                }
                ** while (!this.httpStreamersOptions.contains((Object)var5_5.trim()))
            }
            if (!var3_3.contains(var5_5.trim())) {
                var3_3.add(var5_5.trim());
            }
        }
        while (true) {
            if (var4_4.hasNext()) {
                var5_5 = var4_4.next();
                if (var5_5.trim().length() <= 0) continue;
            } else {
                this.httpStreamers.clear();
                this.httpStreamers.addAll(var3_3);
                Collections.sort(this.httpStreamers);
lbl25:
                // 2 sources

                if (!(this.saveFieldList != null && !this.saveFieldList.contains(Severity.valueOf(9 * 47, "iido")) || this.name != null && this.name.trim().length() != 0)) {
                    this.addErrorMessage(var1_1, Utils.substring("blcj", 75 + -63), "Name cannot be empty.");
                    var2_2 = false;
                }
                if (this.saveFieldList != null) {
                    if (this.saveFieldList.contains(Severity.valueOf(-10 - 9, ")+<3#;# <99")) == false) return var2_2;
                }
                if (this.description == null) return var2_2;
                if (this.description.startsWith(Severity.valueOf(30 - -11, "lxyc\u007f")) == false) return var2_2;
                this.addErrorMessage(var1_1, Severity.valueOf(44 + 90, "bb{jxb|yg`~"), "Testing, can't start with 'error'");
                return false;
            }
            if (this.httpStreamersOptions != null) ** break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void deleteFolder(File var0) {
        block4: {
            block3: {
                block5: {
                    block6: {
                        var1_1 = var0.listFiles();
                        if (var1_1 == null) break block5;
                        break block6;
lbl4:
                        // 1 sources

                        while (true) {
                            var5_5 = var2_2[var4_4];
                            if (!var5_5.isDirectory()) break block3;
                            break block4;
                            break;
                        }
lbl8:
                        // 2 sources

                        while (var4_4 < var3_3) {
                            ** continue;
lbl10:
                            // 1 sources

                            ** GOTO lbl4
                        }
                        break block5;
lbl12:
                        // 2 sources

                        while (true) {
                            ++var4_4;
                            ** GOTO lbl8
                            break;
                        }
                    }
                    var2_2 = var1_1;
                    var3_3 = var2_2.length;
                    var4_4 = 0;
                    ** GOTO lbl8
                }
                var0.delete();
                return;
            }
            var5_5.delete();
            ** GOTO lbl12
        }
        ApplicationConfig.deleteFolder(var5_5);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse copyAction(String string) {
        WMSResponse wMSResponse;
        block9: {
            wMSResponse = new WMSResponse();
            try {
                String string2 = URLDecoder.decode(string, Severity.valueOf(11 * 9, "\u0016\u0010\u0003k\u007f"));
                String string3 = this.getStringVariable(Severity.valueOf(464 / 67, "pogz~Em`k"));
                String string4 = VHostsConfig.getVHostDir(string3) + Severity.valueOf(412 / 72, "*ehfo%") + this.name;
                String string5 = VHostsConfig.getVHostDir(string3) + Utils.substring("0#.,%k", 51 + 12) + string2;
                File file = new File(string4);
                File file2 = new File(string5);
                if (file2.exists()) {
                    wMSResponse.message = Utils.substring("Wghusx}iwpn!", 63 + 87) + string2 + Severity.valueOf(61 * 51, "'iexnmiw/ui{``f");
                    break block9;
                }
                if (!file.exists()) {
                    wMSResponse.message = Severity.valueOf(-25 - 27, "\r=>#923'=:8w") + this.name + Severity.valueOf(46 - 1, "-j`ub2}{a6r`pio");
                } else {
                    ApplicationConfig.copyDirectory(file, file2);
                    File file3 = new File(string5.replace(Utils.substring("b- >7}", 35 * 47), "/applications/"));
                    file3.mkdir();
                    wMSResponse.success = true;
                    wMSResponse.message = Utils.substring("Btujnkh~bcc.'", 28 + 7) + string2 + Severity.valueOf(11 * 21, "nh*8.-9++p\"'070%$>,67%");
                    ApplicationConfig applicationConfig = new ApplicationConfig(this.vhostName, string2);
                    try {
                        applicationConfig.loadObject();
                        applicationConfig.setName(string2);
                        applicationConfig.saveObject();
                        ApplicationsConfig.updateAppplicationInfoCache(string3, string2, applicationConfig);
                    }
                    catch (ConfigBase.ConfigBaseException configBaseException) {
                        ConfigBase.log.warn((Object)Severity.valueOf(27 * 41, "\u0016&:$%x*;-539\u007f#.2*!!f&89&\"/,:&??"), (Throwable)configBaseException);
                    }
                }
            }
            catch (SecurityException securityException) {
                wMSResponse.message = securityException.getMessage();
                ConfigBase.log.warn((Object)Severity.valueOf(19 * 21, "Jb~`a4vygapt|<|nolhabplii"), (Throwable)securityException);
            }
            catch (IOException iOException) {
                wMSResponse.message = iOException.getMessage();
                ConfigBase.log.warn((Object)Severity.valueOf(126 + -82, "I\u007fa}b1q|dl\u007fy\u007f9{klqw|!5+,*"), (Throwable)iOException);
            }
        }
        if (!wMSResponse.isSuccess()) {
            ConfigBase.log.error((Object)(Utils.substring("TB[]*J\\D4/S~bj4Tfgtpyzhtqq:!", 44 + 90) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.info((Object)(Severity.valueOf(58 + 96, "H^OI>^PH8#Gjv~(Hz{`dmndx}}.5") + wMSResponse.message));
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse startAction(String string) {
        WMSResponse wMSResponse;
        block5: {
            block4: {
                wMSResponse = new WMSResponse();
                try {
                    Class.forName(Utils.substring("0;8x 7. :r*3,.wjlwq(N^Aexx", 9 * 27));
                    IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                    if (iVHost != null) {
                        iVHost.startApplicationInstance(this.appName);
                        wMSResponse.success = true;
                        wMSResponse.message = Severity.valueOf(561 / 155, "Btujnkh~bcc.'") + this.appName + Utils.substring("91agugbr|", 67 + -51);
                    }
                    break block4;
                }
                catch (Exception exception) {
                    ConfigBase.log.error((Object)Utils.substring("\u0011\u0001\u0016\u0012g\t\u0019\u0003ql\u001e:.\"%r\u0012$%:>;8.233", 87 + 12), (Throwable)exception);
                    wMSResponse.message = exception.getMessage();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ConfigBase.log.error((Object)Severity.valueOf(9 * 45, "GSDL9[KU'>Lt`pw$Dvwd`ijxdaa"), (Throwable)classNotFoundException);
                    wMSResponse.message = Utils.substring("Gdh |)lbbi.n0f}dnt6d}kl~n3", 461 / 94);
                }
                break block5;
            }
            wMSResponse.message = Utils.substring("\u001748p,y<229~> vmt~d&tm{|n~#", 80 + 36);
        }
        if (!wMSResponse.isSuccess()) return wMSResponse;
        ConfigBase.log.info((Object)(Severity.valueOf(29 * 31, "QAVR'IYC1,^znbe2Rdez~{xnrss$?") + wMSResponse.message));
        return wMSResponse;
    }

    public WMSResponse restartAction(String string) {
        return this.shutdownAction(string);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse shutdownAction(String string) {
        WMSResponse wMSResponse;
        block5: {
            block4: {
                wMSResponse = new WMSResponse();
                try {
                    Class.forName(Utils.substring("69:v.5,&<p(-2l5,*53f\u0000\u001c\u0003#>:", 17 * 5));
                    IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                    if (iVHost == null) break block4;
                    iVHost.shutdownApplication(this.appName);
                    wMSResponse.success = true;
                    wMSResponse.message = Severity.valueOf(59 * 25, "\u000245*.+(>\"##ng") + this.appName + Severity.valueOf(13 * 37, "hb0,02#'>$");
                }
                catch (Exception exception) {
                    wMSResponse.message = exception.getMessage();
                }
            }
            wMSResponse.message = Severity.valueOf(6 + 61, "\u0000%+a3h/#%(m/o'>%)5u%2*/?)r");
            break block5;
            catch (ClassNotFoundException classNotFoundException) {
                wMSResponse.message = Severity.valueOf(57 - 13, "Ol`(d1tzzq6v8nulf|>l%34&6k");
            }
        }
        if (!wMSResponse.isSuccess()) {
            ConfigBase.log.error((Object)(Utils.substring("QAVR'IYC1,_k|dp`g4Tfgtpyzhtqq:!", 131 / 41) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.info((Object)(Utils.substring("WCT\\)K[E7.]ubfrfa6Vhivr\u007f|jvoo8#", 915 / 163) + wMSResponse.message));
        return wMSResponse;
    }
}

