/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.AppShortObject;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfig;
import com.wowza.wms.rest.vhosts.applications.drm.DRMConfig;
import com.wowza.wms.rest.vhosts.applications.dvr.DVRConfig;
import com.wowza.wms.rest.vhosts.applications.modules.ModulesConfig;
import com.wowza.wms.rest.vhosts.applications.streamconfiguration.StreamConfigurationConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderAppConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Applications")
@WMSDescription(text="Application Operations", get="Retrieves the list of Applications for the specifed vhost", post="Adds an Application to the list of Applications  for the specifed vhost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications", restVerbs="GET,POST", xmlFilename="")
public class ApplicationsConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="applications")
    @XStreamImplicit(itemFieldName="Application")
    private List<AppShortObject> a = new ArrayList<AppShortObject>();
    @XStreamOmitField
    protected static HashMap<String, HashMap<String, ApplicationConfig>> applicationInfoCache = new HashMap();

    public ApplicationsConfig() {
    }

    public ApplicationsConfig(String string) {
        this.vhostName = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(55 * 39, "7*,71\b&%,"));
        this.vhostName = this.getStringVariable(Severity.valueOf(7 * 17, "!06)/\u0012<3:"));
    }

    public List<AppShortObject> getApplicationsList() {
        return this.a;
    }

    public void setApplicationsList2(List<AppShortObject> list) {
        this.a = list;
    }

    @Override
    public String getFilename() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        if (this.vhostName == null) {
            this.vhostName = this.getStringVariable(Severity.valueOf(54 + 90, "fy}``[wz}"));
        }
        ApplicationsConfig.initApplicationInfoCache(this.vhostName);
        this.a.clear();
        HashMap<String, ApplicationConfig> hashMap = applicationInfoCache.get(this.vhostName);
        if (hashMap == null) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashMap.keySet());
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.a.add(new AppShortObject(string, applicationInfoCache.get(this.vhostName).get(string), this.restURI + "/" + string));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        ApplicationConfig applicationConfig = new ApplicationConfig();
        Representation representation2 = applicationConfig.post(representation, this.getRequest());
        this.setStatus(applicationConfig.getStatus());
        if (applicationConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(applicationConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static ApplicationsConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (ApplicationsConfig)ApplicationsConfig.getObjectFromREST(ApplicationsConfig.getUrl(Utils.substring("uljusFhgn", 29 * 31), string, ApplicationsConfig.class), ApplicationsConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initApplicationInfoCache(String string) {
        try {
            if (applicationInfoCache.containsKey(string)) return;
            Class.forName(Severity.valueOf(1277 / 210, "ehe'}d{wo!g|a=b}ydl7SMTrmk"));
            IVHost iVHost = VHostSingleton.getInstance((String)string);
            if (iVHost == null) return;
            applicationInfoCache.put(string, new HashMap());
            List list = iVHost.getApplicationFolderNames();
            Collections.sort(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ApplicationConfig applicationConfig = new ApplicationConfig(string, string2);
                if (!applicationConfig.loadObject()) continue;
                ApplicationsConfig.updateAppplicationInfoCache(string, string2, applicationConfig);
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateAppplicationInfoCache(String string, String string2, ApplicationConfig applicationConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) {
            return;
        }
        applicationInfoCache.get(string).put(string2, applicationConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, DRMConfig dRMConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setDrmConfig(dRMConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, DVRConfig dVRConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setDvrConfig(dVRConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, TranscoderAppConfig transcoderAppConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setTranscoderConfig(transcoderAppConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, ModulesConfig modulesConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setModules(modulesConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void updateAppplicationInfoCache(String string, String string2, StreamConfigurationConfig streamConfigurationConfig) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) return;
        if (!applicationInfoCache.get(string).containsKey(string2)) return;
        applicationInfoCache.get(string).get(string2).setStreamConfig(streamConfigurationConfig);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void deleteAppplicationInfoCache(String string, String string2) {
        ApplicationsConfig.initApplicationInfoCache(string);
        if (!applicationInfoCache.containsKey(string)) {
            return;
        }
        applicationInfoCache.get(string).remove(string2);
    }
}

