/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.drm;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="BuyDRMStreamMaps")
@WMSDescription(text="Application BuyDRMStreamMaps", get="Retrieves the BuyDRM stream mapfile for the specified Application", put="Updates the BuyDRM stream mapfile for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/drm/buydrmmapfile", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class BuyDRMStreamMapsConfig
extends ApplicationConfigBase {
    @JsonProperty(value="buyDRMStreamNameMapFile")
    @XStreamAlias(value="BuyDRMStreamNameMapFile")
    @WMSXMLProperty(root="/Root/Application", name="drmBuyDRMStreamNameMapFile", defaultValue="")
    protected String drmBuyDRMStreamNameMapFile;
    @JsonProperty(value="buyDRMStreamMaps")
    @XStreamImplicit(itemFieldName="BuyDRMStreamMap")
    protected List<BuyDRMStreamMapConfig> buyDRMStreamMapList = new ArrayList<BuyDRMStreamMapConfig>();

    public List<BuyDRMStreamMapConfig> getBuyDRMStreamMapList() {
        return this.buyDRMStreamMapList;
    }

    public void setBuyDRMStreamMapList(List<BuyDRMStreamMapConfig> list) {
        this.buyDRMStreamMapList = list;
    }

    public String getDrmBuyDRMStreamNameMapFile() {
        return this.drmBuyDRMStreamNameMapFile;
    }

    public void setDrmBuyDRMStreamNameMapFile(String string) {
        this.drmBuyDRMStreamNameMapFile = string;
    }

    public BuyDRMStreamMapsConfig() {
    }

    public BuyDRMStreamMapsConfig(String string, String string2) {
        super(string, string2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        int n;
        BufferedReader bufferedReader;
        DataInputStream dataInputStream;
        boolean bl = false;
        if (!super.loadXMLNode(node, string)) return bl;
        this.setPathMap();
        String string2 = SystemUtils.expandEnvironmentVariables((String)this.drmBuyDRMStreamNameMapFile, (Map)this.pathMap);
        if (this.queryParam != null && this.queryParam.toLowerCase().startsWith(Severity.valueOf(57 * 5, "{wseocna8"))) {
            this.drmBuyDRMStreamNameMapFile = string2 = this.queryParam.substring(9);
            string2 = SystemUtils.expandEnvironmentVariables((String)string2, (Map)this.pathMap);
        }
        this.buyDRMStreamMapList.clear();
        if (string2 == null) return bl;
        if (string2.isEmpty()) return bl;
        try {
            File file = new File(string2);
            if (!file.exists()) return bl;
            this.version = file.lastModified() + "";
            FileInputStream fileInputStream = new FileInputStream(string2);
            dataInputStream = new DataInputStream(fileInputStream);
            bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            n = 0;
        }
        catch (IOException iOException) {
            ConfigBase.log.warn((Object)(Utils.substring("Uthjeof,aantx|t4fbe}xw;q|n?cnlemb<'", 543 / 101) + string), (Throwable)iOException);
            return bl;
        }
        block3: while (true) {
            String string3;
            if ((string3 = bufferedReader.readLine()) == null) {
                dataInputStream.close();
                Collections.sort(this.buyDRMStreamMapList);
                return true;
            }
            String[] stringArray = string3.split("=");
            if (stringArray.length != 2) continue;
            stringArray[1] = stringArray[1].substring(1, stringArray[1].length() - 1);
            BuyDRMStreamMapConfig buyDRMStreamMapConfig = new BuyDRMStreamMapConfig();
            buyDRMStreamMapConfig.streamName = stringArray[0];
            buyDRMStreamMapConfig.order = n++;
            String[] stringArray2 = stringArray[1].split(",");
            int n2 = 0;
            while (true) {
                block11: {
                    String[] stringArray3;
                    block12: {
                        block10: {
                            if (n2 >= stringArray2.length) break block10;
                            stringArray3 = stringArray2[n2].split(":");
                            if (stringArray3.length != 2) break block11;
                            break block12;
                        }
                        this.buyDRMStreamMapList.add(buyDRMStreamMapConfig);
                        continue block3;
                    }
                    String string4 = stringArray3[0].toLowerCase().trim();
                    if (string4.equals(Utils.substring("jgzma", 16 - 15))) {
                        buyDRMStreamMapConfig.keyID = stringArray3[1];
                    }
                    if (string4.equals(Utils.substring("'*(3-'>\"(", 96 + -28))) {
                        buyDRMStreamMapConfig.contentID = stringArray3[1];
                    }
                    if (string4.equals(Severity.valueOf(80 + 107, "vyyw~)%"))) {
                        buyDRMStreamMapConfig.mediaID = stringArray3[1];
                    }
                }
                ++n2;
            }
            break;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(706 / 227, "Emic'ff~+jb{at1~|uq\u007fy\u007f9ionx\u007fr lcs$fiin`m1,") + string), (Throwable)fileNotFoundException);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected WMSResponse saveObjectToFile(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Utils.substring("\u001b\u000f\u0018\u0018m\u000f\u001f\u0019kr\u00005#?9?y\u0002\u0016\u0010}v", 54 - -19) + string + Severity.valueOf(-27 - -12, "xhs\u001d;v#*8>>|.60w!ol``('(Ge\u007f,nab}xfg}{q7{q{u{xm1")));
            wMSResponse.success = true;
            wMSResponse.message = Utils.substring("\u0018-;++", 27 - 48);
            return wMSResponse;
        }
        wMSResponse = super.saveObjectToFile(string);
        if (!wMSResponse.isSuccess()) return wMSResponse;
        this.setPathMap();
        String string2 = SystemUtils.expandEnvironmentVariables((String)this.drmBuyDRMStreamNameMapFile, (Map)this.pathMap);
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Severity.valueOf(23 * 13, "iytJ]]Bfaqt{ZyiVroi"))) return wMSResponse;
        }
        if (string2 == null) return wMSResponse;
        if (string2.isEmpty()) return wMSResponse;
        if (!wMSResponse.isSuccess()) return wMSResponse;
        wMSResponse.success = true;
        Collections.sort(this.buyDRMStreamMapList);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string2), false));
            Iterator<BuyDRMStreamMapConfig> iterator = this.buyDRMStreamMapList.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    bufferedWriter.close();
                    wMSResponse.success = true;
                    wMSResponse.message = Utils.substring("Vgqmm", 436 / 87);
                    return wMSResponse;
                }
                BuyDRMStreamMapConfig buyDRMStreamMapConfig = iterator.next();
                String string3 = "";
                string3 = string3 + buyDRMStreamMapConfig.streamName;
                string3 = string3 + Utils.substring(">\u007f", 375 / 121);
                string3 = string3 + Severity.valueOf(84 + -53, "texKg>") + buyDRMStreamMapConfig.keyID + ",";
                string3 = string3 + Severity.valueOf(94 + 119, "699,<4/\u00159d") + buyDRMStreamMapConfig.contentID + ",";
                string3 = string3 + Utils.substring("-$&*%\f\"}", -44 - 20) + buyDRMStreamMapConfig.mediaID + "}";
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
            ConfigBase.log.warn((Object)(Severity.valueOf(-55 - -13, "\u0006%7;6>1}->6(,$d625-('k!,>o3><5=2lw") + string), (Throwable)exception);
            return wMSResponse;
        }
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    public static BuyDRMStreamMapsConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        return BuyDRMStreamMapsConfig.getObjectFromREST(string, string2, "", wMSClientSecurity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BuyDRMStreamMapsConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        String string4;
        block6: {
            block5: {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(Severity.valueOf(12 + 38, "d{{fbYyt\u007f"), string);
                hashMap.put(Severity.valueOf(64 + 46, "/? \u001f3>1"), string2);
                string4 = BuyDRMStreamMapsConfig.getUrl(hashMap, BuyDRMStreamMapsConfig.class);
                if (string3 == null) break block5;
                if (!string3.isEmpty()) break block6;
            }
            return (BuyDRMStreamMapsConfig)BuyDRMStreamMapsConfig.getObjectFromREST(string4, BuyDRMStreamMapsConfig.class, wMSClientSecurity);
        }
        try {
            string4 = string4 + "?" + URLEncoder.encode(string3, Utils.substring("\u0011\u0011\u0000jp", 98 + 2));
            return (BuyDRMStreamMapsConfig)BuyDRMStreamMapsConfig.getObjectFromREST(string4, BuyDRMStreamMapsConfig.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ConfigBase.log.warn((Object)(Utils.substring("Pht}yzd~ykk0t|p{q\u007fy\u007f#:", 753 / 142) + string3), (Throwable)unsupportedEncodingException);
            return (BuyDRMStreamMapsConfig)BuyDRMStreamMapsConfig.getObjectFromREST(string4, BuyDRMStreamMapsConfig.class, wMSClientSecurity);
        }
    }

    @JsonAutoDetect(value={JsonMethod.NONE})
    @XStreamAlias(value="BuyDRMStreamMap")
    public static class BuyDRMStreamMapConfig
    extends ConfigBase
    implements Comparable<BuyDRMStreamMapConfig> {
        @XStreamOmitField
        protected boolean removed;
        @JsonProperty(value="streamName")
        @XStreamAlias(value="StreamName")
        protected String streamName;
        @JsonProperty(value="order")
        @XStreamAlias(value="Order")
        protected int order;
        @JsonProperty(value="keyID")
        @XStreamAlias(value="KeyID")
        protected String keyID;
        @JsonProperty(value="contentID")
        @XStreamAlias(value="ContentID")
        protected String contentID;
        @JsonProperty(value="mediaID")
        @XStreamAlias(value="MediaID")
        protected String mediaID;

        public String getStreamName() {
            return this.streamName;
        }

        public void setStreamName(String string) {
            this.streamName = string;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int n) {
            this.order = n;
        }

        public String getKeyID() {
            return this.keyID;
        }

        public void setKeyID(String string) {
            this.keyID = string;
        }

        public String getContentID() {
            return this.contentID;
        }

        public void setContentID(String string) {
            this.contentID = string;
        }

        public String getMediaID() {
            return this.mediaID;
        }

        public void setMediaID(String string) {
            this.mediaID = string;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean bl) {
            this.removed = bl;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int compareTo(BuyDRMStreamMapConfig buyDRMStreamMapConfig) {
            if (this.order > buyDRMStreamMapConfig.order) {
                return 1;
            }
            if (this.order >= buyDRMStreamMapConfig.order) return 0;
            return -1;
        }
    }
}

