/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.dvr;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.server.ServerStatusConfig;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.ApplicationsConfig;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="DVR")
@WMSDescription(text="Application DVR", get="Retrieves the DVR configuration for the specified Application", put="Updates the DVR configuration for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/dvr", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class DVRConfig
extends ApplicationConfigBase {
    @JsonProperty(value="licenseType")
    @XStreamAlias(value="LicenseType")
    protected String licenseType;
    @JsonProperty(value="inUse")
    @XStreamAlias(value="InUse")
    protected boolean inUse;
    @JsonProperty(value="dvrEnable")
    @XStreamAlias(value="DVREnable")
    @WMSXMLProperty(root="/Root/Application/Manager", name="DVREnable", defaultValue="false")
    protected boolean dvrEnable;
    @JsonProperty(value="recorders")
    @XStreamAlias(value="Recorders")
    @WMSXMLVariable(xpath="/Root/Application/DVR/Recorders/text()")
    protected String recorders;
    @JsonProperty(value="store")
    @XStreamAlias(value="Store")
    @WMSXMLVariable(xpath="/Root/Application/DVR/Store/text()")
    protected String store;
    @JsonProperty(value="windowDuration")
    @XStreamAlias(value="WindowDuration")
    @WMSXMLVariable(xpath="/Root/Application/DVR/WindowDuration/text()")
    protected int windowDuration;
    @JsonProperty(value="storageDir")
    @XStreamAlias(value="StorageDir")
    @WMSXMLVariable(xpath="/Root/Application/DVR/StorageDir/text()")
    protected String storageDir;
    @JsonProperty(value="archiveStrategy")
    @XStreamAlias(value="ArchiveStrategy")
    @WMSXMLVariable(xpath="/Root/Application/DVR/ArchiveStrategy/text()")
    protected String archiveStrategy;
    @JsonProperty(value="dvrOnlyStreaming")
    @XStreamAlias(value="DVROnlyStreaming")
    @WMSXMLProperty(root="/Root/Application/Manager", name="DVROnlyStreaming", defaultValue="false")
    protected boolean dvrOnlyStreaming;
    @JsonProperty(value="startRecordingOnStartup")
    @XStreamAlias(value="StartRecordingOnStartup")
    @WMSXMLProperty(root="/Root/Application/DVR", name="startRecordingOnStartup", defaultValue="true")
    protected boolean startRecordingOnStartup;
    @JsonProperty(value="dvrEncryptionSharedSecret")
    @XStreamAlias(value="DVREncryptionSharedSecret")
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrEncryptionSharedSecret", defaultValue="")
    protected String dvrEncryptionSharedSecret;
    @JsonProperty(value="dvrMediaCacheEnabled")
    @XStreamAlias(value="DVRMediaCacheEnabled")
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrMediaCacheEnabled", defaultValue="false")
    protected boolean dvrMediaCacheEnabled;
    @JsonProperty(value="httpRandomizeMediaName")
    @XStreamAlias(value="HTTPRandomizeMediaName")
    @WMSXMLProperty(root="/Root/Application/DVR", name="httpRandomizeMediaName", defaultValue="false")
    protected boolean httpRandomizeMediaName;

    public DVRConfig() {
    }

    public DVRConfig(String string, String string2) {
        super(string, string2);
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String string) {
        this.licenseType = string;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean bl) {
        this.inUse = bl;
    }

    public boolean isDvrEnable() {
        return this.dvrEnable;
    }

    public void setDvrEnable(boolean bl) {
        this.dvrEnable = bl;
    }

    public String getRecorders() {
        return this.recorders;
    }

    public void setRecorders(String string) {
        this.recorders = string;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String string) {
        this.store = string;
    }

    public int getWindowDuration() {
        return this.windowDuration;
    }

    public void setWindowDuration(int n) {
        this.windowDuration = n;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public void setStorageDir(String string) {
        this.storageDir = string;
    }

    public String getArchiveStrategy() {
        return this.archiveStrategy;
    }

    public void setArchiveStrategy(String string) {
        this.archiveStrategy = string;
    }

    public boolean isDvrOnlyStreaming() {
        return this.dvrOnlyStreaming;
    }

    public void setDvrOnlyStreaming(boolean bl) {
        this.dvrOnlyStreaming = bl;
    }

    public boolean isStartRecordingOnStartup() {
        return this.startRecordingOnStartup;
    }

    public void setStartRecordingOnStartup(boolean bl) {
        this.startRecordingOnStartup = bl;
    }

    public String getDvrEncryptionSharedSecret() {
        return this.dvrEncryptionSharedSecret;
    }

    public void setDvrEncryptionSharedSecret(String string) {
        this.dvrEncryptionSharedSecret = string;
    }

    public boolean isDvrMediaCacheEnabled() {
        return this.dvrMediaCacheEnabled;
    }

    public void setDvrMediaCacheEnabled(boolean bl) {
        this.dvrMediaCacheEnabled = bl;
    }

    public boolean isHttpRandomizeMediaName() {
        return this.httpRandomizeMediaName;
    }

    public void setHttpRandomizeMediaName(boolean bl) {
        this.httpRandomizeMediaName = bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        this.vhostName = this.getStringVariable(Severity.valueOf(23 * 47, "ortoiP~-$"));
        this.appName = this.getStringVariable(Utils.substring("*<=\u0000.=4", 3 * 25));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhostName, this.appName, this);
        return super.saveObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        try {
            Class.forName(Severity.valueOf(329 / 88, "`kh(pg~pj\"zc|>bwabpd9K|hmyo"));
            ServerStatusConfig serverStatusConfig = ServerStatusConfig.getThreadLocalObject();
            this.licenseType = serverStatusConfig.isDvrLicensed() ? serverStatusConfig.getLicenseType() : Severity.valueOf(214 / 38, "KisD`inb~kk");
            this.inUse = serverStatusConfig.isDvrInUse();
            return super.loadXMLNode(node, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.loadXMLNode(node, string);
        }
    }

    public static DVRConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring(")(.17\n$+\"", 59 * 45), string);
        hashMap.put(Severity.valueOf(832 / 148, "dvwFhgn"), string2);
        return (DVRConfig)DVRConfig.getObjectFromREST(DVRConfig.getUrl(hashMap, DVRConfig.class), DVRConfig.class, wMSClientSecurity);
    }
}

