/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.dvr;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLAdvSetting;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigAdvBase;
import java.util.ArrayList;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="DVRAdv")
@WMSDescription(text="Application Advanced DVR", get="Retrieves the advanced DVR configuration for the specified Application", put="Updates the advanced DVR configuration for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/dvr/adv", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class DVRConfigAdv
extends ApplicationConfigAdvBase {
    @XStreamOmitField
    protected String name;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="streamTimeout", hasDefault=true, defaultInt=300000)
    @WMSXMLProperty(root="/Root/Application/DVR", name="streamTimeout")
    protected int streamTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrMinimumAvailableChunks", hasDefault=true, defaultInt=3)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrMinimumAvailableChunks")
    protected int dvrMinimumAvailableChunks;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrChunkGroupingSeconds", hasDefault=true, defaultInt=600)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrChunkGroupingSeconds")
    protected int dvrChunkGroupingSeconds;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrAppendDiscontinuityDelta", hasDefault=true, defaultInt=0)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrAppendDiscontinuityDelta")
    protected int dvrAppendDiscontinuityDelta;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrMaxChunkLogCount", hasDefault=true, defaultInt=10)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrMaxChunkLogCount")
    protected int dvrMaxChunkLogCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrMaxRecountDurationLogCount", hasDefault=true, defaultInt=30)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrMaxRecountDurationLogCount")
    protected int dvrMaxRecountDurationLogCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrAudioOnlyChunkTargetDuration", hasDefault=true, defaultInt=2000)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrAudioOnlyChunkTargetDuration")
    protected int dvrAudioOnlyChunkTargetDuration;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrChunkDurationMinimum", hasDefault=true, defaultInt=1500)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrChunkDurationMinimum")
    protected int dvrChunkDurationMinimum;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrWaitForCodecTime", hasDefault=true, defaultInt=8000)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrWaitForCodecTime")
    protected int dvrWaitForCodecTime;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="recordVideo", hasDefault=true, defaultBoolean=true)
    @WMSXMLProperty(root="/Root/Application/DVR", name="recordVideo")
    protected boolean recordVideo;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="recordAudio", hasDefault=true, defaultBoolean=true)
    @WMSXMLProperty(root="/Root/Application/DVR", name="recordAudio")
    protected boolean recordAudio;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="recordData", hasDefault=true, defaultBoolean=true)
    @WMSXMLProperty(root="/Root/Application/DVR", name="recordData")
    protected boolean recordData;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrAllowableAVPacketDelta", hasDefault=true, defaultInt=2000)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrAllowableAVPacketDelta")
    protected int dvrAllowableAVPacketDelta;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrPacketSortTime", hasDefault=true, defaultInt=0)
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrPacketSortTime")
    protected int dvrPacketSortTime;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrPlaylistRequestDelegate", hasDefault=true, defaultString="")
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrPlaylistRequestDelegate")
    protected String dvrPlaylistRequestDelegate;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="DVR", name="dvrSanJosePlaylistVersion", hasDefault=true, defaultString="2.0")
    @WMSXMLProperty(root="/Root/Application/DVR", name="dvrSanJosePlaylistVersion")
    protected String dvrSanJosePlaylistVersion;

    public DVRConfigAdv() {
    }

    public DVRConfigAdv(String string, String string2) {
        super(string, string2);
    }

    @Override
    protected void subConstructor(boolean bl) {
        super.subConstructor(bl);
        this.pathsForUndocumentedProperties = new ArrayList<String>();
        this.pathsForUndocumentedProperties.add(Utils.substring("\"\\`\u007fe=Rdez~{xnrss1[VS", 28 + -15));
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = super.loadObject();
        if (!bl) {
            return bl;
        }
        this.removeAdvSetting(Severity.valueOf(496 / 80, "BQZ"), "dvrEncryptionSharedSecret");
        this.removeAdvSetting(Utils.substring("[\u0016\u0013", 25 * 23), "startRecordingOnStartup");
        this.removeAdvSetting(Severity.valueOf(45 * 39, "\u001f\n\u000f"), "dvrMediaCacheEnabled");
        return bl;
    }

    public static DVRConfigAdv getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        return DVRConfigAdv.getObjectFromREST(string, string2, "", wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DVRConfigAdv getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(898 / 179, "snh{}Djah"), string);
        hashMap.put(Utils.substring("5%&\u001994?", -23 - 21), string2);
        String string4 = DVRConfigAdv.getUrl(hashMap, DVRConfigAdv.class);
        if (string3 == null) return (DVRConfigAdv)DVRConfigAdv.getObjectFromREST(string4, DVRConfigAdv.class, wMSClientSecurity);
        if (string3.isEmpty()) return (DVRConfigAdv)DVRConfigAdv.getObjectFromREST(string4, DVRConfigAdv.class, wMSClientSecurity);
        string4 = string4 + "?" + string3;
        return (DVRConfigAdv)DVRConfigAdv.getObjectFromREST(string4, DVRConfigAdv.class, wMSClientSecurity);
    }
}

