/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.instances.InstanceConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Instances")
@WMSDescription(text="Application Instances", get="Retrieves the list of Instances for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances", restVerbs="GET", xmlFilename="")
public class InstancesConfig
extends ApplicationConfigBase {
    @JsonProperty(value="instanceList")
    @XStreamImplicit(itemFieldName="InstanceList")
    protected List<InstanceConfig> instanceList = null;

    public InstancesConfig() {
    }

    public InstancesConfig(String string, String string2) {
        super(string, string2);
    }

    public List<InstanceConfig> getInstanceList() {
        return this.instanceList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InstanceConfig getInstanceByName(String string) {
        InstanceConfig instanceConfig;
        InstanceConfig instanceConfig2 = null;
        Iterator<InstanceConfig> iterator = this.instanceList.iterator();
        do {
            if (!iterator.hasNext()) return instanceConfig2;
        } while (!(instanceConfig = iterator.next()).getInstanceName().equals(string));
        return instanceConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl;
        block3: {
            IApplication iApplication;
            bl = false;
            this.vhostName = this.getStringVariable(Utils.substring("zea|d_s~q", 24 - -20));
            this.appName = this.getStringVariable(Severity.valueOf(59 * 53, "vhiTzqx"));
            this.instanceList = new ArrayList<InstanceConfig>();
            try {
                Class.forName(Utils.substring("kfg%{byuq?e~g;`\u007fwjn5UKVpsu", 113 + -105));
                IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                if (iVHost == null || (iApplication = iVHost.getApplication(this.appName)) == null) break block3;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logException(Severity.valueOf(5 * 23, "\u001a:&\"66:?(\u001f209if,okdbHjcohx"), classNotFoundException);
                break block3;
            }
            for (String string : iApplication.getAppInstanceNames()) {
                InstanceConfig instanceConfig = new InstanceConfig(this.vhostName, this.appName, string);
                instanceConfig.loadObject();
                this.instanceList.add(instanceConfig);
            }
            bl = true;
        }
        Collections.sort(this.instanceList);
        return bl;
    }

    public static InstancesConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(785 / 128, "pogz~Em`k"), string);
        hashMap.put(Severity.valueOf(58 + 54, "1!\"\u001d583"), string2);
        return (InstancesConfig)InstancesConfig.getObjectFromREST(InstancesConfig.getUrl(hashMap, InstancesConfig.class), InstancesConfig.class, wMSClientSecurity);
    }
}

