/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.incomingstreams;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.http.streammanager.NextLoadMessages;
import com.wowza.wms.livestreamrecord.manager.StreamRecorder;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.instances.InstanceUtils;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.util.MediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="IncomingStream")
@WMSDescription(text="Application Instance Incoming Stream", get="Retrieves the Incoming Stream information for the specifed Incoming Stream")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/incomingstreams/{streamName}", restVerbs="GET", xmlFilename="Application.xml")
public class IncomingStreamConfig
extends ApplicationConfigBase
implements Comparable<IncomingStreamConfig> {
    @JsonProperty(value="applicationInstance")
    @XStreamAlias(value="ApplicationInstance")
    protected String instanceName = null;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName = null;
    @JsonProperty(value="sourceIp")
    @XStreamAlias(value="SourceIp")
    protected String sourceIp;
    @JsonProperty(value="isRecordingSet")
    @XStreamAlias(value="IsRecordingSet")
    protected boolean recordingSet;
    @JsonProperty(value="isStreamManagerStream")
    @XStreamAlias(value="IsStreamManagerStream")
    protected boolean managedStream;
    @JsonProperty(value="isPublishedToVOD")
    @XStreamAlias(value="IsPublishedToVOD")
    protected boolean publishedToVOD;
    @JsonProperty(value="isConnected")
    @XStreamAlias(value="IsConnected")
    protected boolean connected;

    public IncomingStreamConfig() {
        this.sourceIp = Utils.substring(" 8<66-5", -51 - -40);
        this.recordingSet = false;
        this.managedStream = false;
        this.publishedToVOD = false;
        this.connected = false;
        String string = Utils.substring("agy\u007fmcmj^p\u007fv", 81 + 55);
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(7 * 7, "bfaqt{Yyt\u007f");
        this.addFieldForKeyMap(string2, string2);
    }

    public IncomingStreamConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.sourceIp = Utils.substring("!;=97.4", -64 - -52);
        this.recordingSet = false;
        this.managedStream = false;
        this.publishedToVOD = false;
        this.connected = false;
        this.instanceName = string3;
        this.streamName = string4;
        String string5 = Severity.valueOf(11 * 19, "8<  484=\u0017;69");
        this.addFieldForKeyMap(string5, string5);
        this.addToStringKeyMap(Utils.substring("53-+!/!&\n$+\"", -37 - -1), string3);
        String string6 = Utils.substring("4<;/*!\u0003/\"5", -47 + 118);
        this.addFieldForKeyMap(string6, string6);
        this.addToStringKeyMap(Severity.valueOf(3 * 9, "hho{~mOcna"), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(536 / 80, "oi{}keoh@n}t"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(640 / 110, "vrumhgEm`k"));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String string) {
        this.sourceIp = string;
    }

    public boolean isRecordingSet() {
        return this.recordingSet;
    }

    public boolean isManagedStream() {
        return this.managedStream;
    }

    public boolean isPublishedToVOD() {
        return this.publishedToVOD;
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        this.vhostName = this.getStringVariable(Severity.valueOf(47 * 27, "#>8+-\u0014:18"));
        this.appName = this.getStringVariable(Utils.substring("dvwFhgn", 1313 / 234));
        this.instanceName = this.getStringVariable(Severity.valueOf(1310 / 211, "oi{}keoh@n}t"));
        this.streamName = this.getStringVariable(Utils.substring("njme`oMehc", -42 - 57));
        MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString((String)this.streamName);
        if (mediaCasterStreamId.getLiveStreamPacketizer() != null) return bl;
        if (mediaCasterStreamId.getLiveStreamRepeater() != null) {
            return bl;
        }
        try {
            String string;
            IMediaStream iMediaStream;
            block17: {
                Client client;
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                block13: {
                                    IApplicationInstance iApplicationInstance;
                                    block10: {
                                        block11: {
                                            Map map;
                                            ArrayList arrayList;
                                            MediaCasterStreamMap mediaCasterStreamMap;
                                            MediaCasterStreamManager mediaCasterStreamManager;
                                            ArrayList arrayList2;
                                            Class.forName(Severity.valueOf(53 - -60, "2=>z\"9 \"8t,1.p)hnqw*LPOgz~"));
                                            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                                            if (iVHost == null) return bl;
                                            IApplication iApplication = iVHost.getApplication(this.appName);
                                            if (iApplication == null) return bl;
                                            iApplicationInstance = iApplication.getAppInstance(this.instanceName);
                                            if (iApplicationInstance == null) return bl;
                                            String string2 = iApplicationInstance.getStreamType();
                                            if (StreamRecorder.isLiveRepeaterEdge((String)string2, (IApplicationInstance)iApplicationInstance)) {
                                                this.streamName = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)iApplicationInstance, null, (String)this.streamName);
                                                this.sourceIp = this.a(MediaCasterUtils.handleStreamAliasFile((IApplicationInstance)iApplicationInstance, (String)this.streamName));
                                            }
                                            if ((arrayList2 = (ArrayList)(mediaCasterStreamManager = (mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams()).getStreamManager()).getStreamList()).indexOf(this.streamName) > -1) {
                                                this.managedStream = true;
                                                bl = true;
                                            }
                                            if ((arrayList = (ArrayList)iApplicationInstance.getPublishStreamNames()).contains(this.streamName)) {
                                                bl = true;
                                                this.connected = true;
                                            }
                                            if ((map = iVHost.getLiveStreamRecordManager().getRecordersMap(iApplicationInstance)).containsKey(this.streamName)) {
                                                this.recordingSet = true;
                                                bl = true;
                                            }
                                            if (!bl) return bl;
                                            StreamItem streamItem = iApplicationInstance.getVHost().getStreamTypes().getStreamDef(string2);
                                            boolean bl2 = false;
                                            if (streamItem != null && !streamItem.getProperties().getPropertyBoolean(Utils.substring("0)\u00175+;", 32 - 39), false)) {
                                                this.publishedToVOD = true;
                                            }
                                            if (this.managedStream || string2.contains(Severity.valueOf(1148 / 239, "vqv*d`|n"))) break block10;
                                            iMediaStream = InstanceUtils.getIncomingStreamByName(iApplicationInstance, this.streamName);
                                            if (iMediaStream == null) return bl;
                                            client = (Client)iMediaStream.getClient();
                                            if (iMediaStream.isTranscodeResult()) {
                                                this.sourceIp = Utils.substring("iidie*#X\u007foacr}wqg?", 980 / 167);
                                                return bl;
                                            }
                                            if (client == null) break block11;
                                            if (client.getIoSession() == null) break block12;
                                            break block13;
                                        }
                                        RTPStream rTPStream = iMediaStream.getRTPStream();
                                        RTPSession rTPSession = null;
                                        if (rTPStream != null) {
                                            rTPSession = rTPStream.getSession();
                                        }
                                        if (rTPSession == null) return bl;
                                        String string3 = rTPSession.getUri();
                                        if (string3 == null) return bl;
                                        int n = string3.indexOf(Severity.valueOf(792 / 131, ")("));
                                        String string4 = string3.substring(0, n + 2);
                                        this.sourceIp = string4 + rTPSession.getIp();
                                        return bl;
                                    }
                                    this.sourceIp = MediaCasterUtils.handleStreamAliasFile((IApplicationInstance)iApplicationInstance, (String)this.streamName);
                                    return bl;
                                }
                                if (client.getIoSession().getRemoteAddress() != null) break block14;
                            }
                            if (client.getIp() == null || client.getIp().length() <= 0) break block15;
                            break block16;
                        }
                        string = client.getIoSession().getRemoteAddress().toString();
                        break block17;
                    }
                    string = Severity.valueOf(1228 / 185, "sicge|b");
                    break block17;
                }
                string = client.getIp();
            }
            String string5 = InstanceUtils.getConnectPrefixFromProtocol(iMediaStream.getClient().getProtocol());
            this.sourceIp = string5 + Severity.valueOf(51 * 7, "\u007fi") + string;
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logException(Utils.substring("Mkehe`dl_y|jq|Q|zs\u007fp6uuzxR|uebv", 987 / 204), classNotFoundException);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse resetStreamAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        wMSResponse.message = Utils.substring("Z{u;i>yiof#e%qh\u007fsk+\u007fh|yuc<", 45 * 29);
        wMSResponse.success = true;
        try {
            Class.forName(Utils.substring("`kh(pg~pj\"zc|>gz|ga8^NQuhh", 557 / 184));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost != null) {
                NextLoadMessages nextLoadMessages = HTTPStreamManager.resetStream((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)this.streamName);
                if (nextLoadMessages.getErrorMsg() != null) {
                    this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                    IncomingStreamConfig.logError(Utils.substring("Gas~\u007fzzrEcj|{v_rpy)&l1!6#3\u001b=8.- \u000f,$8==nu", -9 - -55) + nextLoadMessages.getErrorMsg());
                    return null;
                }
                wMSResponse.message = nextLoadMessages.getInfoMsg();
                IncomingStreamConfig.logInfo(Utils.substring("JjfijagmXx\u007fkn}R}}r|q9j|i~hNjme`oBgqohf3*", 586 / 180) + nextLoadMessages.getInfoMsg());
            }
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
            this.logException(Utils.substring("Lhdgdcek^z}up\u007fP{{p~\u007f7h~oxjLtsgbiDesafd", 690 / 118), exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            wMSResponse.message = Severity.valueOf(53 - 3, "Qrz2b7~pt\u007f<|>h/68\"d6#5>,8e");
            this.logException(Severity.valueOf(910 / 157, "Lhdgdcek^z}up\u007fP{{p~\u007f7h~oxjLtsgbiDesafd"), classNotFoundException);
        }
        if (!wMSResponse.isSuccess()) {
            IncomingStreamConfig.logError(Utils.substring("Mkehe`dl_y|jq|Q|zs\u007fp6k\u007fhyiMkrdcnEfrngg0+", 425 / 101) + wMSResponse.message);
            return wMSResponse;
        }
        IncomingStreamConfig.logInfo(Utils.substring("\b, +(/)/\u001a>9),#\f??4:3{$2+<.\b(/;>-\u0000!7-*(}h", 124 + 69) + wMSResponse.message);
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse disconnectStreamAction(String string) {
        WMSResponse wMSResponse;
        block8: {
            block7: {
                wMSResponse = new WMSResponse();
                wMSResponse.message = Utils.substring("\u0019?>(/\"py", -11 - 43) + this.streamName + Severity.valueOf(1093 / 185, ",&cazidbckldtv");
                wMSResponse.success = true;
                try {
                    Class.forName(Utils.substring("gjk)\u007ff}qm#ybc?d{{fb9QORtoi", -25 - -29));
                    IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                    if (iVHost != null) {
                        NextLoadMessages nextLoadMessages = HTTPStreamManager.deleteStream((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)this.streamName);
                        if (nextLoadMessages.getErrorMsg() != null) {
                            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                            IncomingStreamConfig.logError(Severity.valueOf(3 * 47, "D`l\u007f|{}sFbe}xwXssxvg/fjwfiifli\u007f_y|jq|Sp`|yy\"9") + nextLoadMessages.getErrorMsg());
                            return null;
                        }
                        wMSResponse.message = nextLoadMessages.getInfoMsg();
                        IncomingStreamConfig.logInfo(Severity.valueOf(-2 - -50, "BTAG4TF^\"9^ro~qq.$!7d\u001625-('ql") + nextLoadMessages.getInfoMsg());
                    }
                    break block7;
                }
                catch (Exception exception) {
                    wMSResponse.message = exception.getMessage();
                    this.logException(Utils.substring("WqcnojjbUszlkfOb`iyv<w}fuxvw\u007fxhNjm% /\u0002'1/(&", -4 - -34), exception);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    wMSResponse.message = Utils.substring("Tyw=o<{wq$a#c3*1=)i9.>;+=~", 59 * 53);
                    this.logException(Severity.valueOf(63 * 41, "^vzuvusyLtsgbiFiin`m%hd}l\u007f\u007f|vwaEcj|{v]~jv//"), classNotFoundException);
                }
                break block8;
            }
            wMSResponse.message = Severity.valueOf(40 + 93, "Fgi/}*mecj/q1e|cow7k|hmyo0");
            IncomingStreamConfig.logError(Utils.substring("Mkehe`dl_y|jq|Q|zs\u007fp6}sh\u007frpqebvPpwcfeHi\u007feb`50", 821 / 196) + wMSResponse.message);
        }
        if (!wMSResponse.isSuccess()) {
            IncomingStreamConfig.logError(Utils.substring("Oikfgbbj]{bts~Wzxqq~4\u007fun}pnog`pVrumhgJoyg`~+2", 1447 / 235) + wMSResponse.message);
            return wMSResponse;
        }
        IncomingStreamConfig.logInfo(Utils.substring("Gas~\u007fzzrEcj|{v_rpyif,gmvehfgohx^z}up\u007fRwa\u007fxv#:", -86 + 100) + wMSResponse.message);
        return wMSResponse;
    }

    @Override
    public int compareTo(IncomingStreamConfig incomingStreamConfig) {
        return this.streamName.compareToIgnoreCase(incomingStreamConfig.streamName);
    }

    public static IncomingStreamConfig getObjectFromREST(String string, String string2, String string3, String string4, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(634 / 112, "snh{}Djah"), string);
        hashMap.put(Severity.valueOf(69 + -9, "}mnQ!,'"), string2);
        hashMap.put(Severity.valueOf(-46 - 47, "jjvrffjoEm`k"), string3);
        hashMap.put(Severity.valueOf(31 - 57, "53:,+&\u0002,#*"), string4);
        return (IncomingStreamConfig)IncomingStreamConfig.getObjectFromREST(IncomingStreamConfig.getUrl(hashMap, IncomingStreamConfig.class), IncomingStreamConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String a(String string) {
        String string2 = Severity.valueOf(650 / 208, "vjnhh\u007fg");
        int n = string.indexOf(Utils.substring("\u007f~", 93 + 115));
        if (n <= -1) return string2;
        int n2 = string.indexOf(47, n + 2);
        if (n2 <= -1) return string2;
        return string.substring(0, n2);
    }
}

