/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.incomingstreams.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamReceiver;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentIncomingStreamStatistics")
@WMSDescription(text="IncomingStreams Current Incoming Stream Statistics", get="Retrieves the Current Incoming Stream statistics for the specifed Incoming Stream")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/incomingstreams/{streamName}/monitoring/current", restVerbs="GET", xmlFilename="Application.xml")
public class CurrentIncomingStreamStatistics
extends ApplicationConfigBase {
    @JsonProperty(value="applicationInstance")
    @XStreamAlias(value="ApplicationInstance")
    protected String instanceName = null;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName = null;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected long uptime = 0L;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected long bytesIn = 0L;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected long bytesOut = 0L;
    @JsonProperty(value="bytesInRate")
    @XStreamAlias(value="BytesInRate")
    protected long bytesInRate = 0L;
    @JsonProperty(value="bytesOutRate")
    @XStreamAlias(value="BytesOutRate")
    protected long bytesOutRate = 0L;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected long totalConnections = 0L;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Integer> connectionCount = new HashMap<String, Integer>();

    public CurrentIncomingStreamStatistics() {
        String string = Utils.substring("{}gawy{|Tzqx", 83 + -33);
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(930 / 183, "vrumhgEm`k");
        this.addFieldForKeyMap(string2, string2);
    }

    public CurrentIncomingStreamStatistics(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.streamName = string4;
        String string5 = Utils.substring("d`|dp|pq[wz}", 3 * 15);
        this.addFieldForKeyMap(string5, string5);
        this.addToStringKeyMap(Utils.substring("\"\">:.>27\u001d583", 13 * 55), string3);
        String string6 = Severity.valueOf(49 + 91, "\u007fy|jq|\\ryp");
        this.addFieldForKeyMap(string6, string6);
        this.addToStringKeyMap(Utils.substring("ppwcfeGkfi", 768 / 213), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("$ <$0<01\u001b7:=", 35 * 47));
        this.addToStringKeyMapFromRequest(Utils.substring("z~yilcAq|w", 31 + 10));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public long getBytesInRate() {
        return this.bytesInRate;
    }

    public long getBytesOutRate() {
        return this.bytesOutRate;
    }

    public long getTotalConnections() {
        return this.totalConnections;
    }

    public Map<String, Integer> getConnectionCount() {
        return this.connectionCount;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        block7: {
            var1_1 = false;
            this.vhostName = this.getStringVariable(Utils.substring("apvioR|sz", 8 + 47));
            this.appName = this.getStringVariable(Utils.substring("xjkR|sz", 62 - 37));
            this.instanceName = this.getStringVariable(Severity.valueOf(112 + -81, "vnrvbjfcIido"));
            this.streamName = this.getStringVariable(Severity.valueOf(161 / 37, "wqtbidDjah"));
            try {
                Class.forName(Severity.valueOf(35 * 29, "474t,3*$>.vop*snh{}$BZEa|d"));
                var2_3 = VHostSingleton.getInstance((String)this.vhostName);
                if (var2_3 == null) return var1_1;
                var3_4 = var2_3.getApplication(this.appName);
                if (var3_4 == null) return var1_1;
                var4_5 = var3_4.getAppInstance(this.instanceName);
                if (var4_5 == null) return var1_1;
                var5_6 = 0;
                this.totalConnections = 0L;
                var5_6 = var4_5.getHTTPStreamerSessionCount(1, this.streamName);
                this.connectionCount.put(Severity.valueOf(43 * 55, "^KO\u0005\u0013\u0016\n\n\n"), var5_6);
                this.totalConnections += (long)var5_6;
                var5_6 = var4_5.getHTTPStreamerSessionCount(4, this.streamName);
                this.connectionCount.put(Utils.substring("\u0002\u0000\u0014\u0015\u0017\u0015\u0006\u001e", 33 * 15), var5_6);
                this.totalConnections += (long)var5_6;
                var5_6 = var4_5.getHTTPStreamerSessionCount(2, this.streamName);
                this.connectionCount.put(Utils.substring("KXTQSN[", 52 - 28), var5_6);
                this.totalConnections += (long)var5_6;
                var5_6 = var4_5.getHTTPStreamerSessionCount(0, this.streamName);
                this.connectionCount.put(Severity.valueOf(39 * 5, "\u0010\t\n\t\u0013\u0000"), var5_6);
                this.totalConnections += (long)var5_6;
                var5_6 = var4_5.getPlayStreamCount(this.streamName);
                this.connectionCount.put(Utils.substring("WRJX", 1089 / 195), var5_6);
                this.totalConnections += (long)var5_6;
                var5_6 = var4_5.getRTPSessionCount(this.streamName);
                this.connectionCount.put(Severity.valueOf(47 - 56, "\u0005\f\t"), var5_6);
                this.totalConnections += (long)var5_6;
                var6_7 = var4_5.getStreams();
                if (var6_7 == null) return true;
            }
            catch (ClassNotFoundException var2_2) {
                ConfigBase.log.error((Object)(Severity.valueOf(-19 - -26, "D}{xnbyGas~\u007fzzrEcj|{vOi\u007fkirvjgv<'dfkoCodjse::.5") + var2_2));
                return var1_1;
            }
            var7_8 = var6_7.getStream(this.streamName);
            if (var7_8 == null) break block7;
            this.bytesIn = var7_8.getMediaIOPerformance().getMessagesInBytes();
            this.bytesInRate = (long)var7_8.getMediaIOPerformance().getMessagesInBytesRate();
            var8_9 = var7_8.getElapsedTime();
            if (var8_9 != null) {
                this.uptime = (long)var8_9.getTimeSeconds();
            }
            var9_10 = var6_7.getStreams().iterator();
            if (true) ** GOTO lbl60
            block3: while (true) {
                if (var10_11.isPlay()) {
                    this.bytesOut += var10_11.getMediaIOPerformance().getMessagesOutBytes();
                    this.bytesOutRate += (long)var10_11.getMediaIOPerformance().getMessagesOutBytesRate();
                }
                while (var9_10.hasNext()) {
                    var10_11 = (IMediaStream)var9_10.next();
                    if (!var10_11.getName().equals(this.streamName)) continue;
                    continue block3;
                }
                break;
            }
            ConfigBase.log.debug((Object)(Severity.valueOf(1637 / 254, "Erz{oexD`l\u007f|{}sFbe}xwHh|jvsuk`w?jhimEifhm{88") + this.streamName + Severity.valueOf(861 / 189, "(%oi2") + this.bytesIn + "/" + this.bytesInRate + Utils.substring(")&h}}0", 1445 / 250) + this.bytesOut + "/" + this.bytesOutRate));
        }
        if ((var8_9 = var4_5.getMediaCasterStreams()) == null) return true;
        var9_10 = var8_9.getMediaCaster(this.streamName);
        if (var9_10 == null) return true;
        var10_11 = var9_10.getMediaCaster();
        if (var10_11 == null) return true;
        if (var10_11 instanceof LiveMediaStreamReceiver == false) return true;
        var11_13 = (LiveMediaStreamReceiver)var10_11;
        var7_8 = var10_11.getStream();
        if (var7_8 == null) return true;
        var12_12 = var11_13.getNetConnection();
        if (var12_12 == null) return true;
        this.bytesIn = var12_12.getMediaIOPerformanceCounter().getMessagesInBytes();
        this.bytesInRate = (long)var12_12.getMediaIOPerformanceCounter().getMessagesInBytesRate();
        return true;
    }

    public static CurrentIncomingStreamStatistics getObjectFromREST(String string, String string2, String string3, String string4, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring(" ?7*.\u0015=0;", -3 - 7), string);
        hashMap.put(Utils.substring("euvIido", 35 + 1), string2);
        hashMap.put(Utils.substring("v.26\"*&#\t)$/", 29 * 11), string3);
        hashMap.put(Severity.valueOf(37 - 9, "oilzalLbi`"), string4);
        return (CurrentIncomingStreamStatistics)CurrentIncomingStreamStatistics.getObjectFromREST(CurrentIncomingStreamStatistics.getUrl(hashMap, CurrentIncomingStreamStatistics.class), CurrentIncomingStreamStatistics.class, wMSClientSecurity);
    }
}

