/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.outgoingstreams;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.Iterator;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="OutgoingStream")
@WMSDescription(text="Application Instance Outgoing Stream", get="Retrieves the Outgoing Stream information for the specifed Outgoing Stream")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/outgoingstreams/{streamName}", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class OutgoingStreamConfig
extends ApplicationConfigBase
implements Comparable<OutgoingStreamConfig> {
    @XStreamOmitField
    protected String instanceName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    protected String streamName;
    @JsonProperty(value="someProp")
    @XStreamAlias(value="SomeProp")
    protected String someProp;
    @JsonProperty(value="someProp2")
    @XStreamAlias(value="SomeProp2")
    protected String someProp2;

    public OutgoingStreamConfig() {
        String string = Severity.valueOf(24 - 8, "y\u007fagu{urVxw~");
        this.addFieldForKeyMap(string, string);
        String string2 = Utils.substring("uszlkfBlcj", 1275 / 206);
        this.addFieldForKeyMap(string2, string2);
    }

    public OutgoingStreamConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.streamName = string4;
        String string5 = Utils.substring("usmkaoafJdkb", 21 + 7);
        this.addFieldForKeyMap(string5, string5);
        this.addToStringKeyMap(Utils.substring("&>\"&2:63\u001994?", 55 * 9), string3);
        String string6 = Severity.valueOf(-32 - 18, "=;\"43>\u001a4;2");
        this.addFieldForKeyMap(string6, string6);
        this.addToStringKeyMap(Utils.substring("'!$294\u0014:18", 10 - 22), string4);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("22.*>nbgMehc", -25 - -20));
        this.setPathMap();
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        this.vhostName = this.getStringVariable(Utils.substring("pogz~Em`k", 31 + -25));
        this.appName = this.getStringVariable(Utils.substring("dvwFhgn", 823 / 157));
        this.instanceName = this.getStringVariable(Severity.valueOf(984 / 150, "oi{}keoh@n}t"));
        this.streamName = this.getStringVariable(Utils.substring(",43'\")\u000b'*-", 21 * 35));
        ConfigBase.log.info((Object)(Severity.valueOf(53 * 5, "Z~yilc/Y\u007ft|4sye8Ortoi$") + this.vhostName + Utils.substring("3Uef{qz{ourp%", 7 * 21) + this.appName + Severity.valueOf(21 * 5, "i\u0003%?9/!34h") + this.instanceName + Utils.substring(")Y\u007f~hob*", 2 + 39) + this.streamName));
        this.someProp = Severity.valueOf(691 / 224, "pkhc'~hf~i");
        this.someProp2 = Severity.valueOf(-31 - 33, "3./&d3'+=,x");
        try {
            Class.forName(Severity.valueOf(108 + 125, "*%&b:!8*0|$9&x!06)/r\u0014\b\u0017orv"));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost == null) return true;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return true;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return true;
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            if (mediaStreamMap == null) return true;
            Iterator iterator = mediaStreamMap.getStreams().iterator();
            while (iterator.hasNext()) {
                IMediaStream iMediaStream = (IMediaStream)iterator.next();
                if (!iMediaStream.getName().equals(this.streamName) || iMediaStream.getHTTPStreamerSession() == null) continue;
                if (iMediaStream.getClient() != null) {
                    this.someProp = iMediaStream.getClient().getIp();
                }
                this.someProp2 = iMediaStream.getUniqueStreamIdStr();
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public int compareTo(OutgoingStreamConfig outgoingStreamConfig) {
        return this.streamName.compareToIgnoreCase(outgoingStreamConfig.streamName);
    }
}

