/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.streamgroups;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.medialist.MediaListRendition;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamGroup")
@WMSDescription(text="Application Instance Stream Group", get="Retrieves the specified StreamGroup configuration", put="Updates the specified StreamGroup configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/streamgroups/{groupName}", restVerbs="GET", xmlFilename="Application.xml")
public class StreamGroupConfig
extends ApplicationConfigBase
implements Comparable<StreamGroupConfig> {
    @JsonProperty(value="groupName")
    @XStreamAlias(value="GroupName")
    protected String groupName;
    @JsonProperty(value="instanceName")
    @XStreamAlias(value="InstanceName")
    protected String instanceName;
    @JsonProperty(value="members")
    @XStreamAlias(value="Members")
    protected List<String> members;
    @JsonProperty(value="isTranscodeResult")
    @XStreamAlias(value="IsTranscodeResult")
    protected boolean isTranscodeResult;

    public StreamGroupConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.groupName = string4;
        String string5 = Utils.substring("04((<0<eOcna", 116 + 5);
        this.addFieldForKeyMap(string5, string5);
        this.addToStringKeyMap(Severity.valueOf(453 / 105, "mkusiginBlcj"), string3);
        String string6 = Utils.substring("(\">'#\u001a4;2", 6 + 73);
        this.addFieldForKeyMap(string6, string6);
        this.addToStringKeyMap(Utils.substring("bth}yDjah", 1115 / 207), string4);
        this.initUrl();
    }

    public StreamGroupConfig() {
        String string = Severity.valueOf(22 + 10, "ioqwekebFhgn");
        this.addFieldForKeyMap(string, string);
        String string2 = Utils.substring("82.73\n$+\"", 49 * 15);
        this.addFieldForKeyMap(string2, string2);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(15 * 39, " $88, ,5\u001f3>1"));
        this.addToStringKeyMapFromRequest(Utils.substring("&0,15\b&%,", 43 * 35));
        this.setPathMap();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public boolean isTranscodeResult() {
        return this.isTranscodeResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        try {
            Class.forName(Severity.valueOf(1071 / 213, "fij&~e|vl x}b<e|zec6PLSsnj"));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost == null) return bl;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return bl;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return bl;
            Set set = iApplicationInstance.getStreams().getNameGroups();
            if (set == null) return bl;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MediaStreamMapGroup mediaStreamMapGroup = (MediaStreamMapGroup)iterator.next();
                if (!mediaStreamMapGroup.getName().equals(this.groupName)) continue;
                this.loadObject(mediaStreamMapGroup);
                bl = true;
            }
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logException(Utils.substring("\u0006\"%=87\u001c.2+/Cnlemb(kghnDngkld", 35 * 7), classNotFoundException);
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadObject(Object var1_1) {
        block6: {
            block8: {
                block7: {
                    var2_2 = (MediaStreamMapGroup)var1_1;
                    this.members = new ArrayList<String>();
                    this.groupName = var2_2.getName();
                    this.isTranscodeResult = var2_2.isTranscodeResult();
                    var3_3 = var2_2.getMediaList();
                    if (var3_3 == null) lbl-1000:
                    // 3 sources

                    {
                        return;
lbl9:
                        // 2 sources

                        while (true) {
                            var7_7 = var7_7.substring(4);
                            break block6;
                            break;
                        }
lbl12:
                        // 1 sources

                        while (true) {
                            var5_5 = var4_4.getRenditions().iterator();
                            break block7;
                            break;
                        }
                    }
                    var4_4 = var3_3.getFirstSegment();
                    if (var4_4 == null) ** GOTO lbl-1000
                    ** while (true)
                    while (true) {
                        var6_6 = (MediaListRendition)var5_5.next();
                        var7_7 = var6_6.getName();
                        if (var7_7.startsWith(Severity.valueOf(1193 / 210, "hv32"))) ** GOTO lbl9
                        break block8;
                        break;
                    }
                }
lbl24:
                // 2 sources

                while (true) {
                    if (var5_5.hasNext()) ** continue;
                    Collections.sort(this.members, String.CASE_INSENSITIVE_ORDER);
                    ** continue;
                    break;
                }
            }
            if (!var7_7.startsWith(Severity.valueOf(-12 + 38, "|wj'"))) ** break;
            ** while (true)
        }
        this.members.add(var7_7);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse resetGroupAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        wMSResponse.message = Utils.substring("Gdh |)lbbi.n0f}dnt6d}kl~n3", 1044 / 232);
        wMSResponse.success = false;
        try {
            Class.forName(Utils.substring("ehe'}d{wo!g|a=b}ydl7SMTrmk", 1230 / 184));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost != null) {
                for (String string2 : this.members) {
                    HTTPStreamManager.resetStream((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)string2);
                    wMSResponse.message = Severity.valueOf(813 / 143, "Vrumhg+K\u007faz`1:") + this.groupName + Utils.substring(".({oxiy", 5 * 59);
                    wMSResponse.success = true;
                }
            }
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
            this.logException(Severity.valueOf(911 / 238, "PpwcfeNxdy}M`~w{t:gsd}m]ishn^cuklj"), exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            wMSResponse.message = Severity.valueOf(-61 - -60, "\u001cao%w$coil)k+{byuq1avfcse6");
            this.logException(Utils.substring("\t/.8?2\u00073-64\u0006)). -e>(=*$\u0016 <!%\u00174,055", 64 + 26), classNotFoundException);
        }
        if (wMSResponse.isSuccess()) {
            StreamGroupConfig.logInfo(Severity.valueOf(548 / 92, "VrumhgL~b{\u007fS~|u}r8e}j\u007fo[oqjp@awmjh=(") + wMSResponse.message);
            return wMSResponse;
        }
        StreamGroupConfig.logError(Utils.substring("Y\u007f~hobWc}fdVyy~p}5nxmztFplquGd|`ee6-", 5 + 5) + wMSResponse.message);
        this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse disconnectGroupAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        wMSResponse.message = Utils.substring("\u0000 '365y\u001d)3(.\u007f(", 99 + 16) + this.groupName + Severity.valueOf(29 * 19, ".(mcxob`aurfvp");
        wMSResponse.success = false;
        try {
            MediaStreamMap mediaStreamMap;
            MediaStreamMapGroup mediaStreamMapGroup;
            IApplicationInstance iApplicationInstance;
            IApplication iApplication;
            Class.forName(Utils.substring(" +(h0'>0*b:#<~':<'!x\u001e\u000e\u00115((", 23 * 21));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost != null && (iApplication = iVHost.getApplication(this.appName)) != null && (iApplicationInstance = iApplication.getAppInstance(this.instanceName)) != null && (mediaStreamMapGroup = (mediaStreamMap = iApplicationInstance.getStreams()).getNameGroupByGroupName(this.groupName)) != null) {
                String string2 = "" + mediaStreamMapGroup.getId();
                HTTPStreamManager.removeStreamGroup((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)string2);
                for (String string3 : this.members) {
                    HTTPStreamManager.deleteStream((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)string3);
                }
                wMSResponse.success = true;
            }
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
            this.logException(Utils.substring("\b(/;>mFplquEhfocl\"ig|s~|}qvbPjvok]~jvoo", 10 - 15), exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            wMSResponse.message = Utils.substring("\b-#i;p7;=0u7w/6-!=}-:27'1j", 5 + 70);
            this.logException(Severity.valueOf(50 - 30, "Gadryt]ishn\\oodjc+bn{jeebhm{Wc}fdTucqvt"), classNotFoundException);
        }
        if (wMSResponse.isSuccess()) {
            StreamGroupConfig.logInfo(Severity.valueOf(61 * 39, "\u00188?+.=\u0016 <!%\u001586?3<r97,#.,-!&2\u0000:&?;\r.:&??hs") + wMSResponse.message);
            return wMSResponse;
        }
        StreamGroupConfig.logError(Utils.substring("Jniy|sXrnwsGjhaan$oe~m`~\u007fwp`Rdxmi[xhtqqza", 17 * 9) + wMSResponse.message);
        this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse removeGroupAction(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        wMSResponse.message = Utils.substring("Wqtbid*L~b{\u007f09", 503 / 124) + this.groupName + Utils.substring("dn=5<=%11", 82 + -5);
        wMSResponse.success = false;
        try {
            MediaStreamMap mediaStreamMap;
            MediaStreamMapGroup mediaStreamMapGroup;
            IApplicationInstance iApplicationInstance;
            IApplication iApplication;
            Class.forName(Utils.substring(" +(h0'>0*b:#<~':<'!x\u001e\u000e\u00115((", 52 + 47));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost != null && (iApplication = iVHost.getApplication(this.appName)) != null && (iApplicationInstance = iApplication.getAppInstance(this.instanceName)) != null && (mediaStreamMapGroup = (mediaStreamMap = iApplicationInstance.getStreams()).getNameGroupByGroupName(this.groupName)) != null) {
                String string2 = "" + mediaStreamMapGroup.getId();
                HTTPStreamManager.removeStreamGroup((IVHost)iVHost, (String)this.appName, (String)this.instanceName, (String)string2);
                wMSResponse.success = true;
            }
        }
        catch (Exception exception) {
            wMSResponse.message = exception.getMessage();
            this.logException(Utils.substring("Dlk\u007fzqZlp51\u0001,*#/ f;/&#;+\b\">'#\u00156\">77", 15 - -40), exception);
        }
        catch (ClassNotFoundException classNotFoundException) {
            wMSResponse.message = Severity.valueOf(-41 - -35, "\u0019:2z*\u007ffhlg$d&pg~pj,~k}ft`=");
            this.logException(Utils.substring("\n.)9<3\u00182.73\u0007*(!!.d9) !95\u0016 <!%\u00174,055", 65 + 24), classNotFoundException);
        }
        if (!wMSResponse.isSuccess()) {
            StreamGroupConfig.logError(Utils.substring("UszlkfK\u007faz`R}}r|q9j|wtjxYm/42\u0002'1/(&sj", 115 + 51) + wMSResponse.message);
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        StreamGroupConfig.logInfo(Utils.substring("_y|jq|Ua{`fTww|r{3lz-.4&\u00037)28\b)?%\" up", 60 - 16) + wMSResponse.message);
        return wMSResponse;
    }

    @Override
    public int compareTo(StreamGroupConfig streamGroupConfig) {
        return this.groupName.compareToIgnoreCase(streamGroupConfig.groupName);
    }

    public static StreamGroupConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(45 * 31, "%<:%#\u001687>"), string);
        hashMap.put(Severity.valueOf(51 - -64, "2$%\u001865<"), string2);
        return (StreamGroupConfig)StreamGroupConfig.getObjectFromREST(StreamGroupConfig.getUrl(hashMap, StreamGroupConfig.class), StreamGroupConfig.class, wMSClientSecurity);
    }
}

