/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.streamgroups;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.instances.streamgroups.StreamGroupConfig;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamGroups")
@WMSDescription(text="Application Instance Stream Groups", get="Retrieves the list of Stream Groups for the specified Application Instance")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/streamgroups", restVerbs="GET", xmlFilename="")
public class StreamGroupsConfig
extends ApplicationConfigBase {
    @JsonProperty(value="instanceName")
    @XStreamAlias(value="InstanceName")
    protected String instanceName;
    @JsonProperty(value="streamGroups")
    @XStreamImplicit(itemFieldName="StreamGroups")
    protected List<StreamGroupConfig> streamGroups = null;

    public StreamGroupsConfig() {
        String string = Severity.valueOf(23 * 41, "f~bfrzvsYyt\u007f");
        this.addFieldForKeyMap(string, string, true);
    }

    public StreamGroupsConfig(String string, String string2, String string3) {
        super(string, string2);
        this.instanceName = string3;
        String string4 = Utils.substring("$ <$0<01\u001b7:=", 5 + 104);
        this.addFieldForKeyMap(string4, string4);
        this.addToStringKeyMap(Utils.substring("wq35#-' \b&%,", 114 + -52), string3);
        this.initUrl();
    }

    public List<StreamGroupConfig> getStreamGroups() {
        return this.streamGroups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl;
        block4: {
            Set set;
            MediaStreamMap mediaStreamMap;
            IApplication iApplication;
            bl = false;
            this.vhostName = this.getStringVariable(Utils.substring("<##>:\u00011<7", -8 - 14));
            this.appName = this.getStringVariable(Utils.substring("~01\f\") ", 8 - -55));
            this.instanceName = this.getStringVariable(Utils.substring("\u007fykm{u\u007fxP~md", 34 - 12));
            this.streamGroups = new ArrayList<StreamGroupConfig>();
            try {
                Class.forName(Severity.valueOf(-61 - 48, "p{x8`wn`z2jsl.wjlwq(N^Aexx"));
                IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
                if (iVHost == null || (iApplication = iVHost.getApplication(this.appName)) == null) break block4;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logException(Utils.substring("QafiullxxOb`iyv<\u007f{trXzs\u007fxh", 356 / 107), classNotFoundException);
                break block4;
            }
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance != null && (mediaStreamMap = iApplicationInstance.getStreams()) != null && (set = mediaStreamMap.getNameGroups()) != null) {
                for (MediaStreamMapGroup mediaStreamMapGroup : set) {
                    StreamGroupConfig streamGroupConfig = new StreamGroupConfig(this.vhostName, this.appName, this.instanceName, mediaStreamMapGroup.getName());
                    streamGroupConfig.loadObject(mediaStreamMapGroup);
                    this.streamGroups.add(streamGroupConfig);
                }
                bl = true;
            }
        }
        Collections.sort(this.streamGroups);
        return bl;
    }

    public static StreamGroupsConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("uljusFhgn", 276 / 76), string);
        hashMap.put(Utils.substring("euvIido", 68 + 64), string2);
        return (StreamGroupsConfig)StreamGroupsConfig.getObjectFromREST(StreamGroupsConfig.getUrl(hashMap, StreamGroupsConfig.class), StreamGroupsConfig.class, wMSClientSecurity);
    }
}

