/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.streamrecorders;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorder;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorderFileVersionDelegate;
import com.wowza.wms.livestreamrecord.manager.StreamRecorderParameters;
import com.wowza.wms.livestreamrecord.model.LiveStreamRecordFileVersionDelegate;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamRecorder")
@WMSDescription(text="Application Instance Stream Recorders", get="Retrieves the specifed Stream Recorder", post="Creates a new Stream Recorder and starts recording")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/streamrecorders/{recorderName}", restVerbs="GET,POST", xmlFilename="Application.xml")
public class StreamRecorderConfig
extends ApplicationConfigBase
implements Comparable<StreamRecorderConfig> {
    @XStreamOmitField
    public static final String SEGMENT_NONE = "None";
    @XStreamOmitField
    public static final String SEGMENT_BY_SCHEDULE = "SegmentBySchedule";
    @XStreamOmitField
    public static final String SEGMENT_BY_SIZE = "SegmentBySize";
    @XStreamOmitField
    public static final String SEGMENT_BY_DURATION = "SegmentByDuration";
    @XStreamOmitField
    public static final String RECORDER_STATE_RECORDING = "Recording in Progress";
    @XStreamOmitField
    public static final String RECORDER_STATE_WAITING = "Waiting for stream";
    @XStreamOmitField
    public static final String RECORDER_STATE_ERROR = "Recorder error";
    @XStreamOmitField
    public static final String OPTION_APPEND = "Append to existing file";
    @XStreamOmitField
    public static final String OPTION_VERSION = "Version existing file";
    @XStreamOmitField
    public static final String OPTION_OVERWRITE = "Overwrite existing file";
    @XStreamOmitField
    public static final String FORMAT_MP4 = "MP4";
    @XStreamOmitField
    public static final String FORMAT_FLV = "FLV";
    @JsonProperty(value="recorderName")
    @XStreamAlias(value="RecorderName")
    protected String recorderName;
    @JsonProperty(value="instanceName")
    @XStreamAlias(value="InstanceName")
    protected String instanceName;
    @JsonProperty(value="applicationName")
    @XStreamAlias(value="ApplicationName")
    protected String applicationName;
    @JsonProperty(value="recorderState")
    @XStreamAlias(value="RecorderState")
    protected String recorderState;
    @JsonProperty(value="recorderErrorString")
    @XStreamAlias(value="RecorderErrorString")
    protected String recorderErrorString;
    @JsonProperty(value="defaultRecorder")
    @XStreamAlias(value="DefaultRecorder")
    protected boolean defaultRecorder;
    @JsonProperty(value="segmentationType")
    @XStreamAlias(value="SegmentationType")
    protected String segmentationType;
    @JsonProperty(value="outputPath")
    @XStreamAlias(value="OutputPath")
    protected String outputPath;
    @JsonProperty(value="baseFile")
    @XStreamAlias(value="BaseFile")
    protected String baseFile;
    @JsonProperty(value="fileFormat")
    @XStreamAlias(value="FileFormat")
    protected String fileFormat;
    @JsonProperty(value="fileVersionDelegateName")
    @XStreamAlias(value="FileVersionDelegate")
    protected String fileVersionDelegateName;
    @JsonProperty(value="fileTemplate")
    @XStreamAlias(value="FileTemplate")
    protected String fileTemplate;
    @JsonProperty(value="segmentDuration")
    @XStreamAlias(value="SegmentDuration")
    protected long segmentDuration;
    @JsonProperty(value="segmentSize")
    @XStreamAlias(value="SegmentSize")
    protected long segmentSize;
    @JsonProperty(value="segmentSchedule")
    @XStreamAlias(value="SegmentSchedule")
    protected String segmentSchedule;
    @JsonProperty(value="recordData")
    @XStreamAlias(value="RecordData")
    protected boolean recordData;
    @JsonProperty(value="startOnKeyFrame")
    @XStreamAlias(value="StartOnKeyFrame")
    protected boolean startOnKeyFrame;
    @JsonProperty(value="option")
    @XStreamAlias(value="Option")
    protected String option;
    @JsonProperty(value="moveFirstVideoFrameToZero")
    @XStreamAlias(value="MoveFirstVideoFrameToZero")
    protected boolean moveFirstVideoFrameToZero;
    @JsonProperty(value="currentSize")
    @XStreamAlias(value="CurrentSize")
    protected long currentSize;
    @JsonProperty(value="currentDuration")
    @XStreamAlias(value="CurrentDuration")
    protected long currentDuration;
    @JsonProperty(value="currentFile")
    @XStreamAlias(value="CurrentFile")
    protected String currentFile;
    @JsonProperty(value="recordingStartTime")
    @XStreamAlias(value="RecordingStartTime")
    protected String recordingStartTime;
    private static final DateTimeFormatter a = DateTimeFormat.forPattern((String)Severity.valueOf(655 / 146, "}|\u007f~%DG&hi#GX?\u007f~:fe9KJI6fgd"));

    public StreamRecorderConfig(String string, String string2, String string3, String string4) {
        super(string, string2);
        this.instanceName = string3;
        this.recorderName = string4;
        String string5 = Severity.valueOf(38 + 49, ">6*.:2>;\u0011!,'");
        this.addFieldForKeyMap(string5, string5);
        this.addToStringKeyMap(Severity.valueOf(58 + 81, "bb~zn~rw]uxs"), string3);
        String string6 = Severity.valueOf(9 * 63, "e}zuixxlQ!,'");
        this.addFieldForKeyMap(string6, string6);
        this.addToStringKeyMap(Severity.valueOf(41 + 102, "}ur}appdYyt\u007f"), string4);
        this.initUrl();
    }

    public StreamRecorderConfig() {
        String string = Severity.valueOf(39 * 41, "v.26\"*&#\t)$/");
        this.addFieldForKeyMap(string, string, true);
        String string2 = Severity.valueOf(1397 / 209, "tbkfxoi\u007f@n}t");
        this.addFieldForKeyMap(string2, string2, true);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("|xdlxtxyS\u007fre", 63 * 43));
        this.addToStringKeyMapFromRequest(Utils.substring("sg`kwbbzGkfi", 40 + -7));
        this.setPathMap();
    }

    public boolean isDefaultRecorder() {
        return this.defaultRecorder;
    }

    public String getRecorderName() {
        return this.recorderName;
    }

    public void setRecorderName(String string) {
        this.recorderName = string;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getRecorderState() {
        return this.recorderState;
    }

    public void setRecorderState(String string) {
        this.recorderState = string;
    }

    public String getRecorderErrorString() {
        return this.recorderErrorString;
    }

    public void setRecorderErrorString(String string) {
        this.recorderErrorString = string;
    }

    public String getSegmentationType() {
        return this.segmentationType;
    }

    public void setSegmentationType(String string) {
        this.segmentationType = string;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String string) {
        this.outputPath = string;
    }

    public String getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(String string) {
        this.baseFile = string;
    }

    public long getSegmentDuration() {
        return this.segmentDuration;
    }

    public void setSegmentDuration(long l) {
        this.segmentDuration = l;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(long l) {
        this.segmentSize = l;
    }

    public String getSegmentSchedule() {
        return this.segmentSchedule;
    }

    public void setSegmentSchedule(String string) {
        this.segmentSchedule = string;
    }

    public String getFileTemplate() {
        return this.fileTemplate;
    }

    public void setFileTemplate(String string) {
        this.fileTemplate = string;
    }

    public boolean isRecordData() {
        return this.recordData;
    }

    public void setRecordData(boolean bl) {
        this.recordData = bl;
    }

    public boolean isStartOnKeyFrame() {
        return this.startOnKeyFrame;
    }

    public void setStartOnKeyFrame(boolean bl) {
        this.startOnKeyFrame = bl;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String string) {
        this.option = string;
    }

    public boolean isMoveFirstVideoFrameToZero() {
        return this.moveFirstVideoFrameToZero;
    }

    public void setMoveFirstVideoFrameToZero(boolean bl) {
        this.moveFirstVideoFrameToZero = bl;
    }

    public long getCurrentSize() {
        return this.currentSize;
    }

    public void setCurrentSize(long l) {
        this.currentSize = l;
    }

    public long getCurrentDuration() {
        return this.currentDuration;
    }

    public void setCurrentDuration(long l) {
        this.currentDuration = l;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String string) {
        this.currentFile = string;
    }

    public String getRecordingStartTime() {
        return this.recordingStartTime;
    }

    public void setRecordingStartTime(String string) {
        this.recordingStartTime = string;
    }

    public String getFileVersionDelegateName() {
        return this.fileVersionDelegateName;
    }

    public void setFileVersionDelegateName(String string) {
        this.fileVersionDelegateName = string;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String string) {
        this.fileFormat = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        this.vhostName = this.getStringVariable(Utils.substring("#>8+-\u0014:18", 29 * 25));
        this.appName = this.getStringVariable(Utils.substring("btuHfel", 672 / 214));
        this.instanceName = this.getStringVariable(Utils.substring("oi{}keoh@n}t", 1585 / 238));
        this.recorderName = this.getStringVariable(Severity.valueOf(40 + -5, "qafiullxEm`k"));
        try {
            Class.forName(Utils.substring("l\u007f|<d{blv6nwh2kvp35l\n\u0012\r)4<", -47 - 34));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost == null) return bl;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return bl;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return bl;
            Map map = iVHost.getLiveStreamRecordManager().getRecordersMap(iApplicationInstance);
            if (!map.containsKey(this.recorderName)) return bl;
            this.loadObject(map.get(this.recorderName));
            return true;
        }
        catch (SecurityException securityException) {
            this.logException(Utils.substring("\u0017#$';..>\u000e!!685}8:73\u0017;0>?)", 25 * 13), securityException);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logException(Severity.valueOf(205 / 43, "V`ehzmoyOb`iyv<\u007f{trXzs\u007fxh"), classNotFoundException);
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logException(Utils.substring("Aqvye||hXssxvg/nleaIebli\u007f", 56 - 37), illegalArgumentException);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadObject(Object object) {
        String string;
        IStreamRecorder iStreamRecorder;
        block8: {
            block5: {
                block7: {
                    block6: {
                        String string2;
                        iStreamRecorder = (IStreamRecorder)object;
                        switch (iStreamRecorder.getRecorderState()) {
                            default: {
                                this.recorderState = Utils.substring("\u001c-$:&>6r5;'v$,+?:1", 79 + 28);
                                break;
                            }
                            case 2: {
                                this.recorderState = Severity.valueOf(15 * 55, "K\u007fxsozv.&b**e\u00165'.8.?>");
                                break;
                            }
                            case -1: {
                                this.recorderState = Utils.substring("\u0010&'*4#-;j.>?!=", 60 - -6);
                            }
                        }
                        if ((string2 = iStreamRecorder.getSegmentationType()).equalsIgnoreCase(Utils.substring("wfnbl|fn", 106 + -70))) break block5;
                        if (string2.equalsIgnoreCase(Utils.substring("b{iq", -35 - 44))) break block6;
                        if (!string2.equalsIgnoreCase(Severity.valueOf(35 + -10, "}oi}iwpn"))) break block7;
                        this.segmentationType = Severity.valueOf(-51 - 56, "Fspu|to^dZjr`vjkk");
                        break block8;
                    }
                    this.segmentationType = Utils.substring("Rgdi`hsJpYbvh", 106 + -105);
                    break block8;
                }
                this.segmentationType = Severity.valueOf(-27 - -6, "\u0005##+");
                break block8;
            }
            this.segmentationType = Severity.valueOf(50 - 4, "]jw|w}`WoD{q\u007f\u007fiq{");
        }
        this.option = (string = iStreamRecorder.getVersioningOption()).equalsIgnoreCase(Severity.valueOf(61 * 59, "n`aw}p")) ? Severity.valueOf(46 - -26, "\t9:.\")n;?q7+=&\">6>z=51;") : (string.equalsIgnoreCase(Severity.valueOf(63 * 19, "bxjbf`z`p")) ? Utils.substring("Kscu\u007f{c\u007fi-kwybfzzr6qqu\u007f", 1028 / 251) : Severity.valueOf(1713 / 249, "Pbzzcdb-kwybfzzr6qqu\u007f"));
        this.outputPath = StreamRecorderConfig.a(iStreamRecorder.getFilePath());
        this.baseFile = StreamRecorderConfig.b(iStreamRecorder.getBaseFilePath());
        this.fileFormat = iStreamRecorder.getFileFormat().toUpperCase();
        this.segmentDuration = iStreamRecorder.getSegmentDuration();
        this.segmentSize = iStreamRecorder.getSegmentSize();
        this.segmentSchedule = iStreamRecorder.getSegmentScheduleString();
        this.recordData = iStreamRecorder.isRecordData();
        this.startOnKeyFrame = iStreamRecorder.isStartOnKeyFrame();
        this.recorderErrorString = iStreamRecorder.getErrorString();
        this.moveFirstVideoFrameToZero = iStreamRecorder.isMoveFirstVideoFrameToZero();
        this.currentFile = iStreamRecorder.getCurrentFile();
        this.currentSize = iStreamRecorder.getCurrentSize();
        this.currentDuration = iStreamRecorder.getCurrentDuration();
        this.recordingStartTime = !this.recorderState.equals(Severity.valueOf(-43 - 2, "\u00045<\">6>z=3/~,43'\")")) && iStreamRecorder.getStartTime() != null ? iStreamRecorder.getStartTime().toString(a) : "";
        if (StringUtils.isEmpty((String)this.fileTemplate)) {
            this.fileTemplate = Severity.valueOf(728 / 114, "hhfl");
        }
        this.fileVersionDelegateName = iStreamRecorder.getFileVersionDelegate().getClass().getCanonicalName();
        if (!(iStreamRecorder.getFileVersionDelegate() instanceof LiveStreamRecordFileVersionDelegate)) return;
        this.fileTemplate = ((LiveStreamRecordFileVersionDelegate)iStreamRecorder.getFileVersionDelegate()).getFileTemplate();
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public int compareTo(StreamRecorderConfig streamRecorderConfig) {
        return this.recorderName.compareToIgnoreCase(streamRecorderConfig.recorderName);
    }

    public static StreamRecorderConfig getObjectFromREST(String string, String string2, String string3, String string4, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("=$\"=;\u001e0?6", 25 * 3), string);
        hashMap.put(Utils.substring(":,-\u0010>-$", 81 + 10), string2);
        hashMap.put(Utils.substring("~vjnzr~{Q!,'", 63 * 9), string3);
        hashMap.put(Severity.valueOf(18 - -52, "4\"+&8/)?\u0000.=4"), string4);
        return (StreamRecorderConfig)StreamRecorderConfig.getObjectFromREST(StreamRecorderConfig.getUrl(hashMap, StreamRecorderConfig.class), StreamRecorderConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse stopRecordingAction(String string) {
        WMSResponse wMSResponse;
        block5: {
            IApplication iApplication;
            IVHost iVHost;
            wMSResponse = new WMSResponse();
            wMSResponse.message = Utils.substring("\u001e?1'u\"emkb'i)}d{wo/ct`eqg8", -62 - -59);
            wMSResponse.success = true;
            try {
                Class.forName(Severity.valueOf(22 - -19, "jef\"zaxjp<dyf8apvio2THW/26"));
                iVHost = VHostSingleton.getInstance((String)this.vhostName);
                if (iVHost == null || (iApplication = iVHost.getApplication(this.appName)) == null) break block5;
            }
            catch (Exception exception) {
                wMSResponse.message = exception.getMessage();
                this.logException(Utils.substring("Tbkfxoi\u007fM`~w{t:fbxhK\u007fxsozvnfC`plii", 1297 / 206), exception);
                break block5;
            }
            catch (ClassNotFoundException classNotFoundException) {
                wMSResponse.message = Severity.valueOf(454 / 101, "Gdh |)lbbi.n0f}dnt6d}kl~n3");
                this.logException(Severity.valueOf(282 / 45, "Tbkfxoi\u007fM`~w{t:fbxhK\u007fxsozvnfC`plii"), classNotFoundException);
                break block5;
            }
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance != null) {
                iVHost.getLiveStreamRecordManager().stopRecording(iApplicationInstance, this.recorderName);
                wMSResponse.message = Severity.valueOf(59 * 47, "\u0007347+>22:~w") + this.recorderName + Severity.valueOf(57 - -11, "me53'9:.(");
            }
        }
        if (!wMSResponse.isSuccess()) {
            StreamRecorderConfig.logError(Severity.valueOf(45 + 116, "Sg`kwbbzJeejdi!ce}cFpuxj}su{\\}k).,yd") + wMSResponse.message);
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        StreamRecorderConfig.logInfo(Severity.valueOf(-24 + 103, "\u001d52=!00$\u001477<2;s-+/1\u0010&'*4#!'-\n/9' >kr") + wMSResponse.message);
        return wMSResponse;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse splitRecordingAction(String var1_1) {
        block5: {
            var2_2 = new WMSResponse();
            var2_2.message = Severity.valueOf(67 + 89, "_|p8t!djja&f(~e|vl.|ucdvf;");
            var2_2.success = true;
            try {
                Class.forName(Utils.substring("(# `8?&(2z\";$v/24/)p\u0016\u0016\t-00", 2 + 73));
                var3_5 = VHostSingleton.getInstance((String)this.vhostName);
                if (var3_5 == null || (var4_7 = var3_5.getApplication(this.appName)) == null) ** GOTO lbl22
                ** GOTO lbl18
            }
            catch (ClassNotFoundException var3_3) {
                block4: {
                    var2_2.message = Utils.substring("Bcm#q&aagn+m-y`gks3gpda}k4", 88 + -87);
                    this.logException(Utils.substring("Cwp{grrjZuuzty1sqnjpWcdg{nbbjOldx}}", -49 - 62), var3_3);
                    break block4;
                    catch (Exception var3_4) {
                        var2_2.message = var3_4.getMessage();
                        this.logException(Utils.substring("Wcdg{nn~Naavxu=gez~lK\u007fxsozvnfC`plii", 1099 / 186), var3_4);
                        break block4;
                    }
lbl18:
                    // 1 sources

                    var5_6 = var4_7.getAppInstance(this.instanceName);
                    if (var5_6 != null) {
                        var3_5.getLiveStreamRecordManager().splitRecording(var5_6, this.recorderName);
                        var2_2.message = Severity.valueOf(375 / 98, "Qafiul`dl,%") + this.recorderName + Utils.substring("go#!>: ", 84 + 122);
                    }
                }
                if (!var2_2.isSuccess()) break block5;
                StreamRecorderConfig.logInfo(Utils.substring("V`ehzmoyOb`iyv<`dy\u007fcJ|ytnywqg@awmjh=(", 616 / 147) + var2_2.message);
                return var2_2;
            }
        }
        StreamRecorderConfig.logError(Severity.valueOf(-2 + 117, "\u0001169%<<(\u00183386g/qshlrUmjeyhd`hQrfz{{,7") + var2_2.message);
        this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        WMSResponse wMSResponse;
        block13: {
            wMSResponse = new WMSResponse();
            this.vhostName = this.getStringVariable(Utils.substring("uljusFhgn", 349 / 109));
            this.appName = this.getStringVariable(Severity.valueOf(104 + 14, "7'(\u0017;69"));
            try {
                StreamRecorderParameters streamRecorderParameters;
                IApplicationInstance iApplicationInstance;
                IVHost iVHost;
                block16: {
                    block15: {
                        block14: {
                            IApplication iApplication;
                            Class.forName(Severity.valueOf(-103 + 127, "{vw5kriea/unw+pogz~%E[F`ce"));
                            iVHost = VHostSingleton.getInstance((String)this.vhostName);
                            if (iVHost == null || (iApplication = iVHost.getApplication(this.appName)) == null || (iApplicationInstance = iApplication.getAppInstance(this.instanceName)) == null) break block13;
                            String string = this.vhostName + "/" + iApplicationInstance.getContextStr();
                            if (this.segmentationType == null) break block13;
                            streamRecorderParameters = new StreamRecorderParameters(iApplicationInstance);
                            if (this.segmentationType.equals(Utils.substring("W`ajmg~Iu^mguug\u007fq", 1084 / 238))) break block14;
                            if (!this.segmentationType.equals(Severity.valueOf(932 / 234, "Pabkbf}HrHx|ndx}}"))) break block15;
                            streamRecorderParameters.segmentationType = Severity.valueOf(37 * 5, "}oi}iwp.");
                            streamRecorderParameters.segmentDuration = this.segmentDuration;
                            break block16;
                        }
                        streamRecorderParameters.segmentationType = Utils.substring("&5?==/79", 2 + 83);
                        streamRecorderParameters.segmentSchedule = this.segmentSchedule;
                        break block16;
                    }
                    if (this.segmentationType.equals(Utils.substring("^kh}t|gVlE~b|", 29 + 112))) {
                        streamRecorderParameters.segmentationType = Utils.substring("irfx", 56 + 2);
                        streamRecorderParameters.segmentSize = this.segmentSize;
                    } else {
                        streamRecorderParameters.segmentationType = Utils.substring("q//'", 53 * 35);
                    }
                }
                streamRecorderParameters.versioningOption = this.option.equals(Severity.valueOf(13 + 53, "\u000334 (#h=%k)5'<$8<4t3?;=")) ? Severity.valueOf(820 / 201, "euvbfm") : (this.option.equals(Severity.valueOf(185 / 40, "Kscu\u007f{c\u007fi-kwybfzzr6qqu\u007f")) ? Severity.valueOf(43 * 41, ",2 40: >.") : Utils.substring("csekpuu", 35 + -14));
                streamRecorderParameters.recordData = this.recordData;
                streamRecorderParameters.startOnKeyFrame = this.startOnKeyFrame;
                streamRecorderParameters.moveFirstVideoFrameToZero = this.moveFirstVideoFrameToZero;
                if (!StringUtils.isEmpty((String)this.outputPath)) {
                    streamRecorderParameters.outputPath = this.outputPath;
                }
                if (!StringUtils.isEmpty((String)this.baseFile)) {
                    streamRecorderParameters.outputFile = this.baseFile;
                }
                streamRecorderParameters.fileFormat = this.fileFormat.equals(Utils.substring("I\\G", 23 - -24)) ? Severity.valueOf(60 - 2, "|wj") : Utils.substring("&<y", 33 - -42);
                if (!StringUtils.isEmpty((String)this.fileTemplate)) {
                    streamRecorderParameters.fileTemplate = this.fileTemplate;
                }
                if (!StringUtils.isEmpty((String)this.fileVersionDelegateName)) {
                    try {
                        Class<?> clazz = Class.forName(this.fileVersionDelegateName);
                        if (clazz != null) {
                            streamRecorderParameters.fileVersionDelegate = (IStreamRecorderFileVersionDelegate)clazz.newInstance();
                        }
                        StreamRecorderConfig.logWarn(Severity.valueOf(40 - -48, "\n<94.9;-\u0003.,%-\"h4<(8?\u001e(- \"5;=3ov\u0012*+5)|>,:aukmc%Gwxechmyg`~R}}`pnc[u{ho'>") + this.fileVersionDelegateName + Severity.valueOf(336 / 51, "<'M{xd~-`jgX|``txt}7"));
                    }
                    catch (Exception exception) {
                        this.logException(Utils.substring("\u0016 %(:-/9\u000f\" )96|  4$#\n<94.971'{b\u000667)5h*8.-9'!7q\u0013#$9?49-342\u001e11tdzwGigt{3*", -24 - 36) + this.fileVersionDelegateName + " ", exception);
                    }
                }
                iVHost.getLiveStreamRecordManager().startRecording(iApplicationInstance, this.recorderName, streamRecorderParameters);
                wMSResponse.success = true;
            }
            catch (Exception exception) {
                wMSResponse.message = exception.getMessage();
                this.logException(Severity.valueOf(5 + -1, "V`ehzmoyOb`iyv<``tdcJ|ytnywqg"), exception);
            }
            catch (ClassNotFoundException classNotFoundException) {
                wMSResponse.message = Utils.substring("Qkgedl*\u007fc-]{qcf3Fpuxj}su{", 39 + -35);
                this.logException(Severity.valueOf(31 + -8, "E}zuixxl\\oodjc+usi{~Yina}tx|t"), classNotFoundException);
            }
        }
        if (!wMSResponse.isSuccess()) {
            StreamRecorderConfig.logError(Utils.substring("Wcdg{nn~Naavxu=gawelK\u007fxsozvnf8#", 757 / 136) + wMSResponse.message);
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        wMSResponse.message = Utils.substring("H~\u007frl{%3b\u00006 '3--", 65 + -7);
        StreamRecorderConfig.logInfo(Utils.substring("QafiullxHcchfw?agugbE}zuixtpx:!", 208 / 58) + wMSResponse.message);
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists() {
        boolean bl = false;
        try {
            Class.forName(Severity.valueOf(33 * 33, "\"-.j2)02(d<!>`98>!'z\u001c\u0000\u001f7*."));
            IVHost iVHost = VHostSingleton.getInstance((String)this.vhostName);
            if (iVHost == null) return bl;
            IApplication iApplication = iVHost.getApplication(this.appName);
            if (iApplication == null) return bl;
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance == null) return bl;
            IStreamRecorder iStreamRecorder = iVHost.getLiveStreamRecordManager().getRecorder(iApplicationInstance, this.recorderName);
            if (iStreamRecorder == null) return bl;
            return true;
        }
        catch (Exception exception) {
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return bl;
        }
    }

    private static String a(String string) {
        if (string != null) {
            File file = new File(string);
            String string2 = file.getParent();
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        return null;
    }

    private static String b(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        String string2 = file.getName();
        return string2;
    }
}

