/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.instances.streamrecorders;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorder;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.instances.streamrecorders.StreamRecorderConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamRecorders")
@WMSDescription(text="Application Instance Stream Recorders", get="Retrieves the list of Stream Recorders for the specified Application Instance", post="Creates a new Stream Recorder in the specified Application Instance and starts recording")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/instances/{instanceName}/streamrecorders", restVerbs="GET,POST", xmlFilename="")
public class StreamRecordersConfig
extends ApplicationConfigBase {
    @JsonProperty(value="instanceName")
    @XStreamAlias(value="InstanceName")
    protected String instanceName;
    @JsonProperty(value="streamrecorder")
    @XStreamImplicit(itemFieldName="streamRecorders")
    protected List<StreamRecorderConfig> streamRecorders = null;

    public StreamRecordersConfig() {
        String string = Severity.valueOf(-1 - 1, "71sucmg`Hfel");
        this.addFieldForKeyMap(string, string, true);
    }

    public StreamRecordersConfig(String string, String string2, String string3) {
        super(string, string2);
        this.instanceName = string3;
        String string4 = Utils.substring("ce\u007fyoast\\ryp", 95 + -53);
        this.addFieldForKeyMap(string4, string4);
        this.addToStringKeyMap(Utils.substring(";='!79;<\u0014:18", 60 + 54), string3);
        this.initUrl();
    }

    public List<StreamRecorderConfig> getStreamRecorders() {
        return this.streamRecorders;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadObject() {
        boolean bl;
        block4: {
            IApplication iApplication;
            IVHost iVHost;
            bl = false;
            this.vhostName = this.getStringVariable(Utils.substring("\u007fbd\u007fy@n}t", 53 * 5));
            this.appName = this.getStringVariable(Utils.substring("dvwFhgn", 829 / 154));
            this.instanceName = this.getStringVariable(Severity.valueOf(17 - -42, "rrnj~.\"'\r%(#"));
            this.streamRecorders = new ArrayList<StreamRecorderConfig>();
            try {
                Class.forName(Severity.valueOf(15 + 126, "nab>f}dnt8`uj4mtrmk.HTKkvr"));
                iVHost = VHostSingleton.getInstance((String)this.vhostName);
                if (iVHost == null || (iApplication = iVHost.getApplication(this.appName)) == null) break block4;
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logException(Utils.substring("Pfgjtcm{yHcchfw?~|uqYur|yo", 82 + 80), classNotFoundException);
                break block4;
            }
            IApplicationInstance iApplicationInstance = iApplication.getAppInstance(this.instanceName);
            if (iApplicationInstance != null) {
                List list = iVHost.getLiveStreamRecordManager().getRecordersList(iApplicationInstance);
                for (IStreamRecorder iStreamRecorder : list) {
                    StreamRecorderConfig streamRecorderConfig = new StreamRecorderConfig(this.vhostName, this.appName, this.instanceName, iStreamRecorder.getStreamName());
                    streamRecorderConfig.loadObject(iStreamRecorder);
                    this.streamRecorders.add(streamRecorderConfig);
                }
                bl = true;
            }
        }
        Collections.sort(this.streamRecorders);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        StreamRecorderConfig streamRecorderConfig = new StreamRecorderConfig();
        Representation representation2 = streamRecorderConfig.post(representation, this.getRequest());
        this.setStatus(streamRecorderConfig.getStatus());
        if (streamRecorderConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(streamRecorderConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static StreamRecordersConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("nquhhS\u007fre", -11 - -35), string);
        hashMap.put(Severity.valueOf(115 + -111, "euvIido"), string2);
        return (StreamRecordersConfig)StreamRecordersConfig.getObjectFromREST(StreamRecordersConfig.getUrl(hashMap, StreamRecordersConfig.class), StreamRecordersConfig.class, wMSClientSecurity);
    }
}

