/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.modules;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.ApplicationsConfig;
import com.wowza.wms.rest.vhosts.applications.modules.ModuleConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Modules")
@WMSDescription(text="Application Modules", get="Retrieves the list of Modules for the specified Application", put="Updates the list of Modules for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/modules", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class ModulesConfig
extends ApplicationConfigBase {
    @JsonProperty(value="moduleList")
    @XStreamImplicit(itemFieldName="Module")
    @WMSXMLList(xpath="/Root/Application/Modules", keyxpath="/Module/Name", keyName="modulename")
    protected List<ModuleConfig> modulesList = new ArrayList<ModuleConfig>();

    public ModulesConfig() {
    }

    public ModulesConfig(String string, String string2) {
        super(string, string2);
    }

    public List<ModuleConfig> getModulesList() {
        return this.modulesList;
    }

    public void setModulesList(List<ModuleConfig> list) {
        this.modulesList = list;
    }

    public boolean contains(ModuleConfig moduleConfig) {
        return this.modulesList.contains(moduleConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean contains(String string) {
        boolean bl = false;
        if (this.modulesList != null) {
            for (ModuleConfig moduleConfig : this.modulesList) {
                if (moduleConfig.className == null) continue;
                bl |= moduleConfig.className.equalsIgnoreCase(string);
            }
        }
        return bl;
    }

    public boolean remove(ModuleConfig moduleConfig) {
        return this.modulesList.remove(moduleConfig);
    }

    public boolean add(ModuleConfig moduleConfig) {
        if (!this.modulesList.contains(moduleConfig)) {
            return this.modulesList.add(moduleConfig);
        }
        return true;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) return bl;
        int n = 0;
        Iterator<ModuleConfig> iterator = this.modulesList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(this.modulesList);
                return bl;
            }
            ModuleConfig moduleConfig = iterator.next();
            moduleConfig.setOrder(n++);
        }
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        Collections.sort(this.modulesList);
        this.vhostName = this.getStringVariable(Utils.substring("+6035\f\") ", 68 + 25));
        this.appName = this.getStringVariable(Severity.valueOf(43 * 19, "pbcZt{r"));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhostName, this.appName, this);
        return super.saveObject();
    }

    public static ModulesConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(122 + 105, "5,*53\u0006('."), string);
        hashMap.put(Utils.substring("dvwFhgn", 23 * 35), string2);
        return (ModulesConfig)ModulesConfig.getObjectFromREST(ModulesConfig.getUrl(hashMap, ModulesConfig.class), ModulesConfig.class, wMSClientSecurity);
    }
}

