/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentApplicationStatistics")
@WMSDescription(text="Application Current Statistics", get="Retrieves the current Application statistics")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/monitoring/current", restVerbs="GET", xmlFilename="Application.xml")
public class CurrentApplicationStatistics
extends ApplicationConfigBase {
    @JsonIgnore
    private String a;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected Long uptime;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected Long bytesIn;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected Long bytesOut;
    @JsonProperty(value="bytesInRate")
    @XStreamAlias(value="BytesInRate")
    protected long bytesInRate;
    @JsonProperty(value="bytesOutRate")
    @XStreamAlias(value="BytesOutRate")
    protected long bytesOutRate;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected Long totalConnections;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Long> connectionCount = new HashMap<String, Long>();
    private static final WMSLogger b = WMSLoggerFactory.getLogger(CurrentApplicationStatistics.class);

    public CurrentApplicationStatistics() {
        String string = Severity.valueOf(-29 - -4, "1 &9?\u0002,#*");
        this.addFieldForKeyMap(string, string, true);
        String string2 = Utils.substring(">01\f\") ", -30 - 3);
        this.addFieldForKeyMap(string2, string2, true);
    }

    public CurrentApplicationStatistics(String string, String string2) {
        super(string, string2);
        this.vhostName = string;
        this.a = string2;
        String string3 = Utils.substring("c~xkmTzqx", 43 * 31);
        this.addFieldForKeyMap(string3, string3, true);
        this.addToStringKeyMap(Utils.substring("\"=9$,\u0017;69", 109 + -25), string);
        String string4 = Utils.substring("#34\u000b'*-", 6 - -60);
        this.addFieldForKeyMap(string4, string4, true);
        this.addToStringKeyMap(Severity.valueOf(-4 - -35, "~pqLbi`"), string2);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Severity.valueOf(61 * 17, "Noa~~f3gt`r8xt;}mnsibcwmjh'{}k\u007fe~zfs"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        IVHost iVHost;
        this.vhostName = this.getStringVariable(Severity.valueOf(547 / 101, "snh{}Djah"));
        this.a = this.getStringVariable(Severity.valueOf(111 + 100, "2$%\u001865<"));
        if (RestProperties.getBoolean(Severity.valueOf(18 - 43, "5-:>\u00188,:&#%;0'\u001135->\u001f5=?2:d"))) {
            b.info(Severity.valueOf(1545 / 246, "Tb||xeeci/sd`aq{b7u|niu~m?fnp#") + this.vhostName + Utils.substring("#)%", 761 / 204) + this.a);
        }
        if ((iVHost = VHostSingleton.getInstance((String)this.vhostName)) == null) {
            return false;
        }
        IApplication iApplication = null;
        if (iVHost.isApplicationLoaded(this.a)) {
            iApplication = iVHost.getApplication(this.a);
        }
        if (iApplication == null) {
            this.connectionCount.put(Utils.substring("\u0010\u0001\u0005\u0013\u0005\f\u0010\u0014\u0014", 41 * 27), 0L);
            this.connectionCount.put(Severity.valueOf(5 * 5, "]LI_UKQKR"), 0L);
            this.connectionCount.put(Utils.substring("\r\u0011\u0007\u0004\u0000\u0004\u0015\u000f", 48 - -16), 0L);
            this.connectionCount.put(Severity.valueOf(33 * 41, "\u001a\u000b\u0005\u0006\u0002\u001d\n"), 0L);
            this.connectionCount.put(Utils.substring("VKHG]B", 9 * 29), 0L);
            this.connectionCount.put(Utils.substring("ARZT", -49 - 25), 0L);
            this.connectionCount.put(Utils.substring("TSEY", 225 / 37), 0L);
            this.connectionCount.put(Utils.substring("VQV", 1116 / 248), 0L);
            this.totalConnections = 0L;
            this.uptime = 0L;
            this.bytesIn = 0L;
            this.bytesOut = 0L;
            this.bytesInRate = 0L;
            this.bytesOutRate = 0L;
        } else {
            this.connectionCount.put(Severity.valueOf(24 + -17, "D]YOYXD@@"), iApplication.getConnectionCounter(2).getCurrent());
            this.connectionCount.put(Utils.substring("OZ_MGE_Y@", 19 * 9), iApplication.getConnectionCounter(7).getCurrent());
            this.connectionCount.put(Utils.substring("TJ^[Y_LH", 107 + -82), iApplication.getConnectionCounter(6).getCurrent());
            this.connectionCount.put(Severity.valueOf(483 / 150, "PEKLH[L"), iApplication.getConnectionCounter(4).getCurrent());
            this.connectionCount.put(Utils.substring("\u0005\u001a\u0017\u0016\u000e\u0013", 109 + 9), iApplication.getConnectionCounter(3).getCurrent());
            this.connectionCount.put(Severity.valueOf(81 + -75, "QBJD"), iApplication.getConnectionCounter(5).getCurrent());
            this.connectionCount.put(Severity.valueOf(901 / 184, "VQKW"), iApplication.getConnectionCounter(0).getCurrent());
            this.connectionCount.put(Severity.valueOf(50 - 18, "RUR"), iApplication.getConnectionCounter(1).getCurrent());
            this.totalConnections = 0L;
            for (int i = 0; i < 8; ++i) {
                CurrentApplicationStatistics currentApplicationStatistics = this;
                Long.valueOf(currentApplicationStatistics.totalConnections + iApplication.getConnectionCounter(i).getCurrent());
                currentApplicationStatistics.totalConnections = currentApplicationStatistics.totalConnections;
            }
            this.uptime = (long)iApplication.getTimeRunningSeconds();
            this.bytesIn = iApplication.getIoPerformanceCounter().getMessagesInBytes();
            this.bytesOut = iApplication.getIoPerformanceCounter().getMessagesOutBytes();
            this.bytesInRate = (long)iApplication.getIoPerformanceCounter().getMessagesInBytesRate();
            this.bytesOutRate = (long)iApplication.getIoPerformanceCounter().getMessagesOutBytesRate();
        }
        if (!RestProperties.getBoolean(Severity.valueOf(314 / 50, "tb{}Y\u007fmyg|dxq`Pptb\u007f\\tz~q{{"))) return true;
        b.info(Severity.valueOf(273 / 50, "Fsuzld\u007f,l~\u007f0|wgf|ud8\u007fui<") + this.vhostName + Severity.valueOf(198 / 48, "$(&") + this.a + Severity.valueOf(59 * 61, "50") + this.toString());
        return true;
    }

    public static CurrentApplicationStatistics getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("=$\"=;\u001e0?6", 15 + 92), string);
        hashMap.put(Utils.substring("<./N`of", 22 - 25), string2);
        return (CurrentApplicationStatistics)CurrentApplicationStatistics.getObjectFromREST(CurrentApplicationStatistics.getUrl(hashMap, CurrentApplicationStatistics.class), CurrentApplicationStatistics.class, wMSClientSecurity);
    }

    public Long getUptime() {
        return this.uptime;
    }

    public Long getBytesIn() {
        return this.bytesIn;
    }

    public Long getBytesOut() {
        return this.bytesOut;
    }

    public Long getTotalConnections() {
        return this.totalConnections;
    }

    public Map<String, Long> getConnectionCount() {
        return this.connectionCount;
    }

    public void setUptime(Long l) {
        this.uptime = l;
    }

    public void setBytesIn(Long l) {
        this.bytesIn = l;
    }

    public void setBytesOut(Long l) {
        this.bytesOut = l;
    }

    public void setTotalConnections(Long l) {
        this.totalConnections = l;
    }

    public void setConnectionCount(Map<String, Long> map) {
        this.connectionCount = map;
    }

    public long getBytesInRate() {
        return this.bytesInRate;
    }

    public long getBytesOutRate() {
        return this.bytesOutRate;
    }

    public void setBytesInRate(long l) {
        this.bytesInRate = l;
    }

    public void setBytesOutRate(long l) {
        this.bytesOutRate = l;
    }

    public String toString() {
        return Utils.substring("XiolznuCstiodi}cdb^zndxag}ve7Cljoup{\"", 113 + -86) + this.uptime + Utils.substring("bo2(&6'\u001c8j", 96 + 14) + this.bytesIn + Utils.substring("fk.4:*#\u001e''i", 60 - -14) + this.bytesOut + Severity.valueOf(666 / 197, "/$g\u007fsmzCe^lzj-") + this.bytesInRate + Severity.valueOf(782 / 219, "/$g\u007fsmzE~x_o{u,") + this.bytesOutRate + Utils.substring("}r';!7;\u001b6459>*6ooq>", -8 - 7) + this.totalConnections + Severity.valueOf(13 - 52, "uz8330:#5+,*\u0006)2&=w") + this.connectionCount + "]";
    }
}

