/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.server.monitoring.HistoricServerStatistics;
import com.wowza.wms.rest.server.monitoring.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryApplication;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricApplicationStatistics")
@WMSDescription(text="Application Historic Statistics", get="Retrieves the historic Application statistics")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricApplicationStatistics
extends HistoricalStatistics<StatsEntryApplication> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricApplicationStatistics.class);

    public HistoricApplicationStatistics() {
        String string = Utils.substring("wjlwqHfel", -9 - -10);
        this.addFieldForKeyMap(string, string, true);
        String string2 = Utils.substring("fxyDjah", 25 * 31);
        this.addFieldForKeyMap(string2, string2, true);
    }

    public HistoricApplicationStatistics(String string, String string2) {
        super(string, string2);
        this.vhostName = string;
        this.appName = string2;
        String string3 = Utils.substring("pogz~Em`k", 1048 / 169);
        this.addFieldForKeyMap(string3, string3, true);
        this.addToStringKeyMap(Utils.substring("#>8+-\u0014:18", -50 - -39), string);
        String string4 = Severity.valueOf(-56 - 50, "wghW{vy");
        this.addFieldForKeyMap(string4, string4, true);
        this.addToStringKeyMap(Utils.substring("6()\u0014:18", 61 * 35), string2);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.substring("C`lmkq&ti\u007fo+mc.n`a~zwtb~ww:hh|jv35+ ", -43 - 53));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricApplicationStatistics getObjectFromREST(String string, String string2, DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Utils.substring("7#4<\u001a>*8$=;92!\u001717#0\u001d7;908:", -10 - 49))) {
            a.info(String.format(Utils.substring("_k{bxwe}{q7nquhh=;l `rshlef|`ee,(}/cesgg5pewt:>o=jp`d1", 62 - 49), string, string2, dateTime, dateTime2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("\u007fbd\u007fy@n}t", -30 - 57), string);
        hashMap.put(Utils.substring("l~\u007f^p\u007fv", 29 * 49), string2);
        String string3 = HistoricApplicationStatistics.getUrl(hashMap, HistoricApplicationStatistics.class);
        try {
            String string4 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("\b\n\u0019-9", 17 * 45));
            String string5 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("LN]1%", 41 * 17));
            string3 = string3 + String.format(Severity.valueOf(1142 / 187, "9\"{4/x*(}25b"), Severity.valueOf(570 / 121, "wqgu|"), string4, Severity.valueOf(3 * 23, " (#"), string5);
            return (HistoricApplicationStatistics)HistoricApplicationStatistics.getObjectFromREST(string3, HistoricApplicationStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Severity.valueOf(351 / 53, "Siikfn,ya/u\u007fq|pp6cw9OOZ0&"), (Throwable)unsupportedEncodingException);
            return new HistoricApplicationStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryApplication> getDatabase() {
        ArrayList arrayList = new ArrayList();
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Severity.valueOf(-59 - -33, "\u00153)=9\u0006-#/(5#r::&\"66:?{22*\u007fawcjhddkm"));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Utils.substring("Bfr`f[vvx}~n=z~t``bw`&nfz~jbnk/~~f3ucw~txxwy", 35 * 59));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.applicationGetDatabase(this.vhostName, this.appName);
        if (iStatsDatabase != null) {
            iStatsDatabase.open();
            return iStatsDatabase;
        }
        a.warn(Utils.substring("\u001a>*8>\u0003.>056&u7'(538=)70n!fbpddf{l*bb~zn~rw3zzb7yo{rp||se", 109 + 124));
        return null;
    }
}

