/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.pushpublish;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.applications.pushpublish.PushPublishAppConfig;
import com.wowza.wms.rest.vhosts.applications.pushpublish.PushPublishStreamAppConfig;
import com.wowza.wms.rest.vhosts.pushpublish.PushPublishStreamsConfig;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="PushPublishStreams")
@WMSDescription(text="Application PushPublish Streams", get="Retrieves the list of PushPublish Streams for the specified Application", post="Adds a PushPublish Stream to list of PushPublish Streams for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/pushpublish/sourcestreams", restVerbs="GET,POST", xmlFilename="")
public class PushPublishStreamsAppConfig
extends PushPublishStreamsConfig {
    @XStreamOmitField
    protected String appName;
    @XStreamOmitField
    protected String pushPublishMapPath;

    public PushPublishStreamsAppConfig() {
    }

    public PushPublishStreamsAppConfig(String string, String string2) {
        super(string);
        this.appName = string2;
        this.addToStringKeyMap(Utils.substring("|no\u000e /&", 21 * 9), string2);
        this.initUrl();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getPushPublishMapPath() {
        return this.pushPublishMapPath;
    }

    public void setPushPublishMapPath(String string) {
        this.pushPublishMapPath = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(21 * 3, "~01\f\") "));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.substring("yx~agZt{r", 41 * 23));
        this.appName = this.getStringVariable(Severity.valueOf(-30 - 30, "%56\t)$/"));
        if (this.pushPublishMapPath == null) {
            this.pushPublishMapPath = PushPublishAppConfig.getPushPublishMapPath(this.vhostName, this.appName);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(1137 / 199, "fij&~e|vl x}b<p{{br`m4MTrmk"), this.vhostName);
        hashMap.put(Severity.valueOf(29 + 17, "m`}?e|cow9oti5\u007frpk%96m\u0012\r)4<\n%%*$)\u0007?<7"), VHostsConfig.getVHostDir(this.vhostName));
        hashMap.put(Utils.substring("dgd$|cztn>f\u007f`:vyyl|bo2\\nolhabplii", 56 - 49), this.appName);
        return SystemUtils.expandEnvironmentVariables((String)this.pushPublishMapPath, hashMap);
    }

    @Override
    public String getFilename() {
        return this.getBaseDir();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        PushPublishStreamAppConfig pushPublishStreamAppConfig = new PushPublishStreamAppConfig();
        Representation representation2 = pushPublishStreamAppConfig.post(representation, this.getRequest());
        this.setStatus(pushPublishStreamAppConfig.getStatus());
        if (pushPublishStreamAppConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(pushPublishStreamAppConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static PushPublishStreamsAppConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(69 + 101, "|cc~zAq|w"), string);
        hashMap.put(Utils.substring("dvwFhgn", 261 / 48), string2);
        return (PushPublishStreamsAppConfig)PushPublishStreamsAppConfig.getObjectFromREST(PushPublishStreamsAppConfig.getUrl(hashMap, PushPublishStreamsAppConfig.class), PushPublishStreamsAppConfig.class, wMSClientSecurity);
    }
}

