/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.streamconfiguration;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLProperty;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.applications.ApplicationConfigBase;
import com.wowza.wms.rest.vhosts.applications.ApplicationsConfig;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerList;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamList;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamConfiguration")
@WMSDescription(text="Application Stream Configuration", get="Retrieves the Stream configuration for the specified Application", put="Updates the Stream configuration for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/streamconfiguration", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class StreamConfigurationConfig
extends ApplicationConfigBase {
    @JsonProperty(value="streamType")
    @XStreamAlias(value="StreamType")
    @WMSXMLVariable(xpath="/Root/Application/Streams/StreamType/text()")
    protected String streamType;
    @JsonProperty(value="storageDir")
    @XStreamAlias(value="StorageDir")
    @WMSXMLVariable(xpath="/Root/Application/Streams/StorageDir/text()")
    protected String storageDir;
    @JsonProperty(value="createStorageDir")
    @XStreamAlias(value="CreateStorageDir")
    protected boolean createStorageDir;
    @JsonProperty(value="storageDirExists")
    @XStreamAlias(value="StorageDirExists")
    protected boolean storageDirExists;
    @JsonProperty(value="keyDir")
    @XStreamAlias(value="KeyDir")
    @WMSXMLVariable(xpath="/Root/Application/Streams/KeyDir/text()")
    protected String keyDir;
    @JsonProperty(value="liveStreamPacketizer")
    @XStreamAlias(value="LiveStreamPacketizers")
    @WMSXMLVariable(xpath="/Root/Application/Streams/LiveStreamPacketizers/text()")
    protected List<String> liveStreamPacketizer;
    @JsonProperty(value="httpRandomizeMediaName")
    @XStreamAlias(value="HTTPRandomizeMediaName")
    @WMSXMLProperty(root="/Root/Application/LiveStreamPacketizer", name="httpRandomizeMediaName", defaultValue="false")
    protected boolean httpRandomizeMediaName;
    @XStreamOmitField
    protected List<String> streamTypeOptions;
    @XStreamOmitField
    protected List<String> liveStreamPacketizerOptions;

    public StreamConfigurationConfig() {
    }

    public StreamConfigurationConfig(String string, String string2) {
        super(string, string2);
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public void setStorageDir(String string) {
        this.storageDir = string;
    }

    public void setCreateStorageDir(boolean bl) {
        this.createStorageDir = bl;
    }

    public boolean isStorageDirExists() {
        return this.storageDirExists;
    }

    public void setStorageDirExists(boolean bl) {
        this.storageDirExists = bl;
    }

    public String getKeyDir() {
        return this.keyDir;
    }

    public void setKeyDir(String string) {
        this.keyDir = string;
    }

    public List<String> getLiveStreamPacketizer() {
        return this.liveStreamPacketizer;
    }

    public void setLiveStreamPacketizer(List<String> list) {
        this.liveStreamPacketizer = list;
    }

    public List<String> getLiveStreamPacketizerOptions() {
        return this.liveStreamPacketizerOptions;
    }

    public void setLiveStreamPacketizerOptions(List<String> list) {
        this.liveStreamPacketizerOptions = list;
    }

    public List<String> getStreamTypeOptions() {
        return this.streamTypeOptions;
    }

    public void setStreamTypeOptions(List<String> list) {
        this.streamTypeOptions = list;
    }

    public boolean isHttpRandomizeMediaName() {
        return this.httpRandomizeMediaName;
    }

    public void setHttpRandomizeMediaName(boolean bl) {
        this.httpRandomizeMediaName = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a() {
        try {
            Object object2;
            Class.forName(Utils.substring("l\u007f|<d{blv6nwh2kvpsu,JRMit|", 31 * 17));
            IVHost iVHost = VHostSingleton.getInstance((String)Severity.valueOf(1017 / 162, "Ycmok~`yXG\u007fbfL"));
            if (iVHost == null) return;
            this.streamTypeOptions = new ArrayList<String>();
            this.liveStreamPacketizerOptions = new ArrayList<String>();
            LiveStreamPacketizerList liveStreamPacketizerList = iVHost.getLiveStreamPacketizerList();
            Map map = liveStreamPacketizerList.getLiveStreamPacketizerDefs();
            for (Object object2 : map.keySet()) {
                this.liveStreamPacketizerOptions.add((String)object2);
            }
            Collections.sort(this.liveStreamPacketizerOptions);
            StreamList streamList = iVHost.getStreamTypes();
            object2 = streamList.getStreamDefs();
            Iterator iterator = object2.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    Collections.sort(this.streamTypeOptions);
                    return;
                }
                String string = (String)iterator.next();
                this.streamTypeOptions.add(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        this.vhostName = this.getStringVariable(Utils.substring("gz|gaXvu|", 63 - 46));
        this.appName = this.getStringVariable(Utils.substring("~01\f\") ", 60 - -3));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhostName, this.appName, this);
        if (!this.createStorageDir) return super.saveObject();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("830p(ovxb*rkt&jeexhv{>GZ|ga", 41 * 3), this.vhostName);
        hashMap.put(Severity.valueOf(1394 / 239, "fij&~e|vl x}b<p{{br`m4MTrmkCnlembNhel"), VHostsConfig.getVHostDir(this.vhostName));
        hashMap.put(Severity.valueOf(59 - -11, "%(%g=$;7/a'<!}7:8#=!.u\u001d-.3)\"#7-*("), this.appName);
        try {
            File file = new File(SystemUtils.expandEnvironmentVariables((String)this.storageDir, hashMap));
            file.mkdir();
            return super.saveObject();
        }
        catch (Exception exception) {
            this.logException(Utils.substring("\u00188?+.=\u0012==2<1y+8,>\u0013?4:cu,noaou", -32 - -11), exception);
            return super.saveObject();
        }
    }

    @Override
    public boolean loadObject() {
        this.a();
        boolean bl = super.loadObject();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        this.storageDirExists = false;
        if (!bl) return bl;
        if (this.storageDir == null) return bl;
        this.setPathMap();
        String string2 = SystemUtils.expandEnvironmentVariables((String)this.storageDir, (Map)this.pathMap);
        File file = new File(string2);
        this.storageDirExists = file.exists();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        this.a();
        if ((this.saveFieldList == null || this.saveFieldList.contains(Utils.substring("=;\"43>\u0000,&2", 29 - 47))) && this.streamType != null) {
            this.streamType = this.streamType.trim();
            if (this.streamTypeOptions != null && !this.streamTypeOptions.contains(this.streamType)) {
                this.addErrorMessage(constraintValidatorContext, Utils.substring("  '365\r#+9", 42 + 73), Severity.valueOf(-28 - -62, "Wmokipf)Y\u007f~hobDhbv.5") + this.streamType);
                bl = false;
            }
        }
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Utils.substring("3)7'\u001007#&%\u0019+('(:&*4 ", 56 - -39))) return bl;
        }
        if (this.liveStreamPacketizer == null) return bl;
        if (this.liveStreamPacketizerOptions == null) return bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.liveStreamPacketizer) {
            if (string.trim().length() <= 0 || this.liveStreamPacketizerOptions == null) continue;
            if (!this.liveStreamPacketizerOptions.contains(string.trim())) {
                this.addErrorMessage(constraintValidatorContext, Severity.valueOf(25 * 59, "/-3#\u0014<;/*!\u001d/,;4&:.0$"), Utils.substring("Sicge|b-^nszwg}ose\"9", 1417 / 233) + string);
                bl = false;
            }
            if (arrayList.contains(string.trim())) continue;
            arrayList.add(string.trim());
        }
        this.liveStreamPacketizer.clear();
        this.liveStreamPacketizer.addAll(arrayList);
        Collections.sort(this.liveStreamPacketizer);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        if (this.saveFieldList != null) {
            if (!this.saveFieldList.contains(Severity.valueOf(53 + 88, "~z}up\u007fGmes"))) return bl;
        }
        if (!this.streamType.startsWith(Utils.substring("OmwV`eheldoii", 43 * 3))) return bl;
        this.addWarningMessage(Utils.substring("wqtbid^r|h", 820 / 171), "We dont recomened this stream type.");
        return true;
    }

    public static StreamConfigurationConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("e|zecVxw~", 3 * 17), string);
        hashMap.put(Severity.valueOf(-60 - -47, "2$%\u001865<"), string2);
        return (StreamConfigurationConfig)StreamConfigurationConfig.getObjectFromREST(StreamConfigurationConfig.getUrl(hashMap, StreamConfigurationConfig.class), StreamConfigurationConfig.class, wMSClientSecurity);
    }
}

