/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.applications.ApplicationsConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderTemplatesAppConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderConfig;
import java.io.File;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Transcoder")
@WMSDescription(text="Application Transcoder", get="Retrieves the Transcoder configuration for the specified Application", put="Updates the Transcoder configuration for the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/transcoder", restVerbs="GET,PUT", xmlFilename="Application.xml")
public class TranscoderAppConfig
extends TranscoderConfig {
    @XStreamOmitField
    protected String appName;
    @JsonProperty(value="liveStreamTranscoder")
    @XStreamAlias(value="LiveStreamTranscoder")
    @WMSXMLVariable(xpath="/Root/Application/Transcoder/LiveStreamTranscoder/text()")
    public String liveStreamTranscoder;
    @JsonProperty(value="templatesInUse")
    @XStreamAlias(value="TemplatesInUse")
    @WMSXMLVariable(xpath="/Root/Application/Transcoder/Templates/text()")
    protected String templatesInUse;
    @JsonProperty(value="profileDir")
    @XStreamAlias(value="ProfileDir")
    @WMSXMLVariable(xpath="/Root/Application/Transcoder/ProfileDir/text()")
    protected String profileDir;
    @JsonProperty(value="templateDir")
    @XStreamAlias(value="TemplatesDir")
    @WMSXMLVariable(xpath="/Root/Application/Transcoder/TemplateDir/text()")
    protected String templateDir;
    @JsonProperty(value="createTemplateDir")
    @XStreamAlias(value="CreateTemplateDir")
    protected boolean createTemplateDir = false;

    public TranscoderAppConfig() {
        String string = Severity.valueOf(75 + 50, "<./N`of");
        this.addFieldForKeyMap(string, string);
    }

    public TranscoderAppConfig(String string, String string2) {
        super(string);
        this.appName = string2;
        this.addToStringKeyMap(Utils.substring("&89\u0004*!(", 126 + 105), string2);
        this.initUrl();
        String string3 = Utils.substring("n`a\\ryp", 13 * 43);
        this.addFieldForKeyMap(string3, string3);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring(">pqLbi`", 42 - 43));
        String string = Severity.valueOf(1063 / 182, "dvwFhgn");
        this.addFieldForKeyMap(string, string);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getLiveStreamTranscoder() {
        return this.liveStreamTranscoder;
    }

    public void setLiveStreamTranscoder(String string) {
        this.liveStreamTranscoder = string;
    }

    public String getTemplatesInUse() {
        return this.templatesInUse;
    }

    public void setTemplatesInUse(String string) {
        this.templatesInUse = string;
    }

    public String getProfileDir() {
        return this.profileDir;
    }

    public void setProfileDir(String string) {
        this.profileDir = string;
    }

    public String getTemplateDir() {
        return this.templateDir;
    }

    public void setTemplateDir(String string) {
        this.templateDir = string;
    }

    public void setCreateTemplateDir(boolean bl) {
        this.createTemplateDir = bl;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = super.hasWarnings();
        return bl;
    }

    @Override
    public String getFilename() {
        String string = this.getStringVariable(Severity.valueOf(27 + 20, "yx~agZt{r"));
        String string2 = this.getStringVariable(Utils.substring("euvIido", 975 / 197));
        if (!string2.trim().equals(Utils.substring("\u000e6624#;,\u0006", -49 - -34))) {
            return VHostsConfig.getVHostDir(string) + Utils.substring("h+&$-c", -65 - -8) + string2.trim() + "/" + this.getXMLFilename();
        }
        return VHostsConfig.getVHostDir(string) + Severity.valueOf(32 + 81, "~1<:3y") + this.getXMLFilename();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        this.vhostName = this.getStringVariable(Utils.substring("1 &9?\u0002,#*", 57 + 14));
        this.appName = this.getStringVariable(Severity.valueOf(651 / 96, "gwxGkfi"));
        ApplicationsConfig.updateAppplicationInfoCache(this.vhostName, this.appName, this);
        if (!this.createTemplateDir) return super.saveObject();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("ehe'}d{wo!g|a=wzxc}an5JUqlt", 1241 / 190), this.vhostName);
        hashMap.put(Utils.substring("fij&~e|vl x}b<p{{br`m4MTrmkCnlembNhel", 473 / 87), VHostsConfig.getVHostDir(this.vhostName));
        hashMap.put(Utils.substring("fij&~e|vl x}b<p{{br`m4Zlmrvc`vjkk", 610 / 113), this.appName);
        try {
            File file = new File(SystemUtils.expandEnvironmentVariables((String)this.templateDir, hashMap));
            file.mkdir();
            return super.saveObject();
        }
        catch (Exception exception) {
            this.logException(Utils.substring("Pwgi{jeoi\u007fO\u007f`R}}r|q9kxl~S\u007ftzcu,noaou", 1149 / 231), exception);
            return super.saveObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        String string2;
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) return bl;
        HashMap<String, Object> hashMap = TranscoderAppConfig.getUserthreadlocal().get();
        if (hashMap == null) {
            TranscoderAppConfig.getUserthreadlocal().set(new HashMap());
            hashMap = TranscoderAppConfig.getUserthreadlocal().get();
        }
        if (!hashMap.containsKey(string2 = Severity.valueOf(96 + -50, "Z}q\u007fap{qseYijXssxv'o") + this.vhostName + "." + this.appName + Severity.valueOf(1380 / 210, "(smdzgmykKyc"))) {
            hashMap.put(string2, this.templateDir);
        }
        this.templates = new TranscoderTemplatesAppConfig(this.vhostName, this.appName);
        ((TranscoderTemplatesAppConfig)this.templates).setTemplateDir(this.templateDir);
        WMSConfig wMSConfig = TranscoderTemplatesAppConfig.class.getAnnotation(WMSConfig.class);
        TranscoderAppConfig transcoderAppConfig = this;
        String string3 = transcoderAppConfig.getServerFromUri(transcoderAppConfig.restURI) + wMSConfig.restLocation();
        string3 = this.resolveVariables(string3);
        this.templates.setRestURI(string3);
        this.templates.loadObject();
        return bl;
    }

    public static TranscoderAppConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(-57 - 44, "mtrmkN`of"), string);
        hashMap.put(Severity.valueOf(31 * 41, "6()\u0014:18"), string2);
        return (TranscoderAppConfig)TranscoderAppConfig.getObjectFromREST(TranscoderAppConfig.getUrl(hashMap, TranscoderAppConfig.class), TranscoderAppConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getTemplateDir(String string, String string2) {
        String string3;
        HashMap<String, Object> hashMap = TranscoderAppConfig.getUserthreadlocal().get();
        if (hashMap == null) {
            TranscoderAppConfig.getUserthreadlocal().set(new HashMap());
            hashMap = TranscoderAppConfig.getUserthreadlocal().get();
        }
        if (hashMap.containsKey(string3 = Utils.substring("Mhzrn}pddpBtuEhfocl\"", 30 + -5) + string + "." + string2 + Utils.substring("qtdoshdrbL`x", 13 * 59))) return (String)hashMap.get(string3);
        TranscoderAppConfig transcoderAppConfig = new TranscoderAppConfig(string, string2);
        transcoderAppConfig.loadObject();
        hashMap.put(string3, transcoderAppConfig.getTemplateDir());
        return (String)hashMap.get(string3);
    }
}

