/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderEncodeAppConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderTemplateAppConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderEncodesConfig;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderEncodes")
@WMSDescription(text="Application Transcoder Encodes", get="Retrieves the list of Transcoder Encode Configurations for the specified Application", post="Adds a Transcoder Encode Configuration to the specified Application")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/transcoder/templates/{templateName}/encodes", restVerbs="GET,POST", xmlFilename="")
public class TranscoderEncodesAppConfig
extends TranscoderEncodesConfig {
    @XStreamOmitField
    protected String appName;

    public TranscoderEncodesAppConfig() {
        String string = Utils.substring("%56\t)$/", 23 + 45);
        this.addFieldForKeyMap(string, string);
    }

    public TranscoderEncodesAppConfig(String string, String string2, String string3) {
        super(string, string3);
        this.appName = string2;
        this.addToStringKeyMap(Utils.substring("tfgVxw~", 90 + 59), string2);
        this.initUrl();
        String string4 = Severity.valueOf(3 * 17, "rdeXvu|");
        this.addFieldForKeyMap(string4, string4);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("euvIido", 744 / 155));
    }

    @Override
    public boolean loadObject() {
        TranscoderTemplateAppConfig transcoderTemplateAppConfig = new TranscoderTemplateAppConfig(this.vhostName, this.appName, this.templateName);
        transcoderTemplateAppConfig.loadObject();
        this.encodes.clear();
        Iterator<TranscoderEncodeConfig> iterator = transcoderTemplateAppConfig.getEncodes().iterator();
        while (iterator.hasNext()) {
            TranscoderEncodeConfig transcoderEncodeConfig = iterator.next();
            this.encodes.add(new ShortObject(transcoderEncodeConfig.encodeName, this.restURI + "/" + transcoderEncodeConfig.encodeName));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        TranscoderEncodeAppConfig transcoderEncodeAppConfig = new TranscoderEncodeAppConfig();
        Representation representation2 = transcoderEncodeAppConfig.post(representation, this.getRequest());
        this.setStatus(transcoderEncodeAppConfig.getStatus());
        if (transcoderEncodeAppConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(transcoderEncodeAppConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static TranscoderEncodesAppConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(517 / 113, "rmit|Gkfi"), string);
        hashMap.put(Severity.valueOf(102 + -65, "dvwFhgn"), string2);
        hashMap.put(Severity.valueOf(53 * 3, "kelroeqcIido"), string3);
        return (TranscoderEncodesAppConfig)TranscoderEncodesAppConfig.getObjectFromREST(TranscoderEncodesAppConfig.getUrl(hashMap, TranscoderEncodesAppConfig.class), TranscoderEncodesAppConfig.class, wMSClientSecurity);
    }
}

