/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderStreamNameGroupAppConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderTemplateAppConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderStreamNameGroupConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderStreamNameGroupsConfig;
import java.util.HashMap;
import java.util.Iterator;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderStreamNameGroups")
@WMSDescription(text="Application Transcoder Stream Name Groups", get="Retrieves the list of Transcoder Stream Name Groups for the specified Template", post="Adds a Transcoder Stream Name Groups Configuration to the specified Template")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/transcoder/templates/{templateName}/streamnamegroups", restVerbs="GET,POST", xmlFilename="")
public class TranscoderStreamNameGroupsAppConfig
extends TranscoderStreamNameGroupsConfig {
    @XStreamOmitField
    protected String appName;

    public TranscoderStreamNameGroupsAppConfig() {
        String string = Severity.valueOf(49 * 13, "<./N`of");
        this.addFieldForKeyMap(string, string);
    }

    public TranscoderStreamNameGroupsAppConfig(String string, String string2, String string3) {
        super(string, string3);
        this.appName = string2;
        this.addToStringKeyMap(Utils.substring("6()\u0014:18", -34 - -25), string2);
        this.initUrl();
        String string4 = Severity.valueOf(55 * 57, "~01\f\") ");
        this.addFieldForKeyMap(string4, string4);
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("tfgVxw~", 44 - -9));
    }

    @Override
    public boolean loadObject() {
        TranscoderTemplateAppConfig transcoderTemplateAppConfig = new TranscoderTemplateAppConfig(this.vhostName, this.appName, this.templateName);
        transcoderTemplateAppConfig.loadObject();
        this.streamNameGroups.clear();
        Iterator<TranscoderStreamNameGroupConfig> iterator = transcoderTemplateAppConfig.getStreamNameGroups().iterator();
        while (iterator.hasNext()) {
            TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig = iterator.next();
            this.streamNameGroups.add(new ShortObject(transcoderStreamNameGroupConfig.groupName, this.restURI + "/" + transcoderStreamNameGroupConfig.groupName));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        TranscoderStreamNameGroupAppConfig transcoderStreamNameGroupAppConfig = new TranscoderStreamNameGroupAppConfig();
        Representation representation2 = transcoderStreamNameGroupAppConfig.post(representation, this.getRequest());
        this.setStatus(transcoderStreamNameGroupAppConfig.getStatus());
        if (transcoderStreamNameGroupAppConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(transcoderStreamNameGroupAppConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static TranscoderStreamNameGroupsAppConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("snh{}Djah", 263 / 51), string);
        hashMap.put(Severity.valueOf(23 * 31, "(:;\u0002,#*"), string2);
        hashMap.put(Utils.substring("rbeyfjxh@n}t", 418 / 61), string3);
        return (TranscoderStreamNameGroupsAppConfig)TranscoderStreamNameGroupsAppConfig.getObjectFromREST(TranscoderStreamNameGroupsAppConfig.getUrl(hashMap, TranscoderStreamNameGroupsAppConfig.class), TranscoderStreamNameGroupsAppConfig.class, wMSClientSecurity);
    }
}

