/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.applications.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.util.SystemUtils;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderAppConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderEncodeAppConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderOverlayDecodeAppConfig;
import com.wowza.wms.rest.vhosts.applications.transcoder.TranscoderStreamNameGroupAppConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderOverlayDecodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderStreamNameGroupConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderTemplate")
@WMSDescription(text="Application Trancoder Template", get="Retrieves the specified Trancoder Template configuration", put="Updates the specified Trancoder Template configuration", post="Adds the specified Trancoder Template configuration", delete="Deletes the specified Trancoder Template configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/applications/{appName}/transcoder/templates/{templateName}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderTemplateAppConfig
extends TranscoderTemplateConfig {
    @XStreamOmitField
    protected String appName;
    @WMSXMLList(xpath="/Root/Transcode/Encodes", keyxpath="/Encode/Name", keyName="encodeName")
    protected List<TranscoderEncodeAppConfig> encodesApp;
    @WMSXMLList(xpath="/Root/Transcode/StreamNameGroups", keyxpath="/StreamNameGroup/Name", keyName="groupName")
    protected List<TranscoderStreamNameGroupAppConfig> streamNameGroupsApp;
    @WMSXMLList(xpath="/Root/Transcode/Decode/Video/Overlays", keyxpath="/Overlay/Name", keyName="overlayName")
    protected List<TranscoderOverlayDecodeAppConfig> decodeOverlaysApp;

    public TranscoderTemplateAppConfig() {
    }

    public TranscoderTemplateAppConfig(String string, String string2, String string3) {
        super(string, string3);
        this.appName = string2;
        this.addToStringKeyMap(Severity.valueOf(8 + 14, "wghW{vy"), string2);
        this.initUrl();
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public List<TranscoderEncodeAppConfig> getEncodesApp() {
        return this.encodesApp;
    }

    public List<TranscoderStreamNameGroupAppConfig> getStreamNameGroupsApp() {
        return this.streamNameGroupsApp;
    }

    public List<TranscoderOverlayDecodeAppConfig> getDecodeOverlaysApp() {
        return this.decodeOverlaysApp;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("dvwFhgn", 965 / 175));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Field[] getDeclaredFields() {
        Field[] fieldArray = null;
        try {
            ArrayList<Field> arrayList = new ArrayList<Field>(Arrays.asList(this.getClass().getSuperclass().getDeclaredFields()));
            arrayList.add(this.getClass().getDeclaredField(Utils.substring("akehllyJ|}", 1007 / 225)));
            arrayList.add(this.getClass().getDeclaredField(Severity.valueOf(-32 - 61, "ppwcfeGkfiJ|`eaaRde")));
            arrayList.add(this.getClass().getDeclaredField(Utils.substring("s}zu\u007fyRhzrmczwDvw", 47 * 25)));
            ArrayList<Field> arrayList2 = arrayList;
            return arrayList2.toArray(new Field[arrayList2.size()]);
        }
        catch (Exception exception) {
            ConfigBase.logWarn(Utils.substring("\u0005$8:5?6|:;+thld$acddhxnh-hfu}v`.5", 42 - 53) + this.getQuery(), exception);
            return fieldArray;
        }
    }

    @Override
    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.substring("rmit|Gkfi", 1014 / 207));
        this.appName = this.getStringVariable(Utils.substring("/? \u001f3>1", 54 - -56));
        String string = TranscoderAppConfig.getTemplateDir(this.vhostName, this.appName);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(60 + -18, "ida#y`gks=cxe9{vtoyej1\u0016\t-00"), this.vhostName);
        hashMap.put(Severity.valueOf(31 * 39, "zuv2jqh: l4)6h$''>.49`\u0019\u0018>!'\u0017:811>\u0012418"), VHostsConfig.getVHostDir(this.vhostName));
        hashMap.put(Severity.valueOf(85 + 69, "ytq3ipw{c-shu)kfd\u007fiuz!Qab\u007f}vwcqvt"), this.appName);
        return SystemUtils.expandEnvironmentVariables((String)string, hashMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) {
            return bl;
        }
        this.encodes = new ArrayList<TranscoderEncodeConfig>();
        this.encodes.addAll(this.encodesApp);
        this.encodesApp.clear();
        this.encodesApp = null;
        this.streamNameGroups = new ArrayList<TranscoderStreamNameGroupConfig>();
        this.streamNameGroups.addAll(this.streamNameGroupsApp);
        this.streamNameGroupsApp.clear();
        this.streamNameGroupsApp = null;
        this.decodeOverlays = new ArrayList<TranscoderOverlayDecodeConfig>();
        this.decodeOverlays.addAll(this.decodeOverlaysApp);
        this.decodeOverlaysApp.clear();
        this.decodeOverlaysApp = null;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean updateXML(Document document) {
        if (this.decodeOverlays == null) return super.updateXML(document);
        this.decodeOverlaysApp = new ArrayList<TranscoderOverlayDecodeAppConfig>();
        Iterator<TranscoderOverlayDecodeConfig> iterator = this.decodeOverlays.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.decodeOverlays.clear();
                this.decodeOverlays = null;
                return super.updateXML(document);
            }
            TranscoderOverlayDecodeConfig transcoderOverlayDecodeConfig = iterator.next();
            TranscoderOverlayDecodeAppConfig transcoderOverlayDecodeAppConfig = new TranscoderOverlayDecodeAppConfig(transcoderOverlayDecodeConfig);
            this.decodeOverlaysApp.add(transcoderOverlayDecodeAppConfig);
        }
    }

    @Override
    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateAppConfig(this.vhostName, this.appName, string);
    }

    public static TranscoderTemplateAppConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("+6035\f\") ", 42 - -51), string);
        hashMap.put(Severity.valueOf(35 * 27, "pbcZt{r"), string2);
        hashMap.put(Severity.valueOf(10 + 114, "(83/l`vfJdkb"), string3);
        return (TranscoderTemplateAppConfig)TranscoderTemplateAppConfig.getObjectFromREST(TranscoderTemplateAppConfig.getUrl(hashMap, TranscoderTemplateAppConfig.class), TranscoderTemplateAppConfig.class, wMSClientSecurity);
    }
}

