/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="CurrentVHostStatistics")
@WMSDescription(text="VHost Current Statistics", get="Retrieves the current VHost statistics")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/monitoring/current", restVerbs="GET", xmlFilename="")
public class CurrentVHostStatistics
extends ConfigBase {
    @JsonIgnore
    protected String vhostName;
    @JsonProperty(value="uptime")
    @XStreamAlias(value="Uptime")
    protected Long uptime;
    @JsonProperty(value="bytesIn")
    @XStreamAlias(value="BytesIn")
    protected Long bytesIn;
    @JsonProperty(value="bytesOut")
    @XStreamAlias(value="BytesOut")
    protected Long bytesOut;
    @JsonProperty(value="totalConnections")
    @XStreamAlias(value="TotalConnections")
    protected Long totalConnections;
    @JsonProperty(value="connectionCount")
    @XStreamAlias(value="ConnectionCount")
    protected Map<String, Long> connectionCount = new HashMap<String, Long>();
    private static final WMSLogger a = WMSLoggerFactory.getLogger(CurrentVHostStatistics.class);

    public CurrentVHostStatistics() {
        String string = Severity.valueOf(-46 - -56, "|cc~zAq|w");
        this.addFieldForKeyMap(string, string);
    }

    public CurrentVHostStatistics(String string) {
        this.vhostName = string;
        String string2 = Severity.valueOf(47 * 7, "?\"$?9\u0000.=4");
        this.addFieldForKeyMap(string2, string2, true);
        this.addToStringKeyMap(Severity.valueOf(55 * 47, "ortoiP~md"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("(7orvMehc", 19 - 21));
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.substring("\u001e?1..6c7$0\"h($k-=>#923'=:8w+-;/5.*6c", -19 - 16));
    }

    @Override
    protected boolean exists() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        IVHost iVHost;
        this.vhostName = this.getStringVariable(Severity.valueOf(59 * 59, "ortoiP~md"));
        if (RestProperties.getBoolean(Utils.substring("wct|Z~jxd}{yraWqwcp]w{ypxz", 1296 / 227))) {
            a.info(Severity.valueOf(29 * 47, "\u00011!#%604<|>+-2$,7d(#3: )8l+!=p") + this.vhostName);
        }
        if ((iVHost = VHostSingleton.getInstance((String)this.vhostName)) == null) {
            return false;
        }
        this.connectionCount.put(Severity.valueOf(3 - 4, "\u001cUQGQPLHH"), iVHost.getConnectionCounter(2).getCurrent());
        this.connectionCount.put(Severity.valueOf(67 + -38, "YHMCIWMOV"), iVHost.getConnectionCounter(7).getCurrent());
        this.connectionCount.put(Severity.valueOf(46 - -3, "\\BVSQWDP"), iVHost.getConnectionCounter(6).getCurrent());
        this.connectionCount.put(Severity.valueOf(37 + 3, "[HDAC^K"), iVHost.getConnectionCounter(4).getCurrent());
        this.connectionCount.put(Severity.valueOf(47 + 6, "F[XWMR"), iVHost.getConnectionCounter(3).getCurrent());
        this.connectionCount.put(Utils.substring("\u001f\f\b\u0006", 9 + 95), iVHost.getConnectionCounter(5).getCurrent());
        this.connectionCount.put(Severity.valueOf(45 * 37, "SVNT"), iVHost.getConnectionCounter(0).getCurrent());
        this.connectionCount.put(Severity.valueOf(63 * 33, "MTQ"), iVHost.getConnectionCounter(1).getCurrent());
        this.totalConnections = 0L;
        int n = 0;
        while (true) {
            if (n >= 8) {
                this.uptime = (long)iVHost.getTimeRunningSeconds();
                this.bytesIn = iVHost.getIoPerformanceCounter().getMessagesInBytes();
                this.bytesOut = iVHost.getIoPerformanceCounter().getMessagesOutBytes();
                if (!RestProperties.getBoolean(Utils.substring("v`us[}k\u007fe~zfsbVvv`qRvxxwyy", 43 - 39))) return true;
                a.info(Severity.valueOf(640 / 112, "Fsuzld\u007f,{f`ce2~qad~{j ;") + this.toString());
                return true;
            }
            CurrentVHostStatistics currentVHostStatistics = this;
            Long.valueOf(currentVHostStatistics.totalConnections + iVHost.getConnectionCounter(n).getCurrent());
            currentVHostStatistics.totalConnections = currentVHostStatistics.totalConnections;
            ++n;
        }
    }

    public static CurrentVHostStatistics getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (CurrentVHostStatistics)CurrentVHostStatistics.getObjectFromREST(CurrentVHostStatistics.getUrl(Utils.substring("pogz~Em`k", 838 / 136), string, CurrentVHostStatistics.class), CurrentVHostStatistics.class, wMSClientSecurity);
    }

    public void setUptime(Long l) {
        this.uptime = l;
    }

    public Long getUptime() {
        return this.uptime;
    }

    public Long getBytesIn() {
        return this.bytesIn;
    }

    public Long getBytesOut() {
        return this.bytesOut;
    }

    public Map<String, Long> getConnectionCount() {
        return this.connectionCount;
    }

    public Long getTotalConnections() {
        return this.totalConnections;
    }

    public void setTotalConnections(Long l) {
        this.totalConnections = l;
    }

    public void setBytesIn(Long l) {
        this.bytesIn = l;
    }

    public void setBytesOut(Long l) {
        this.bytesOut = l;
    }

    public void setConnectionCount(Map<String, Long> map) {
        this.connectionCount = map;
    }

    public String toString() {
        return Severity.valueOf(-6 - 29, "\u001e+-2$,7\u0012\r)4<\u001a>*8$=;92!s\u000f#>8+-g") + this.vhostName + Severity.valueOf(49 * 31, "cp$\"'=83j") + this.uptime + Severity.valueOf(125 + 91, "ty8\"(8-\u0016.|") + this.bytesIn + Severity.valueOf(115 + 43, "2?bxvfwJss5") + this.bytesOut + Severity.valueOf(41 * 49, "uz/3)?3\u0003.,-!&2.''9v") + this.totalConnections + Severity.valueOf(28 - 38, "zw;6459>*6ooAlqkr:") + this.connectionCount + "]";
    }
}

