/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.monitoring;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.RestProperties;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.server.monitoring.HistoricServerStatistics;
import com.wowza.wms.rest.server.monitoring.HistoricalStatistics;
import com.wowza.wms.stats.IStatsManager;
import com.wowza.wms.stats.StatsManager;
import com.wowza.wms.stats.database.IStatsDatabase;
import com.wowza.wms.stats.database.IStatsDatabaseManager;
import com.wowza.wms.stats.entry.StatsEntryVHost;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.joda.time.DateTime;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="HistoricVHostStatistics")
@WMSDescription(text="VHost Historic Statistics", get="Retrieves the historic VHost statistics")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/monitoring/historic", restVerbs="GET", xmlFilename="Application.xml")
public class HistoricVHostStatistics
extends HistoricalStatistics<StatsEntryVHost> {
    private static final WMSLogger a = WMSLoggerFactory.getLogger(HistoricVHostStatistics.class);

    public HistoricVHostStatistics() {
        String string = Utils.substring("%<:%#\u001687>", 19 * 33);
        this.addFieldForKeyMap(string, string, true);
    }

    public HistoricVHostStatistics(String string) {
        super(string);
        this.vhostName = string;
        String string2 = Utils.substring("<##>:\u00011<7", 72 + 2);
        this.addFieldForKeyMap(string2, string2, true);
        this.addToStringKeyMap(Severity.valueOf(25 * 59, "5,*53\u0006('."), string);
        this.initUrl();
    }

    @Override
    public WMSResponse saveObject() throws ConfigBase.ConfigBaseException {
        throw new UnsupportedOperationException(Utils.substring("Wtxywm:h}k{?!/b\"45*.+(>\"##n<$0&:'!?4", 41 + 11));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HistoricVHostStatistics getObjectFromREST(String string, DateTime dateTime, DateTime dateTime2, WMSClientSecurity wMSClientSecurity) {
        if (RestProperties.getBoolean(Utils.substring("j|ioOi\u007fkirvjgvBbj|mNbllcuu", -20 - -44))) {
            a.info(String.format(Severity.valueOf(25 * 59, "\u0011!14.-?#%+m8'?\"&sq&v$,8.(|;,0-ag0d1)gm:"), string, dateTime, dateTime2));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("%<:%#\u001687>", 33 * 19), string);
        String string2 = HistoricVHostStatistics.getUrl(hashMap, HistoricVHostStatistics.class);
        try {
            String string3 = URLEncoder.encode(dateTime.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("XZI=)", -14 - -27));
            String string4 = URLEncoder.encode(dateTime2.toString(HistoricalStatistics.DATE_FORMATTER), Utils.substring("SSN$2", 1177 / 177));
            string2 = string2 + String.format(Severity.valueOf(9 * 37, "rk<mt!uq&kr+"), Severity.valueOf(70 + 10, "#%3! "), string3, Utils.substring("80;", -19 - -16), string4);
            return (HistoricVHostStatistics)HistoricVHostStatistics.getObjectFromREST(string2, HistoricVHostStatistics.class, wMSClientSecurity);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            WMSLogger.getLogger(HistoricServerStatistics.class).warn((Object)Utils.substring("Qkgedl*\u007fc-kas~vv4ay7MM\\6$", 37 + 95), (Throwable)unsupportedEncodingException);
            return new HistoricVHostStatistics();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IStatsDatabase<StatsEntryVHost> getDatabase() {
        IStatsManager iStatsManager = StatsManager.getInstance();
        if (iStatsManager == null) {
            a.warn(Severity.valueOf(110 + 12, "\t/=)-\u0012aocdaw&nfz~jbnk/~~f3ucw~txxwy"));
            return null;
        }
        IStatsDatabaseManager iStatsDatabaseManager = iStatsManager.getStatsDatabaseManager();
        if (iStatsDatabaseManager == null) {
            a.warn(Severity.valueOf(122 / 40, "PpdrtLh~jnl}j]p|rspd7qwio}s}z omw$dpfaeki`h"));
            return null;
        }
        IStatsDatabase iStatsDatabase = iStatsDatabaseManager.vhostGetDatabase(this.vhostName);
        if (iStatsDatabase != null) {
            iStatsDatabase.open();
            return iStatsDatabase;
        }
        a.warn(Utils.substring("Vcu~lx+hlznrpav4{yc8xlzuq\u007f}ld", 639 / 116));
        return null;
    }
}

