/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.publishers;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.publishers.PublishersVhostConfig;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Publisher")
@WMSDescription(text="VHost Publisher", get="Retrieves the specified Publisher configuration", put="Updates the specified Publisher configuration", post="Adds the specified Publisher configuration", delete="Deletes the specified Publisher configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/publishers/{publisher}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="")
public class PublisherVhostConfig
extends ConfigBase
implements Comparable<PublisherVhostConfig> {
    @XStreamOmitField
    @WMSPathVariable(description="The vhost name")
    protected String vhostName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSPathVariable(name="publisher", description="The publisher name")
    protected String name;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    protected String description;
    @JsonProperty(value="password")
    @XStreamAlias(value="Password")
    protected String password;
    @XStreamOmitField
    protected String privatePassword;

    public PublisherVhostConfig() {
        this.addFieldForKeyMap(Utils.substring("hlxwunvz2", -60 - 12), "name");
        String string = Severity.valueOf(21 * 23, "5,*53\u0006('.");
        this.addFieldForKeyMap(string, string);
    }

    public PublisherVhostConfig(String string, String string2) {
        this.addFieldForKeyMap(Utils.substring("{yobfcywa", 16 + 27), "name");
        String string3 = Utils.substring("uljusFhgn", 188 / 58);
        this.addFieldForKeyMap(string3, string3);
        this.name = string2;
        this.addToStringKeyMap(Utils.substring("vrjecxdh|", 1047 / 151), string2);
        this.addToStringKeyMap(Severity.valueOf(97 + 122, "-42-+\u000e /&"), string);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(54 - -35, ")/904-7%3"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(497 / 72, "pogz~Em`k"));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPrivatePassword() {
        return this.privatePassword;
    }

    public void setPrivatePassword(String string) {
        this.privatePassword = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        boolean bl = false;
        this.fillStringKeyMap();
        this.name = this.getStringVariable(Severity.valueOf(220 / 68, "sqgjn{aoy"));
        PublisherVhostConfig publisherVhostConfig = ((PublishersVhostConfig)this.getPublishersConfig()).getPublisher(this.name);
        if (publisherVhostConfig == null) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean exists() {
        PublisherVhostConfig publisherVhostConfig = ((PublishersVhostConfig)this.getPublishersConfig()).getPublisher(this.name);
        if (publisherVhostConfig == null) return false;
        return true;
    }

    public ConfigBase getPublishersConfig() {
        PublishersVhostConfig publishersVhostConfig = new PublishersVhostConfig(this.vhostName);
        publishersVhostConfig.loadObject();
        return publishersVhostConfig;
    }

    @Override
    public WMSResponse saveObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            wMSResponse = ((PublishersVhostConfig)this.getPublishersConfig()).updatePublisher(this);
            return wMSResponse;
        }
        ConfigBase.log.warn((Object)Severity.valueOf(45 * 63, "AQFB7YIS!<N\u007fiioe#Tpdkazbn~~4/Y\u007f2gftrr8jrtk=sp$$lcd\u000b)3h*%&!$:;9?5s7=79?<)u"));
        wMSResponse.success = true;
        wMSResponse.message = Severity.valueOf(21 * 49, "Vgqmm");
        return wMSResponse;
    }

    @Override
    public WMSResponse saveNewObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (!ConfigBase.inTradeShowMode) {
            this.privatePassword = this.password;
            return ((PublishersVhostConfig)this.getPublishersConfig()).addPublisher(this);
        }
        ConfigBase.log.warn((Object)(Severity.valueOf(-33 - -58, "K_HH=_OI;\"B`aoio)Z~nag|xt`34=") + this.name + Utils.substring("fjq\u001b=t!$6<<z(42)\u007f-.&&jef\t'=j*()'!7q4:80x", 25 * 39)));
        wMSResponse.success = true;
        wMSResponse.message = Utils.substring("Gclln", 1538 / 243);
        return wMSResponse;
    }

    @Override
    public WMSResponse deleteObject() {
        return ((PublishersVhostConfig)this.getPublishersConfig()).removePublisher(this.name);
    }

    public static PublisherVhostConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (PublisherVhostConfig)PublisherVhostConfig.getObjectFromREST(PublisherVhostConfig.getUrl(Utils.substring("ecutpisyo", 21 * 33), string, PublisherVhostConfig.class), PublisherVhostConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(PublisherVhostConfig publisherVhostConfig) {
        return this.name.compareTo(publisherVhostConfig.getName());
    }
}

