/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.pushpublish;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.pushpublish.PushPublishStreamConfig;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="PushPublishStreams")
@WMSDescription(text="VHost PushPublish Streams", get="Retrieves the list of PushPublish Streams for the specified VHost", post="Adds a PushPublish Stream to list of PushPublish Streams for the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/pushpublish/sourcestreams", restVerbs="GET,POST", xmlFilename="PushPublishMap.txt")
public class PushPublishStreamsConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="streamsStreams")
    @XStreamImplicit(itemFieldName="Streams")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public PushPublishStreamsConfig() {
        String string = Utils.substring("pogz~Em`k", 833 / 127);
        this.addFieldForKeyMap(string, string);
    }

    public PushPublishStreamsConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Severity.valueOf(5 - -36, "\u007fbd\u007fy@n}t"), string);
        this.initUrl();
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public List<ShortObject> getSourceStreams() {
        return this.a;
    }

    public void setSourceStreams(List<ShortObject> list) {
        this.a = list;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("rmit|Gkfi", 592 / 141));
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Severity.valueOf(28 - 56, "2-)4<\u0007+&)"));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Utils.substring("{699>", 50 - -34);
    }

    @Override
    public boolean exists() {
        return true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean loadObjectFromFile(String var1_1) {
        var2_2 = false;
        this.a.clear();
        try {
            var3_4 = new File(var1_1);
            if (!var3_4.exists()) {
                return true;
            }
        }
        catch (Exception var3_3) {
            ConfigBase.log.warn((Object)(Utils.substring("Vugkfna-b`qu{}s5pewt:}uq{% ", 267 / 40) + var1_1), (Throwable)var3_3);
            return var2_2;
        }
        this.version = var3_4.lastModified() + "";
        var4_5 = new FileInputStream(var1_1);
        var5_6 = new DataInputStream(var4_5);
        var6_7 = new BufferedReader(new InputStreamReader(var5_6));
        if (true) ** GOTO lbl20
        while (true) {
            if (var7_8.charAt(0) != '-' && var7_8.charAt(0) != '#' && (var8_9 = var7_8.split("=")).length > 1) {
                this.a.add(new ShortObject(var8_9[0], this.restURI + "/" + var8_9[0]));
            }
lbl20:
            // 4 sources

            do {
                if ((var7_8 = var6_7.readLine()) != null) continue;
                var6_7.close();
                return true;
            } while ((var7_8 = var7_8.trim()).length() == 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        PushPublishStreamConfig pushPublishStreamConfig = new PushPublishStreamConfig();
        Representation representation2 = pushPublishStreamConfig.post(representation, this.getRequest());
        this.setStatus(pushPublishStreamConfig.getStatus());
        if (pushPublishStreamConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(pushPublishStreamConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static PushPublishStreamsConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (PushPublishStreamsConfig)PushPublishStreamsConfig.getObjectFromREST(PushPublishStreamsConfig.getUrl(Severity.valueOf(5 - 16, "#>8+-\u0014:18"), string, PushPublishStreamsConfig.class), PushPublishStreamsConfig.class, wMSClientSecurity);
    }
}

