/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.sdpfiles;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.sdpfiles.SDPFileConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="SDPFiles")
@WMSDescription(text="VHost SDP Files", get="Retrieves the list of SDP Files for the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/sdpfiles", restVerbs="GET", xmlFilename="")
public class SDPFilesConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @XStreamOmitField
    protected Map pathMap;
    @JsonProperty(value="sdpFiles")
    @XStreamImplicit(itemFieldName="SDPFile")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public SDPFilesConfig() {
    }

    public SDPFilesConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Utils.substring("5,*53\u0006('.", 2 + 97), string);
        this.initUrl();
    }

    public List<ShortObject> getSdpFiles() {
        return this.a;
    }

    public void setSdpFiles(List<ShortObject> list) {
        this.a = list;
    }

    public void setPathMap() {
        String string = this.getStringVariable(Severity.valueOf(252 / 61, "rmit|Gkfi"));
        this.pathMap = new HashMap();
        this.pathMap.put(Severity.valueOf(45 * 41, "vyz6nulf|0h-2l ++2\"0=d\u001d\u0004\"=;"), string);
        this.pathMap.put(Severity.valueOf(1645 / 241, "ehe'}d{wo!g|a=wzxc}an5JUqltBmmblaOgdo"), VHostsConfig.getVHostDir(string));
        this.pathMap.put(Severity.valueOf(47 * 9, "dgd$|cztn>f\u007f`:vyyl|bo2\\no,(!\"0,))"), this.getStringVariable(Severity.valueOf(107 + 86, " 23\n$+\"")));
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(59 * 53, "apvioR|sz"));
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        String string = this.getStringVariable(Severity.valueOf(4 + 2, "pogz~Em`k"));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Severity.valueOf(1103 / 227, "+fii|ld\u007f");
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        String string = this.getBaseDir();
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(Utils.substring("}'1&", 19 * 33));
            }
        });
        if (stringArray == null) return true;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            String string3 = string2.substring(0, string2.length() - 4);
            this.a.add(new ShortObject(string3, this.restURI + "/" + string3));
            ++n2;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        SDPFileConfig sDPFileConfig = new SDPFileConfig();
        Representation representation2 = sDPFileConfig.post(representation, this.getRequest());
        this.setStatus(sDPFileConfig.getStatus());
        if (sDPFileConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(sDPFileConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static SDPFilesConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (SDPFilesConfig)SDPFilesConfig.getObjectFromREST(SDPFilesConfig.getUrl(Utils.substring("snh{}Djah", 1272 / 234), string, SDPFilesConfig.class), SDPFilesConfig.class, wMSClientSecurity);
    }
}

