/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.smilfiles;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.smilfiles.SMILFileConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="SMILFiles")
@WMSDescription(text="VHost SMIL Files", get="Retrieves the list of SMIL Files for the specified VHost", post="Adds a SMIL File to the list of SMIL Files for the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/smilfiles", restVerbs="GET,POST", xmlFilename="")
public class SMILFilesConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @XStreamOmitField
    protected Map pathMap;
    @JsonProperty(value="smilFiles")
    @XStreamImplicit(itemFieldName="SMILFile")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public SMILFilesConfig() {
    }

    public SMILFilesConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Utils.substring("snh{}Djah", 1240 / 242), string);
        this.initUrl();
    }

    public List<ShortObject> getSmileFiles() {
        return this.a;
    }

    public void setSmileFiles(List<ShortObject> list) {
        this.a = list;
    }

    public void setPathMap() {
        String string = this.getStringVariable(Utils.substring("%<:%#\u001687>", 37 - 50));
        this.pathMap = new HashMap();
        this.pathMap.put(Severity.valueOf(37 * 39, "`kh(pg~pj\"zc|>r}}`pnc6ORtoi"), string);
        this.pathMap.put(Severity.valueOf(96 + 67, "`kh(pg~pj\"zc|>r}}`pnc6ORtoi]p.'+$\f*+\""), VHostsConfig.getVHostDir(string));
        this.pathMap.put(Utils.substring("nab>f}dnt8`uj4xssjzxu,Btujnkh~bcc", 35 + -22), this.getStringVariable(Utils.substring("euvIido", 1178 / 245)));
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("i(.17\n$+\"", 81 + 110));
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        String string = this.getStringVariable(Severity.valueOf(43 * 41, "5,*53\u0006('."));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Severity.valueOf(5 * 25, "r=0nugmp");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        String string = this.getBaseDir();
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(Utils.substring("5opws", 29 * 23));
            }
        });
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                String string3 = string2.substring(0, string2.length() - 5);
                this.a.add(new ShortObject(string3, this.restURI + "/" + string3));
                ++n2;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        SMILFileConfig sMILFileConfig = new SMILFileConfig();
        Representation representation2 = sMILFileConfig.post(representation, this.getRequest());
        this.setStatus(sMILFileConfig.getStatus());
        if (sMILFileConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(sMILFileConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static SMILFilesConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (SMILFilesConfig)SMILFilesConfig.getObjectFromREST(SMILFilesConfig.getUrl(Utils.substring("#>8+-\u0014:18", -25 - -14), string, SMILFilesConfig.class), SMILFilesConfig.class, wMSClientSecurity);
    }
}

