/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.startupstreams;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.startupstreams.StartupStreamsConfig;
import java.util.HashMap;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StartupStream")
@WMSDescription(text="VHost Startup Stream", get="Retrieves the specified Startup Stream configuration", put="Updates the specified Startup Stream configuration", post="Adds the specified Startup Stream configuration", delete="Deletes the specified Startup Stream configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/startupstreams/applications/{appName}/instances/{instanceName}/streams/{streamName}", restVerbs="GET,DELETE,POST,PUT", xmlFilename="StartupStreams.xml")
public class StartupStreamConfig
extends ConfigBase
implements Comparable<StartupStreamConfig> {
    @XStreamOmitField
    public String vhostName;
    @JsonProperty(value="streamName")
    @XStreamAlias(value="StreamName")
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{instanceName}']/StreamName/text()")
    public String streamName;
    @JsonProperty(value="applicationName")
    @XStreamAlias(value="Application")
    public String applicationName;
    @JsonProperty(value="instance")
    @XStreamAlias(value="Instance")
    public String instanceName;
    @XStreamOmitField
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{instanceName}']/Application/text()")
    public String applicationInstance;
    @JsonProperty(value="mediaCasterType")
    @XStreamAlias(value="MediaCasterType")
    @WMSXMLVariable(xpath="/Root/StartupStreams/StartupStream[StreamName='{streamName}' and Application='{appName}/{instanceName}']/MediaCasterType/text()")
    public String mediaCasterType;

    public StartupStreamConfig() {
        String string = Utils.substring("b}ydlW{vy", 5 + 15);
        this.addFieldForKeyMap(string, string);
        this.addFieldForKeyMap(Severity.valueOf(39 - 44, ":,-\u0010>md"), "applicationName");
        String string2 = Utils.substring(".&:>*\".+\u00011<7", -5 - 52);
        this.addFieldForKeyMap(string2, string2);
        String string3 = Severity.valueOf(51 * 23, "fbe}xwU}p{");
        this.addFieldForKeyMap(string3, string3);
    }

    public StartupStreamConfig(String string, String string2, String string3, String string4) {
        this.vhostName = string;
        this.streamName = string4;
        this.addToStringKeyMap(Utils.substring("i(.17\n$+\"", 23 * 25), string);
        this.addToStringKeyMap(Utils.substring("btuHfel", 655 / 183), string2);
        this.addToStringKeyMap(Utils.substring("lht|hdhiCobu", 1146 / 197), string3);
        this.addToStringKeyMap(Utils.substring("t|{ojaCobu", 117 + -110), string4);
        this.initUrl();
        String string5 = Utils.substring("pogz~Em`k", 739 / 121);
        this.addFieldForKeyMap(string5, string5);
        String string6 = Severity.valueOf(-57 - -46, "&\"%=87\u0015=0;");
        this.addFieldForKeyMap(string6, string6);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("#>8+-\u0014:18", 25 * 61));
        this.addToStringKeyMapFromRequest(Severity.valueOf(45 * 35, "fxyDjah"));
        this.addToStringKeyMapFromRequest(Utils.substring("ec}{q\u007fqvZt{r", 3 + 9));
        this.addToStringKeyMapFromRequest(Utils.substring("714\")$\u0004*!(", -7 - 53));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public String getMediaCasterType() {
        return this.mediaCasterType;
    }

    public void setMediaCasterType(String string) {
        this.mediaCasterType = string;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.substring("2-)4<\u0007+&)", 82 + 114));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Severity.valueOf(621 / 185, ",gjha");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        boolean bl = super.loadXMLNode(node, string);
        if (!bl) return bl;
        if (this.applicationInstance == null) return bl;
        String[] stringArray = this.applicationInstance.split("/");
        if (stringArray.length > 1) {
            this.applicationName = stringArray[0];
            this.instanceName = stringArray[1];
        }
        this.addToStringKeyMap(Severity.valueOf(116 + -33, "2$%\u001865<"), this.applicationName);
        this.addToStringKeyMap(Severity.valueOf(47 + 4, "zzfbvvz\u007fU}p{"), this.instanceName);
        StartupStreamConfig startupStreamConfig = this;
        String string2 = startupStreamConfig.resolveVariables(startupStreamConfig.restURI, true);
        this.setRestURI(string2);
        return bl;
    }

    @Override
    protected boolean updateXML(Document document) {
        this.applicationInstance = this.applicationName + "/" + this.instanceName;
        return super.updateXML(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean exists() {
        boolean bl = false;
        bl = false;
        StartupStreamsConfig startupStreamsConfig = new StartupStreamsConfig(this.vhostName);
        bl = startupStreamsConfig.loadObject();
        if (!bl) return bl;
        bl = false;
        if (startupStreamsConfig.streams == null) return bl;
        return startupStreamsConfig.streams.contains(this);
    }

    @Override
    protected String getParentUrl(String string) {
        string = string.substring(0, string.lastIndexOf(Severity.valueOf(193 / 55, ",euvkajk\u007feb`|")));
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Utils.substring("DRKM:ZLT$?Ddnfplh`(Z~j~y{\u007f0Bfaqt{70", 93 + 57) + this.getStringVariable(Severity.valueOf(75 + 4, "<$#729\u001b7:=")) + Utils.substring("5'>V.a61%!#g;!%<l !+5\u007frs\u001a:\"w<<6>(408`\u00126\"6137h\u001a>9),#a", -6 - 62)));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(1691 / 250, "Bbdl~nh");
            return wMSResponse;
        }
        if (!this.removeNode(Utils.substring("d\u001e\"!;\u007f\u0002&2&!#'\u000b-(>=0-p\u00135#1006\u0014<;/*!\u0016\u001d;\"43>\u001a4;2e~!((/;>mOcnax!Z", 9 * 51))) {
            wMSResponse.message = Utils.substring("Cnwo`%hh|)nn`hzj0~pyqvb", -28 - -60);
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    public static StartupStreamConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(107 + -14, "+6035\f\") "), string);
        hashMap.put(Utils.substring("&\"%=87\u0015=0;", 51 * 55), string2);
        String string3 = StartupStreamConfig.getUrl(hashMap, StartupStreamConfig.class);
        return (StartupStreamConfig)StartupStreamConfig.getObjectFromREST(string3, StartupStreamConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(StartupStreamConfig startupStreamConfig) {
        return this.streamName.compareTo(startupStreamConfig.streamName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        if (object.getClass() == StartupStreamConfig.class) {
            boolean bl = this.streamName.equals(((StartupStreamConfig)object).streamName);
            bl &= this.applicationName.equals(((StartupStreamConfig)object).applicationName);
            return bl &= this.instanceName.equals(((StartupStreamConfig)object).instanceName);
        }
        if (object.getClass() != String.class) return false;
        return this.streamName.equals((String)object);
    }
}

