/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.startupstreams;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.startupstreams.StartupStreamConfig;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StartupStreams")
@WMSDescription(text="VHost Startup Streams", get="Retrieves the list of Startup Streams for the specified VHost", post="Adds a Startup Stream to the list of Startup Streams for the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/startupstreams", restVerbs="GET,POST", xmlFilename="StartupStreams.xml")
public class StartupStreamsConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="Streams")
    @XStreamAlias(value="Streams")
    protected List<StartupStreamConfig> streams;

    public StartupStreamsConfig() {
        String string = Severity.valueOf(-13 - -54, "\u007fbd\u007fy@n}t");
        this.addFieldForKeyMap(string, string);
    }

    public StartupStreamsConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Severity.valueOf(39 * 41, "i(.17\n$+\""), string);
        String string2 = Utils.substring("?\"$?9\u0000.=4", -42 - -19);
        this.addFieldForKeyMap(string2, string2);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("pogz~Em`k", 1144 / 189));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public List<StartupStreamConfig> getStreams() {
        return this.streams;
    }

    public void setStreams(List<StartupStreamConfig> list) {
        this.streams = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.substring("-42-+\u000e /&", 45 * 39));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Severity.valueOf(755 / 166, "+fiin");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadXMLNode(Node node, String string) {
        int n;
        NodeList nodeList;
        XPathExpression xPathExpression;
        String string2;
        XPath xPath;
        boolean bl = super.loadXMLNode(node, string);
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            xPath = xPathFactory.newXPath();
            string2 = Utils.substring(")Ugf~$_yo}ddb@`gsvuj5Hh|lkuqQwv`gj", 873 / 125);
            string2 = this.resolveVariables(string2);
            xPathExpression = xPath.compile(string2);
            nodeList = (NodeList)xPathExpression.evaluate(node, XPathConstants.NODESET);
            n = 0;
        }
        catch (XPathExpressionException xPathExpressionException) {
            ConfigBase.log.warn((Object)(Severity.valueOf(1532 / 250, "Vugkfna-b`qu{}s5NZT9|isp>yimg9$") + string), (Throwable)xPathExpressionException);
            return bl;
        }
        while (n < nodeList.getLength()) {
            String[] stringArray;
            String string3 = null;
            String string4 = null;
            Node node2 = nodeList.item(n);
            string2 = Utils.substring("WqtbidDjah!{uif;=", 267 / 54);
            xPathExpression = xPath.compile(string2);
            Node node3 = (Node)xPathExpression.evaluate(node2, XPathConstants.NODE);
            if (node3 != null) {
                string3 = node3.getNodeValue();
            }
            if ((node3 = (Node)(xPathExpression = xPath.compile(string2 = Severity.valueOf(38 - 61, "\b:; $-.$8=={!3/,qs"))).evaluate(node2, XPathConstants.NODE)) != null) {
                string4 = node3.getNodeValue();
            }
            if (string3 != null && string4 != null && (stringArray = string4.split("/")).length == 2) {
                StartupStreamConfig startupStreamConfig = new StartupStreamConfig(this.vhostName, stringArray[0], stringArray[1], string3);
                startupStreamConfig.loadXMLNode(node, string);
                StartupStreamsConfig startupStreamsConfig = this;
                startupStreamConfig.setRestURI(startupStreamsConfig.getServerFromUri(startupStreamsConfig.restURI) + startupStreamConfig.getRestURI());
                if (this.streams == null) {
                    this.streams = new ArrayList<StartupStreamConfig>();
                }
                this.streams.add(startupStreamConfig);
            }
            ++n;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        StartupStreamConfig startupStreamConfig = new StartupStreamConfig();
        Representation representation2 = startupStreamConfig.post(representation, this.getRequest());
        this.setStatus(startupStreamConfig.getStatus());
        if (startupStreamConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(startupStreamConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static StartupStreamsConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (StartupStreamsConfig)StartupStreamsConfig.getObjectFromREST(StartupStreamsConfig.getUrl(Severity.valueOf(-58 - -47, "#>8+-\u0014:18"), string, StartupStreamsConfig.class), StartupStreamsConfig.class, wMSClientSecurity);
    }
}

