/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.streamfiles;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.streammanager.HTTPStreamManager;
import com.wowza.wms.http.streammanager.NextLoadMessages;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSJSONVariable;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@JsonIgnoreProperties(ignoreUnknown=true)
@XStreamAlias(value="StreamFile")
@WMSDescription(text="VHost Stream File", get="Retrieves the specified Stream File configuration", put="Updates the specified Stream File configuration", post="Adds the specified Stream File configuration", delete="Deletes the specified Stream File configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/streamfiles/{streamfileName}", restVerbs="GET,DELETE,PUT,POST", xmlFilename="{streamfileName}.stream")
public class StreamFileConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @XStreamOmitField
    @WMSPathVariable(description="The stream file name without the extension")
    protected String streamfileName;
    @XStreamOmitField
    protected Map pathMap;
    @JsonProperty(value="uri")
    @XStreamAlias(value="URI")
    @WMSJSONVariable(name="uri")
    protected String uri;
    @XStreamOmitField
    protected TreeMap<String, Object> extraOptions;

    public StreamFileConfig() {
    }

    public StreamFileConfig(String string, String string2) {
        this.vhostName = string;
        this.streamfileName = string2;
        this.addToStringKeyMap(Severity.valueOf(12 + 91, "1 &9?\u0002,#*"), string);
        this.addToStringKeyMap(Utils.substring("ce`vuxp~t|Tzqx", 41 + 7), string2);
        this.initUrl();
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public Map getPathMap() {
        return this.pathMap;
    }

    public void setPathMap(Map map) {
        this.pathMap = map;
    }

    public String getStreamfileName() {
        return this.streamfileName;
    }

    public void setStreamfileName(String string) {
        this.streamfileName = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    @Override
    protected Field[] getDeclaredFields() {
        List<Field> list = Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields());
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Iterator<Field> iterator = list.iterator();
        while (iterator.hasNext()) {
            Field field = iterator.next();
            arrayList.add(field);
        }
        return (Field[])list.toArray();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("rmit|Gkfi", 160 / 37));
        this.addToStringKeyMapFromRequest(Severity.valueOf(242 / 44, "vrumhgmeakAq|w"));
    }

    public void setPathMap() {
        String string = this.getStringVariable(Severity.valueOf(-52 - -25, "3.(;=\u0004*!("));
        this.pathMap = new HashMap();
        this.pathMap.put(Utils.substring("p{x8`wn`z2jsln\"--0 >3f\u001f\u0002$?9", 15 * 29), string);
        this.pathMap.put(Utils.substring("wz{9ovma}3irs/aljqc\u007f|'\\Cc~zL\u007f\u007ftzs]yz}", 28 - 8), VHostsConfig.getVHostDir(string));
        this.pathMap.put(Severity.valueOf(123 + 99, "=0-o5,3?'i?$9e/\" ;5)&}\u0015%&;1:;/520"), this.getStringVariable(Utils.substring(". !\u001c290", 27 * 61)));
    }

    protected String getBaseDir() {
        String string = this.getStringVariable(Severity.valueOf(49 * 57, "?\"$?9\u0000.=4"));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Severity.valueOf(537 / 115, "+fii|ld\u007f#");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + this.getXMLFilename();
    }

    @Override
    protected boolean loadObjectFromFile(String string) {
        return this.loadJSON(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean loadJSON(String string) {
        boolean bl = false;
        this.vhostName = this.getStringVariable(Severity.valueOf(260 / 39, "pogz~Em`k"));
        this.streamfileName = this.getStringVariable(Severity.valueOf(849 / 206, "wqtbidlb`h@n}t"));
        this.extraOptions = new TreeMap();
        try {
            block5: {
                block4: {
                    this.loadExtraOptions(string);
                    if (this.extraOptions.containsKey(Utils.substring("d`z", 61 * 5))) break block4;
                    break block5;
                }
                this.uri = this.extraOptions.get(Severity.valueOf(893 / 206, "qwo")).toString();
                this.extraOptions.remove(Utils.substring("tpj", 15 + 114));
                return true;
            }
            if (!this.extraOptions.containsKey(Severity.valueOf(34 + 109, "zb}"))) return true;
            this.uri = this.extraOptions.get(Utils.substring("*2-", -11 - 22)).toString();
            this.extraOptions.remove(Utils.substring("d`\u007f", 61 * 5));
            return true;
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Severity.valueOf(11 * 47, "Uthjeof,aantx|t4s\u007f{}#:") + string), (Throwable)exception);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadExtraOptions(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) return;
            this.version = file.lastModified() + "";
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            dataInputStream.close();
            fileInputStream.close();
            if (string2 == null) return;
            if (!string2.trim().startsWith("{")) {
                this.extraOptions.put(Severity.valueOf(3 + 93, "53+"), string2.trim());
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.extraOptions = (TreeMap)objectMapper.readValue(new File(string), TreeMap.class);
            return;
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Severity.valueOf(38 + 83, "\t(4>1;2 mmb`lh`(lr\u007f~l.``e{|zf6qjvw;ztrz:!") + string), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected WMSResponse saveObjectToFile(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Severity.valueOf(17 * 33, "CW@@5WGQ#:H}kwq'a\u001a\u000e\ben") + string + Severity.valueOf(1442 / 245, ",<'Ag*\u007f~ljj0bz|c5{x||4;<Sqk bmnilrsagm+oeoawta=")));
            wMSResponse.success = true;
            wMSResponse.message = Utils.substring("Wdpbl", 574 / 134);
            return wMSResponse;
        }
        this.vhostName = this.getStringVariable(Utils.substring("+6035\f\") ", 17 * 13));
        this.streamfileName = this.getStringVariable(Utils.substring("ionx\u007fr&(.&\n$+\"", 73 + 113));
        this.extraOptions = new TreeMap();
        this.loadExtraOptions(string);
        this.extraOptions.remove(Severity.valueOf(873 / 173, "ptk"));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        try {
            Field[] fieldArray = this.getDeclaredFields();
            for (Field field : fieldArray) {
                WMSJSONVariable wMSJSONVariable = null;
                wMSJSONVariable = field.getAnnotation(WMSJSONVariable.class);
                if (wMSJSONVariable == null) continue;
                String string2 = field.getName();
                String string3 = wMSJSONVariable.name();
                if (string3.isEmpty()) {
                    string3 = string2;
                }
                if (this.saveFieldList != null && !this.saveFieldList.contains(string2)) continue;
                String string4 = (String)field.get((Object)this);
                if (string4 != null && !string4.isEmpty()) {
                    this.extraOptions.put(string3, string4);
                    continue;
                }
                this.extraOptions.remove(string3);
            }
            if (this.extraOptions.containsKey(Severity.valueOf(5 * 35, "zbx")) && this.extraOptions.size() == 1) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string), false));
                bufferedWriter.write(this.extraOptions.get(Utils.substring("04.", 57 * 13)).toString());
                bufferedWriter.close();
            } else {
                objectMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
                objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                objectMapper.writeValue(new File(string), this.extraOptions.descendingMap());
            }
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Severity.valueOf(74 + 28, "\u00165'+&.!m=.&8<4t!9w>06>f}") + string), (Throwable)exception);
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    public static StreamFileConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("c~xkmTzqx", 57 * 61), string);
        hashMap.put(Utils.substring("fbe}xw}uq{Qalg", 41 * 13), string2);
        return (StreamFileConfig)StreamFileConfig.getObjectFromREST(StreamFileConfig.getUrl(hashMap, StreamFileConfig.class), StreamFileConfig.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse copyAction(String string) {
        WMSResponse wMSResponse;
        block7: {
            wMSResponse = new WMSResponse();
            try {
                String string2 = URLDecoder.decode(string, Utils.substring("SSN$2", 1174 / 170));
                String string3 = this.getBaseDir();
                String string4 = string3 + this.streamfileName + Utils.substring("$xx\u007fkn}", 114 + -72);
                String string5 = string3 + string2 + Utils.substring("l007#&%", 126 + -28);
                File file = new File(string4);
                File file2 = new File(string5);
                if (file2.exists()) {
                    wMSResponse.message = Utils.substring("\u001625-('k\n$\"*p", 7 * 51) + string2 + Utils.substring("+ma|jquk3qm\u007fdlj", 49 + -6);
                    break block7;
                }
                if (!file.exists()) {
                    wMSResponse.message = Severity.valueOf(998 / 216, "Wqtbid*Meak/") + this.streamfileName + Severity.valueOf(-27 + 34, "'lfox,ca{0tjzga");
                } else {
                    StreamFileConfig.copyDirectory(file, file2);
                    wMSResponse.success = true;
                    wMSResponse.message = Utils.substring("\n.)9<3\u007f\u0006(.&dm", 96 + -7) + string2 + Utils.substring("/'k{ojxhj/cdqpqfeqmuvb", 1656 / 239);
                }
            }
            catch (SecurityException securityException) {
                wMSResponse.message = securityException.getMessage();
                ConfigBase.log.warn((Object)Severity.valueOf(108 + -31, "\b<=?#r0;%/>6>z\b(/;>-a\u0004*( "), (Throwable)securityException);
            }
            catch (IOException iOException) {
                wMSResponse.message = iOException.getMessage();
                ConfigBase.log.warn((Object)Utils.substring("@tug{*hc}wf~v2@`gsvu9\\rpx", 809 / 157), (Throwable)iOException);
            }
        }
        if (!wMSResponse.isSuccess()) {
            ConfigBase.log.error((Object)(Utils.substring("M\u0005\u0012\u0016c\u0005\u0015\u000f}h\n%;5m\u001d;\"43>t\u0013?;=cz", -6 - 59) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.info((Object)(Severity.valueOf(8 - 1, "UMZ^+M]G50R}cm5Ecj|{v<[wse;\"") + wMSResponse.message));
        return wMSResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse connectAction(String string) {
        WMSResponse wMSResponse;
        block11: {
            block12: {
                IApplication iApplication;
                IVHost iVHost;
                String string2;
                String string3;
                String string4;
                block13: {
                    Map<String, String> map;
                    wMSResponse = new WMSResponse();
                    wMSResponse.message = Severity.valueOf(-27 - 2, "\u0000%+a3h/#%(m/o'>%)5u%2*/?)r");
                    try {
                        this.setQueryParam(string);
                        map = this.getQueryParamMap();
                        string4 = map.get(Utils.substring("gjhimj~J|}@n}t", 752 / 156));
                        try {
                            string4 = URLDecoder.decode(string4, Severity.valueOf(11 * 29, "J\u0014\u0007o{"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            ConfigBase.logWarn(Utils.substring("\u000e2.+/pnpwaa&bfjeoeci/v~`3uefYyt\u007f!<", 84 + 39) + string4, unsupportedEncodingException);
                        }
                    }
                    catch (Exception exception) {
                        wMSResponse.message = exception.getMessage();
                        this.logException(Severity.valueOf(31 * 15, "2==:05#\u000b-(>=0\u00186,$\u0003 0,))"), exception);
                        break block11;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        wMSResponse.message = Utils.substring("Bcm#q&aagn+m-y`gks3gpda}k4", 45 * 37);
                        this.logException(Severity.valueOf(-37 - -36, "<oolfgqUszlkfJdbjQrfz{{"), classNotFoundException);
                        break block11;
                    }
                    string3 = map.get(Severity.valueOf(23 * 9, ". !\u001b='!79;<"));
                    try {
                        string3 = URLDecoder.decode(string3, Severity.valueOf(670 / 142, "QQ@*0"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        ConfigBase.logWarn(Utils.substring("\\dxy}~`beww4pxtw}su{=xpr!cstKgjm3*", 16 - 7) + string3, unsupportedEncodingException);
                    }
                    string2 = map.get(Utils.substring("naaofKhy\u007fi\u007fZv`t", 555 / 157));
                    Class.forName(Utils.substring("|/,l4+2<&f>'8b;& #%|\u001a\u0002\u001d9$,", 66 + 125));
                    iVHost = VHostSingleton.getInstance((String)this.vhostName);
                    if (iVHost == null) break block12;
                    iApplication = iVHost.getApplication(string4);
                    if (iApplication != null) break block13;
                    wMSResponse.message = Utils.substring("Gdh |)lbbi.n`a~zwtb~ww ;", 875 / 194) + string4;
                    break block11;
                }
                IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string3);
                if (iApplicationInstance == null) {
                    wMSResponse.message = Utils.substring("Tyw=o<{wqd!cstiodi}cdb-gaces}wp,7", 44 + 107) + string3;
                    break block11;
                } else {
                    NextLoadMessages nextLoadMessages = HTTPStreamManager.connectStream((IVHost)iVHost, (String)string4, (String)string3, (String)(this.streamfileName + Utils.substring("?agfpwz", 29 * 5)), (String)string2);
                    if (nextLoadMessages.getErrorMsg() != null) {
                        wMSResponse.message = nextLoadMessages.getErrorMsg();
                        StreamFileConfig.logError(Severity.valueOf(31 * 55, "Jeebhm{0Bfaqt{-8") + wMSResponse.message);
                        break block11;
                    } else {
                        wMSResponse.message = nextLoadMessages.getInfoMsg();
                        wMSResponse.success = true;
                        StreamFileConfig.logInfo(Utils.substring("Ppwcfe)Lb`h.l\u007f\u007f|vwass\"9", 460 / 122) + this.streamfileName + Utils.substring(" |dcwry", 8 + 38));
                    }
                }
                break block11;
            }
            wMSResponse.message = Severity.valueOf(41 * 45, "Vwy?m:}usz?6)-00\u007ff") + this.vhostName;
        }
        if (wMSResponse.isSuccess()) return wMSResponse;
        StreamFileConfig.logError(Severity.valueOf(17 * 21, "\u0006))&,)?l\u001e:=50?s2<:2by") + wMSResponse.message);
        return wMSResponse;
    }
}

