/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.streamfiles;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.AdvancedSetting;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.ConfigBaseAdv;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSJSONVariable;
import com.wowza.wms.rest.WMSPathVariable;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLAdvSetting;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="StreamFileAdv")
@WMSDescription(text="VHost Advanced Stream File", get="Retrieves the Advanced Stream File configuration", put="Updates the Advanced Stream File configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/streamfiles/{streamfileName}/adv", restVerbs="GET,PUT", xmlFilename="{streamfileName}.stream")
public class StreamFileConfigAdv
extends ConfigBaseAdv {
    @XStreamOmitField
    protected String vhostName;
    @XStreamOmitField
    @WMSPathVariable(description="The stream file name without the .stream extension")
    protected String streamfileName;
    @XStreamOmitField
    protected Map pathMap;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="Common", name="uri")
    @WMSJSONVariable(name="uri")
    protected String uri;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="Common", name="streamTimeout", hasDefault=true, defaultInt=12000)
    @WMSJSONVariable(name="streamTimeout")
    protected int streamTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="Common", name="reconnectWaitTime", hasDefault=true, defaultInt=3000)
    @WMSJSONVariable(name="reconnectWaitTime")
    protected int reconnectWaitTime;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsAudioPID", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="mpegtsAudioPID")
    protected String mpegtsAudioPID;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsVideoPID", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="mpegtsVideoPID")
    protected String mpegtsVideoPID;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsProgramID", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="mpegtsProgramID")
    protected String mpegtsProgramID;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsAudioLanguage", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="mpegtsAudioLanguage")
    protected String mpegtsAudioLanguage;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsAudioBitrate", hasDefault=false)
    @WMSJSONVariable(name="mpegtsAudioBitrate")
    protected long mpegtsAudioBitrate;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsVideoBitrate", hasDefault=false)
    @WMSJSONVariable(name="mpegtsVideoBitrate")
    protected long mpegtsVideoBitrate;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsAudioIsAligned", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsAudioIsAligned")
    protected boolean mpegtsAudioIsAligned;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsVideoIsAligned", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsVideoIsAligned")
    protected boolean mpegtsVideoIsAligned;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsAdjustBFrameTimecodes", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsAdjustBFrameTimecodes")
    protected boolean mpegtsAdjustBFrameTimecodes;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsDropIncompleteVideoFrames", hasDefault=true, defaultBoolean=true)
    @WMSJSONVariable(name="mpegtsDropIncompleteVideoFrames")
    protected boolean mpegtsDropIncompleteVideoFrames;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsLogIncompleteVideoFrames", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsLogIncompleteVideoFrames")
    protected boolean mpegtsLogIncompleteVideoFrames;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsMapTimeToSystemTime", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsMapTimeToSystemTime")
    protected boolean mpegtsMapTimeToSystemTime;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsMapTimeToSystemTimeWindow", hasDefault=true, defaultLong=2000L)
    @WMSJSONVariable(name="mpegtsMapTimeToSystemTimeWindow")
    protected long mpegtsMapTimeToSystemTimeWindow;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="MPEG-TS", name="mpegtsImportAC3", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="mpegtsImportAC3")
    protected boolean mpegtsImportAC3;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtpTransportMode", hasDefault=true, defaultString="udp")
    @WMSJSONVariable(name="rtpTransportMode")
    protected String rtpTransportMode;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspValidationFrequency", hasDefault=true, defaultLong=15000L)
    @WMSJSONVariable(name="rtspValidationFrequency")
    protected long rtspValidationFrequency;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspFilterUnknownTracks", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="rtspFilterUnknownTracks")
    protected boolean rtspFilterUnknownTracks;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspStreamAudioTrack", hasDefault=true, defaultBoolean=true)
    @WMSJSONVariable(name="rtspStreamAudioTrack")
    protected boolean rtspStreamAudioTrack;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspStreamVideoTrack", hasDefault=true, defaultBoolean=true)
    @WMSJSONVariable(name="rtspStreamVideoTrack")
    protected boolean rtspStreamVideoTrack;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtpDebugSession", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="rtpDebugSession")
    protected boolean rtpDebugSession;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtpIgnoreProfileLevelId", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="rtpIgnoreProfileLevelId")
    protected boolean rtpIgnoreProfileLevelId;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtpIgnoreSPropParameterSets", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="rtpIgnoreSPropParameterSets")
    protected boolean rtpIgnoreSPropParameterSets;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspBindIpAddress", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="rtspBindIpAddress")
    protected String rtspBindIpAddress;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspRemoveUserInfo", hasDefault=true, defaultBoolean=true)
    @WMSJSONVariable(name="rtspRemoveUserInfo")
    protected boolean rtspRemoveUserInfo;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspSessionTimeout", hasDefault=true, defaultInt=8000)
    @WMSJSONVariable(name="rtspSessionTimeout")
    protected int rtspSessionTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="RTSP", name="rtspConnectionTimeout", hasDefault=true, defaultInt=8000)
    @WMSJSONVariable(name="rtspConnectionTimeout")
    protected int rtspConnectionTimeout;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="LiveStreamRepeater", name="lsrSecureTokenOriginSharedSecret", hasDefault=true, defaultString="")
    @WMSJSONVariable(name="lsrSecureTokenOriginSharedSecret")
    protected String lsrSecureTokenOriginSharedSecret;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="LiveStreamRepeater", name="lsrCallFCSubscribe", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="lsrCallFCSubscribe")
    protected boolean lsrCallFCSubscribe;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="LiveStreamRepeater", name="lsrRemoveDefaultAppInstance", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="lsrRemoveDefaultAppInstance")
    protected boolean lsrRemoveDefaultAppInstance;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="LiveStreamRepeater", name="lsrResetOnStreamNotFound", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="lsrResetOnStreamNotFound")
    protected boolean lsrResetOnStreamNotFound;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="SHOUTcast-Icecast", name="shoutcastCharacterEncoding", hasDefault=true, defaultString="8859_1")
    @WMSJSONVariable(name="shoutcastCharacterEncoding")
    protected String shoutcastCharacterEncoding;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="SHOUTcast-Icecast", name="shoutcastMP3GroupCount", hasDefault=true, defaultInt=1)
    @WMSJSONVariable(name="shoutcastMP3GroupCount")
    protected int shoutcastMP3GroupCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="SHOUTcast-Icecast", name="shoutcastAACGroupCount", hasDefault=true, defaultInt=1)
    @WMSJSONVariable(name="shoutcastAACGroupCount")
    protected int shoutcastAACGroupCount;
    @XStreamOmitField
    @WMSXMLAdvSetting(sectionName="SHOUTcast-Icecast", name="shoutcastSetTimecodesBasedOnSystemClock", hasDefault=true, defaultBoolean=false)
    @WMSJSONVariable(name="shoutcastSetTimecodesBasedOnSystemClock")
    protected boolean shoutcastSetTimecodesBasedOnSystemClock;
    @XStreamOmitField
    protected TreeMap<String, Object> extraOptions;

    public StreamFileConfigAdv() {
        this.initUrl();
    }

    public StreamFileConfigAdv(String string, String string2) {
        this.vhostName = string;
        this.streamfileName = string2;
        this.addToStringKeyMap(Severity.valueOf(63 - 15, "fy}``[wz}"), string);
        this.addToStringKeyMap(Utils.substring("714\")$,\" (\u0000.=4", -65 - -5), string2);
        this.initUrl();
    }

    @Override
    protected void subConstructor(boolean bl) {
        super.subConstructor(bl);
        this.pathsForUndocumentedProperties = new ArrayList<String>();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Utils.substring("4++62\t)$/", -60 - -30));
        this.addToStringKeyMapFromRequest(Utils.substring("vrumhgmeakAq|w", 35 * 23));
    }

    public void setPathMap() {
        String string = this.getStringVariable(Severity.valueOf(17 - 43, "0/':>\u0005- +"));
        this.pathMap = new HashMap();
        this.pathMap.put(Utils.substring("jef\"zaxjp<dyf8twwn~di0I\b.17", 17 * 25), string);
        this.pathMap.put(Utils.substring("cno-sjq}i'}f\u007f#m`~ewk`;@_wjnXssxv'\t-.!", 29 + 3), VHostsConfig.getVHostDir(string));
        this.pathMap.put(Utils.substring("!,)k1(?3+e; =a3><'1-\"y\u0019)*75>?+inl", -47 - -17), this.getStringVariable(Utils.substring("6()\u0014:18", 3 * 29)));
    }

    protected String getBaseDir() {
        String string = this.getStringVariable(Utils.substring("uljusFhgn", 573 / 150));
        String string2 = VHostsConfig.getVHostDir(string);
        return string2 + Severity.valueOf(19 * 45, "x;64/93*p");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + this.getXMLFilename();
    }

    @Override
    protected boolean loadObjectFromFile(String string) {
        return this.loadJSON(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean loadJSON(String string) {
        int n;
        int n2;
        Object object;
        boolean bl = false;
        this.vhostName = this.getStringVariable(Severity.valueOf(73 + 14, "!06)/\u0012<3:"));
        this.streamfileName = this.getStringVariable(Severity.valueOf(36 + 109, "bfaqt{qqu\u007fU}p{"));
        this.extraOptions = new TreeMap();
        try {
            Field[] fieldArray;
            this.a(string);
            object = fieldArray = this.getDeclaredFields();
            n2 = ((Field[])object).length;
            n = 0;
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Utils.substring("\u0007*68790~3o`fjjb&azfg+jdbj*1", 57 * 47) + string), (Throwable)exception);
            return bl;
        }
        while (true) {
            block16: {
                String string2;
                block17: {
                    block15: {
                        if (n >= n2) break block15;
                        Field field = object[n];
                        WMSJSONVariable wMSJSONVariable = null;
                        wMSJSONVariable = field.getAnnotation(WMSJSONVariable.class);
                        if (wMSJSONVariable == null) break block16;
                        String string3 = wMSJSONVariable.name();
                        string2 = field.getName();
                        if (string3.isEmpty()) {
                            string3 = string2;
                        }
                        if (!this.extraOptions.containsKey(string3)) break block17;
                        String string4 = this.extraOptions.get(string3).toString();
                        if (field.getType() == Integer.TYPE) {
                            field.setInt((Object)this, Integer.parseInt(string4));
                        } else if (field.getType() == Long.TYPE) {
                            field.setLong((Object)this, Long.parseLong(string4));
                        } else if (field.getType() == String.class) {
                            field.set((Object)this, string4);
                        } else if (field.getType() == Boolean.TYPE) {
                            field.setBoolean((Object)this, Boolean.parseBoolean(string4));
                        }
                        this.extraOptions.remove(string3);
                        break block16;
                    }
                    if (this.extraOptions.containsKey(Utils.substring("bju", 27 - -28))) {
                        this.uri = this.extraOptions.get(Utils.substring(")/2", -20 - 16)).toString();
                        this.extraOptions.remove(Severity.valueOf(127 + -108, "ffy"));
                    }
                    if (this.extraOptions.containsKey(Utils.substring("yxdk\u007fobYU", 9 + 32))) {
                        this.mpegtsProgramID = object = this.extraOptions.get(Utils.substring("edx\u007fk{vUY", 45 * 9)).toString();
                        this.extraOptions.remove(Utils.substring("7:&-9- \u0007\u000b", 21 * 11));
                    }
                    if (this.extraOptions.containsKey(Severity.valueOf(672 / 125, "socmfZBH"))) {
                        this.mpegtsVideoPID = object = this.extraOptions.get(Severity.valueOf(53 * 49, "socmfZBH")).toString();
                        this.extraOptions.remove(Utils.substring("rlbbgYCO", 331 / 71));
                    }
                    if (this.extraOptions.containsKey(Utils.substring("neu{|D\\R", 47 * 33))) {
                        this.mpegtsAudioPID = object = this.extraOptions.get(Utils.substring("|k{inRJ@", 37 * 25)).toString();
                        this.extraOptions.remove(Severity.valueOf(45 * 57, "dscafZBH"));
                    }
                    if (!this.extraOptions.containsKey(Utils.substring("bqaohDhdlylij", 947 / 240))) return true;
                    this.mpegtsAudioLanguage = object = this.extraOptions.get(Utils.substring("bqaohDhdlylij", 37 * 7)).toString();
                    this.extraOptions.remove(Severity.valueOf(513 / 92, "dscafFjbj{nwt"));
                    return true;
                }
                this.missingVariables.add(string2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void a(String string) {
        try {
            File file = new File(string);
            if (!file.exists()) return;
            this.version = file.lastModified() + "";
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            dataInputStream.close();
            fileInputStream.close();
            if (string2 == null) return;
            if (!string2.trim().startsWith("{")) {
                this.extraOptions.put(Utils.substring(",(2", 15 * 23), string2.trim());
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.extraOptions = (TreeMap)objectMapper.readValue(new File(string), TreeMap.class);
            return;
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Utils.substring("\u001f\">0?18v;78>22:~:850\"d*63!&$8l+< =q4:80lw", -53 - -4) + string), (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected WMSResponse saveObjectToFile(String string) {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Utils.substring("V@US(HZB6-]nfx|t4M[[81", 490 / 108) + string + Severity.valueOf(1121 / 188, ",<'Ag*\u007f~ljj0bz|c5{x||4;<Sqk bmnilrsagm+oeoawta=")));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(951 / 136, "Uf~ln");
            return wMSResponse;
        }
        this.vhostName = this.getStringVariable(Severity.valueOf(399 / 82, "rmit|Gkfi"));
        this.streamfileName = this.getStringVariable(Utils.substring("<$#7293?;=\u0017;69", -59 - -42));
        this.extraOptions = new TreeMap();
        this.a(string);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        try {
            Object object = this.advancedSettingsList.iterator();
            while (true) {
                AdvancedSetting advancedSetting;
                if (object.hasNext()) {
                    advancedSetting = object.next();
                    if (!advancedSetting.documented) continue;
                } else {
                    if (!this.extraOptions.containsKey(Severity.valueOf(-48 - -29, "8<&")) || this.extraOptions.size() != 1) {
                        objectMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
                        objectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
                        objectMapper.writeValue(new File(string), this.extraOptions.descendingMap());
                    } else {
                        object = new BufferedWriter(new FileWriter(new File(string), false));
                        ((Writer)object).write(this.extraOptions.get(Utils.substring("'!=", 62 - -52)).toString());
                        ((BufferedWriter)object).close();
                    }
                    break;
                }
                if (advancedSetting.enabled) {
                    this.extraOptions.put(advancedSetting.name, advancedSetting.value);
                    continue;
                }
                this.extraOptions.remove(advancedSetting.name);
            }
        }
        catch (Exception exception) {
            ConfigBase.log.warn((Object)(Utils.substring("Knr|s%,b0%3/)/i>$l+'#5kr", 43 * 49) + string), (Throwable)exception);
        }
        wMSResponse.success = true;
        return wMSResponse;
    }

    @Override
    public void initAdvancedSettings(boolean bl) {
        super.initAdvancedSettings(bl);
    }

    public static StreamFileConfigAdv getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(-4 - 7, "#>8+-\u0014:18"), string);
        hashMap.put(Severity.valueOf(-41 - 43, "\u007fy|jq|tzxpXvu|"), string2);
        return (StreamFileConfigAdv)StreamFileConfigAdv.getObjectFromREST(StreamFileConfigAdv.getUrl(hashMap, StreamFileConfigAdv.class), StreamFileConfigAdv.class, wMSClientSecurity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamFileConfigAdv getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(1010 / 146, "pogz~Em`k"), string);
        hashMap.put(Utils.substring("4<;/*!+'#5\u001f3>1", 78 + -7), string2);
        String string4 = StreamFileConfigAdv.getUrl(hashMap, StreamFileConfigAdv.class);
        if (string3 == null) return (StreamFileConfigAdv)StreamFileConfigAdv.getObjectFromREST(string4, StreamFileConfigAdv.class, wMSClientSecurity);
        if (string3.isEmpty()) return (StreamFileConfigAdv)StreamFileConfigAdv.getObjectFromREST(string4, StreamFileConfigAdv.class, wMSClientSecurity);
        string4 = string4 + "?" + string3;
        return (StreamFileConfigAdv)StreamFileConfigAdv.getObjectFromREST(string4, StreamFileConfigAdv.class, wMSClientSecurity);
    }
}

