/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplatesConfig;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="Transcoder")
@WMSDescription(text="VHost Transcoder", get="Retrieves the Transcoder configuration for the specified VHost", put="Updates the Transcoder configuration for the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder", restVerbs="GET,PUT", xmlFilename="")
public class TranscoderConfig
extends com.wowza.wms.rest.transcoder.TranscoderConfig {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="templates")
    @XStreamAlias(value="Templates")
    protected TranscoderTemplatesConfig templates;

    public TranscoderConfig() {
        String string = Severity.valueOf(29 * 29, "?\"$?9\u0000.=4");
        this.addFieldForKeyMap(string, string);
    }

    public TranscoderConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Severity.valueOf(13 * 49, "+60suLbi`"), string);
        String string2 = Severity.valueOf(11 - 50, "/24/)\u0010>-$");
        this.addFieldForKeyMap(string2, string2);
        this.initUrl();
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public TranscoderTemplatesConfig getTemplates() {
        return this.templates;
    }

    public void setTemplates(TranscoderTemplatesConfig transcoderTemplatesConfig) {
        this.templates = transcoderTemplatesConfig;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(53 * 23, "5,*53\u0006('."));
    }

    @Override
    public boolean exists() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean loadObject() {
        super.loadObject();
        if (this.templates != null) {
            return true;
        }
        this.templates = new TranscoderTemplatesConfig(this.vhostName);
        WMSConfig wMSConfig = TranscoderTemplatesConfig.class.getAnnotation(WMSConfig.class);
        TranscoderConfig transcoderConfig = this;
        String string = transcoderConfig.getServerFromUri(transcoderConfig.restURI) + wMSConfig.restLocation();
        string = this.resolveVariables(string);
        this.templates.setRestURI(string);
        this.templates.loadObject();
        return true;
    }

    public static TranscoderConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (TranscoderConfig)TranscoderConfig.getObjectFromREST(TranscoderConfig.getUrl(Utils.substring("}db}{^p\u007fv", 19 * 9), string, TranscoderConfig.class), TranscoderConfig.class, wMSClientSecurity);
    }
}

