/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderOverlayEncodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderEncode")
@WMSDescription(text="VHost Trancoder Encode", get="Retrieves the specified Trancoder Encode configuration", put="Updates the specified Trancoder Encode configuration", post="Adds the specified Trancoder Encode configuration", delete="Deletes the specified Trancoder Encode configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates/{templateName}/encodes/{encodeName}", restVerbs="GET,POST,PUT,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderEncodeConfig
extends ConfigBase
implements Comparable<TranscoderEncodeConfig> {
    @XStreamOmitField
    public String vhostName;
    @XStreamOmitField
    public String templateName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Name/text()")
    public String encodeName;
    @JsonProperty(value="enable")
    @XStreamAlias(value="Enable")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Enable/text()")
    public boolean enable;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Description/text()")
    public String description;
    @JsonProperty(value="streamName")
    @XStreamAlias(value="StreamName")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/StreamName/text()")
    public String streamName;
    @JsonProperty(value="videoCodec")
    @XStreamAlias(value="VideoCodec")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/Codec/text()")
    public String videoCodec;
    @JsonProperty(value="implementation")
    @XStreamAlias(value="Implementation")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/Implementation/text()")
    public String implementation;
    @JsonProperty(value="gpuid")
    @XStreamAlias(value="GPUID")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/GPUID/text()")
    public int GPUID;
    @JsonProperty(value="profile")
    @XStreamAlias(value="Profile")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/Profile/text()")
    public String profile;
    @JsonProperty(value="videoBitrate")
    @XStreamAlias(value="VideoBitrate")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/Bitrate/text()")
    public String videoBitrate;
    @JsonProperty(value="followSource")
    @XStreamAlias(value="FollowSource")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/KeyFrameInterval/FollowSource/text()")
    public boolean followSource;
    @JsonProperty(value="interval")
    @XStreamAlias(value="Interval")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/KeyFrameInterval/Interval/text()")
    public int interval;
    @JsonProperty(value="fitMode")
    @XStreamAlias(value="FitMode")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/FrameSize/FitMode/text()")
    public String fitMode;
    @JsonProperty(value="width")
    @XStreamAlias(value="Width")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/FrameSize/Width/text()")
    public int width;
    @JsonProperty(value="height")
    @XStreamAlias(value="Height")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/FrameSize/Height/text()")
    public int height;
    @JsonProperty(value="crop")
    @XStreamAlias(value="Crop")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/FrameSize/Crop/text()")
    public String crop;
    @JsonProperty(value="sourceRectangle")
    @XStreamAlias(value="SourceRectangle")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/FrameSize/SourceRectangle/text()")
    public String sourceRectangle;
    @JsonProperty(value="audioCodec")
    @XStreamAlias(value="AudioCodec")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Audio/Codec/text()")
    public String audioCodec;
    @JsonProperty(value="audioBitrate")
    @XStreamAlias(value="AudioBitrate")
    @WMSXMLVariable(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Audio/Bitrate/text()")
    public String audioBitrate;
    @JsonProperty(value="Overlays")
    @XStreamAlias(value="Overlays")
    @WMSXMLList(xpath="/Root/Transcode/Encodes/Encode[Name='{encodeName}']/Video/Overlays", keyxpath="/Overlay/Name", keyName="overlayName")
    protected List<TranscoderOverlayEncodeConfig> encodeOverlays;

    public TranscoderEncodeConfig() {
        String string = Severity.valueOf(36 + 114, "`\u007fwjnU}p{");
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(15 * 5, "?) >#1%7\u001d583");
        this.addFieldForKeyMap(string2, string2);
        String string3 = Severity.valueOf(-14 - -7, "<4839;\u0011alg");
        this.addFieldForKeyMap(string3, string3);
    }

    public TranscoderEncodeConfig(String string, String string2, String string3) {
        this.vhostName = string;
        this.templateName = string2;
        this.encodeName = string3;
        this.addToStringKeyMap(Utils.substring("uljusFhgn", 728 / 232), string);
        this.addToStringKeyMap(Severity.valueOf(101 + -71, "jzmqnbp`Hfel"), string2);
        this.addToStringKeyMap(Severity.valueOf(-44 - 25, "~r~q{%\u000f#.!"), string3);
        this.initUrl();
        String string4 = Utils.substring("e|zecVxw~", 63 * 13);
        this.addFieldForKeyMap(string4, string4);
        String string5 = Severity.valueOf(-33 - -27, ".>1-2>tdLbi`");
        this.addFieldForKeyMap(string5, string5);
        String string6 = Severity.valueOf(84 + -40, "icm`tt\\ryp");
        this.addFieldForKeyMap(string6, string6);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(758 / 113, "pogz~Em`k"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(27 * 53, "c}tjw}i{Qalg"));
        this.addToStringKeyMapFromRequest(Utils.substring("+!3>66\u001a4;2", 32 - 50));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String getEncodeName() {
        return this.encodeName;
    }

    public void setEncodeName(String string) {
        this.encodeName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String string) {
        this.videoCodec = string;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String string) {
        this.implementation = string;
    }

    public int getGPUID() {
        return this.GPUID;
    }

    public void setGPUID(int n) {
        this.GPUID = n;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String string) {
        this.profile = string;
    }

    public String getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(String string) {
        this.videoBitrate = string;
    }

    public boolean isFollowSource() {
        return this.followSource;
    }

    public void setFollowSource(boolean bl) {
        this.followSource = bl;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public String getFitMode() {
        return this.fitMode;
    }

    public void setFitMode(String string) {
        this.fitMode = string;
    }

    public String getCrop() {
        return this.crop;
    }

    public void setCrop(String string) {
        this.crop = string;
    }

    public String getSourceRectangle() {
        return this.sourceRectangle;
    }

    public void setSourceRectangle(String string) {
        this.sourceRectangle = string;
    }

    public String getAudioCodec() {
        return this.audioCodec;
    }

    public void setAudioCodec(String string) {
        this.audioCodec = string;
    }

    public String getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(String string) {
        this.audioBitrate = string;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public List<TranscoderOverlayEncodeConfig> getEncodeOverlays() {
        return this.encodeOverlays;
    }

    public void setEncodeOverlays(List<TranscoderOverlayEncodeConfig> list) {
        this.encodeOverlays = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        TranscoderEncodeConfig transcoderEncodeConfig;
        Object object;
        Object object2;
        boolean bl = false;
        try {
            object2 = this.getFilename();
            object = new File((String)object2);
            bl = ((File)object).exists();
        }
        catch (Exception exception) {}
        if (!bl) return bl;
        bl = false;
        TranscoderEncodeConfig transcoderEncodeConfig2 = this;
        object2 = transcoderEncodeConfig2.getNewTemplate(transcoderEncodeConfig2.templateName);
        if (!((TranscoderTemplateConfig)object2).loadObject()) return bl;
        object = ((TranscoderTemplateConfig)object2).getEncodes().iterator();
        do {
            if (!object.hasNext()) return bl;
            transcoderEncodeConfig = (TranscoderEncodeConfig)object.next();
        } while (!transcoderEncodeConfig.encodeName.equals(this.encodeName));
        return true;
    }

    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateConfig(this.vhostName, string);
    }

    public static TranscoderEncodeConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(1 + 15, "fy}``[wz}"), string);
        hashMap.put(Utils.substring("k%,2/%1#\t)$/", 28 + 35), string2);
        hashMap.put(Severity.valueOf(1160 / 222, "`hdgmoEm`k"), string3);
        String string4 = TranscoderEncodeConfig.getUrl(hashMap, TranscoderEncodeConfig.class);
        return (TranscoderEncodeConfig)TranscoderEncodeConfig.getObjectFromREST(string4, TranscoderEncodeConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(TranscoderEncodeConfig transcoderEncodeConfig) {
        return this.encodeName.compareTo(transcoderEncodeConfig.encodeName);
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Severity.valueOf(195 / 51, "uljusFhgn"));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Utils.substring(":beywixsy{m/ugntigsmz", 112 + -91);
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    @Override
    public boolean loadObject() {
        return super.loadObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Utils.substring("TB[]*J\\D4/Tt~v`|xp8Mhzrn}pddp#Akehll*#", 1490 / 216) + this.getStringVariable(Severity.valueOf(1341 / 212, "cikfnnBlcj")) + Utils.substring("/=(@d+x\u007foku1a{{b6zw}\u007f5<=Ppt!ffh`rnfn*Nbnaku?", 248 / 41)));
            wMSResponse.success = true;
            wMSResponse.message = Severity.valueOf(43 * 23, "\u0019;3%5''");
            return wMSResponse;
        }
        if (this.removeNode(Utils.substring(":Dxwm5On|plcnff+@hdgmox#H`l\u007fuwHZt{r%>a~r~q{%\u000f#.!8a\u001a", 43 - 22))) {
            wMSResponse.success = true;
            return wMSResponse;
        }
        wMSResponse.message = Severity.valueOf(155 / 44, "@kpjc(ge\u007f,ikcuew3{w|r{m");
        return wMSResponse;
    }
}

