/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderEncodes")
@WMSDescription(text="VHost Transcoder Encodes", get="Retrieves the list of Transcoder Encode Configurations for the specified VHost", post="Adds a Transcoder Encode Configuration to the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates/{templateName}/encodes", restVerbs="GET,POST", xmlFilename="{templateName}.xml")
public class TranscoderEncodesConfig
extends ConfigBase {
    @XStreamOmitField
    public String vhostName;
    @XStreamOmitField
    public String templateName;
    @JsonProperty(value="encodes")
    @XStreamImplicit(itemFieldName="Encode")
    protected List<ShortObject> encodes = new ArrayList<ShortObject>();

    public TranscoderEncodesConfig() {
        String string = Utils.substring("#>8+-\u0014:18", 3 * 39);
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(39 * 3, "!3:(5;/9\u0013?2e");
        this.addFieldForKeyMap(string2, string2);
    }

    public TranscoderEncodesConfig(String string, String string2) {
        this.vhostName = string;
        this.templateName = string2;
        this.addToStringKeyMap(Utils.substring("pogz~Em`k", 54 + 112), string);
        this.addToStringKeyMap(Severity.valueOf(107 + -56, "gqxf{ym\u007fU}p{"), string2);
        this.initUrl();
        String string3 = Utils.substring("nquhhS\u007fre", 70 + -46);
        this.addFieldForKeyMap(string3, string3);
        String string4 = Utils.substring("qcjxek\u007fiCobu", 45 - 8);
        this.addFieldForKeyMap(string4, string4);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(469 / 132, "uljusFhgn"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(703 / 159, "p`kwdh~nBlcj"));
        String string = Utils.substring("4++62\t)$/", 4 - 34);
        this.addFieldForKeyMap(string, string);
        String string2 = Utils.substring("+%,2/%1#\t)$/", 17 + 78);
        this.addFieldForKeyMap(string2, string2);
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public List<ShortObject> getEncodes() {
        return this.encodes;
    }

    public void setEncodes(List<ShortObject> list) {
        this.encodes = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean loadObject() {
        TranscoderTemplateConfig transcoderTemplateConfig = new TranscoderTemplateConfig(this.vhostName, this.templateName);
        transcoderTemplateConfig.loadObject();
        this.encodes.clear();
        Iterator<TranscoderEncodeConfig> iterator = transcoderTemplateConfig.getEncodes().iterator();
        while (iterator.hasNext()) {
            TranscoderEncodeConfig transcoderEncodeConfig = iterator.next();
            this.encodes.add(new ShortObject(transcoderEncodeConfig.encodeName, this.restURI + "/" + transcoderEncodeConfig.encodeName));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        TranscoderEncodeConfig transcoderEncodeConfig = new TranscoderEncodeConfig();
        Representation representation2 = transcoderEncodeConfig.post(representation, this.getRequest());
        this.setStatus(transcoderEncodeConfig.getStatus());
        if (transcoderEncodeConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(transcoderEncodeConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static TranscoderEncodesConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Utils.substring("xg\u007fbf]uxs", -64 - 18), string);
        hashMap.put(Utils.substring("0 +7$(>.\u0002,#*", -15 - 13), string2);
        return (TranscoderEncodesConfig)TranscoderEncodesConfig.getObjectFromREST(TranscoderEncodesConfig.getUrl(hashMap, TranscoderEncodesConfig.class), TranscoderEncodesConfig.class, wMSClientSecurity);
    }
}

