/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderMemberConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderStreamNameGroup")
@WMSDescription(text="VHost Trancoder Stream Name Group", get="Retrieves the specified Trancoder StreamNameGroup configuration", put="Updates the specified Trancoder StreamNameGroup configuration", post="Adds the specified Trancoder StreamNameGroup configuration", delete="Deletes the specified Trancoder StreamNameGroup configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates/{templateName}/streamnamegroups/{groupName}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderStreamNameGroupConfig
extends ConfigBase
implements Comparable<TranscoderStreamNameGroupConfig> {
    @XStreamOmitField
    public String vhostName;
    @XStreamOmitField
    public String templateName;
    @XStreamOmitField
    protected boolean removed;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    @WMSXMLVariable(xpath="/Root/Transcode/StreamNameGroups/StreamNameGroup[Name='{groupName}']/Name/text()")
    public String groupName;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Transcode/StreamNameGroups/StreamNameGroup[Name='{groupName}']/Description/text()")
    public String description;
    @JsonProperty(value="streamName")
    @XStreamAlias(value="StreamName")
    @WMSXMLVariable(xpath="/Root/Transcode/StreamNameGroups/StreamNameGroup[Name='{groupName}']/StreamName/text()")
    public String streamName;
    @JsonProperty(value="Members")
    @XStreamAlias(value="Members")
    @WMSXMLList(xpath="/Root/Transcode/StreamNameGroups/StreamNameGroup[Name='{groupName}']/Members", keyxpath="/Member/MemberName", keyName="memberName")
    protected List<TranscoderMemberConfig> members;

    public TranscoderStreamNameGroupConfig() {
        String string = Utils.substring("uljusFhgn", 29 * 63);
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(63 + 117, "`p{gtxn~R|sz");
        this.addFieldForKeyMap(string2, string2);
        String string3 = Severity.valueOf(-11 - -58, "hb~gcZt{r");
        this.addFieldForKeyMap(string3, string3);
    }

    public TranscoderStreamNameGroupConfig(String string, String string2, String string3) {
        String string4 = Severity.valueOf(16 + 12, "{oqjpOcna");
        this.addFieldForKeyMap(string4, string4);
        this.vhostName = string;
        this.templateName = string2;
        this.groupName = string3;
        this.addToStringKeyMap(Utils.substring("\u007fbd\u007fy@n}t", 52 - 43), string);
        this.addToStringKeyMap(Severity.valueOf(-35 - -64, "i{rpmcwaKgjm"), string2);
        this.addToStringKeyMap(Utils.substring("bth}yDjah", 389 / 77), string3);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(23 * 55, "':<'!\u001865<"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(693 / 102, "rbeyfjxh@n}t"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(1229 / 246, "cwirxGkfi"));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public List<TranscoderMemberConfig> getMembers() {
        return this.members;
    }

    public void setMembers(List<TranscoderMemberConfig> list) {
        this.members = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    public static TranscoderStreamNameGroupConfig getObjectFromREST(String string, String string2, String string3, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(345 / 50, "pogz~Em`k"), string);
        hashMap.put(Severity.valueOf(55 * 21, "wahvki}oEm`k"), string2);
        hashMap.put(Utils.substring("=)3(.\u0011alg", -39 - -33), string3);
        String string4 = TranscoderStreamNameGroupConfig.getUrl(hashMap, TranscoderStreamNameGroupConfig.class);
        return (TranscoderStreamNameGroupConfig)TranscoderStreamNameGroupConfig.getObjectFromREST(string4, TranscoderStreamNameGroupConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig) {
        return this.groupName.compareTo(transcoderStreamNameGroupConfig.groupName);
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Utils.substring("uljusFhgn", 56 + 75));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Severity.valueOf(27 + 21, "?e`rzfux||h4hxso, 6&7");
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean exists() {
        TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig;
        Object object;
        Object object2;
        boolean bl = false;
        try {
            object2 = this.getFilename();
            object = new File((String)object2);
            bl = ((File)object).exists();
        }
        catch (Exception exception) {}
        if (!bl) return bl;
        bl = false;
        TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig2 = this;
        object2 = transcoderStreamNameGroupConfig2.getNewTemplate(transcoderStreamNameGroupConfig2.templateName);
        if (!((TranscoderTemplateConfig)object2).loadObject()) return bl;
        object = ((TranscoderTemplateConfig)object2).getStreamNameGroups().iterator();
        do {
            if (!object.hasNext()) return bl;
            transcoderStreamNameGroupConfig = (TranscoderStreamNameGroupConfig)object.next();
        } while (!transcoderStreamNameGroupConfig.groupName.equals(this.groupName));
        return true;
    }

    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateConfig(this.vhostName, string);
    }

    @Override
    public boolean loadObject() {
        this.vhostName = this.stringKeyMap.get(Severity.valueOf(33 * 29, "kvp35\f\") "));
        this.templateName = this.stringKeyMap.get(Severity.valueOf(-9 - -4, "/90.3augMehc"));
        this.groupName = this.stringKeyMap.get(Utils.substring("&0,15\b&%,", 4 - 35));
        return super.loadObject();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public WMSResponse deleteObject() {
        WMSResponse wMSResponse = new WMSResponse();
        if (ConfigBase.inTradeShowMode) {
            ConfigBase.log.warn((Object)(Severity.valueOf(754 / 191, "QAVR'IYC1,Ikcue{}s5Beywixsy{m Rvqadk'Fhgn,J|`ea2;") + this.getStringVariable(Utils.substring("2$8-)\u0014:18", 11 - 22)) + Severity.valueOf(63 * 31, "(8#Mk&szhnn,~f`g1\u007f|pp878Wuo<y{s%5+-#e\u00153:,+&l\u0003/\"5q\u0015!; &y")));
            wMSResponse.success = true;
            wMSResponse.message = Utils.substring("Gaicsmm", 29 * 63);
            return wMSResponse;
        }
        if (!this.removeNode(Utils.substring(":Dxwm5On|plcnff+VrumhgEm`kHb~gcg:Ecj|{vR|sz\u00073-64\u001e\b&%,wl7*< %!\u001c290+p\u0005", -61 + 82))) {
            wMSResponse.message = Severity.valueOf(677 / 151, "Gjskl)ddx-jj|tfv4zt}}zn");
            return wMSResponse;
        }
        wMSResponse.success = true;
        return wMSResponse;
    }
}

