/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderStreamNameGroupConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderStreamNameGroups")
@WMSDescription(text="VHost Transcoder Stream Name Groups", get="Retrieves the list of Transcoder Stream Name Groups for the specified Template", post="Adds a Transcoder Stream Name Groups Configuration to the specified Template")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates/{templateName}/streamnamegroups", restVerbs="GET,POST", xmlFilename="{templateName}.xml")
public class TranscoderStreamNameGroupsConfig
extends ConfigBase {
    @XStreamOmitField
    public String vhostName;
    @XStreamOmitField
    public String templateName;
    @JsonProperty(value="streamNameGroups")
    @XStreamImplicit(itemFieldName="StreamNameGroup")
    protected List<ShortObject> streamNameGroups = new ArrayList<ShortObject>();

    public TranscoderStreamNameGroupsConfig() {
        String string = Utils.substring("apvioR|sz", 37 * 11);
        this.addFieldForKeyMap(string, string);
        String string2 = Severity.valueOf(3 - -25, "hxsol`vfJdkb");
        this.addFieldForKeyMap(string2, string2);
    }

    public TranscoderStreamNameGroupsConfig(String string, String string2) {
        this.vhostName = string;
        this.templateName = string2;
        this.addToStringKeyMap(Utils.substring("nquhhS\u007fre", 2 + 22), string);
        this.addToStringKeyMap(Utils.substring("vfiujf|lDjah", -61 - 33), string2);
        this.initUrl();
        String string3 = Severity.valueOf(-12 - 60, "nquhhS\u007fr%");
        this.addFieldForKeyMap(string3, string3);
        String string4 = Utils.substring("rbeyfjxh@n}t", 1252 / 194);
        this.addFieldForKeyMap(string4, string4);
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(13 * 21, "gz|gaXvu|"));
        this.addToStringKeyMapFromRequest(Severity.valueOf(-16 - 21, "/90.3!5'\r%(#"));
        String string = Severity.valueOf(403 / 90, "rmit|Gkfi");
        this.addFieldForKeyMap(string, string);
        String string2 = Utils.substring("-?6,1?+%\u000f#.!", 27 * 27);
        this.addFieldForKeyMap(string2, string2);
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public List<ShortObject> getStreamNameGroups() {
        return this.streamNameGroups;
    }

    public void setStreamNameGroups(List<ShortObject> list) {
        this.streamNameGroups = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    @Override
    public boolean loadObject() {
        TranscoderTemplateConfig transcoderTemplateConfig = new TranscoderTemplateConfig(this.vhostName, this.templateName);
        transcoderTemplateConfig.loadObject();
        this.streamNameGroups.clear();
        Iterator<TranscoderStreamNameGroupConfig> iterator = transcoderTemplateConfig.getStreamNameGroups().iterator();
        while (iterator.hasNext()) {
            TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig = iterator.next();
            this.streamNameGroups.add(new ShortObject(transcoderStreamNameGroupConfig.groupName, this.restURI + "/" + transcoderStreamNameGroupConfig.groupName));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        TranscoderStreamNameGroupConfig transcoderStreamNameGroupConfig = new TranscoderStreamNameGroupConfig();
        Representation representation2 = transcoderStreamNameGroupConfig.post(representation, this.getRequest());
        this.setStatus(transcoderStreamNameGroupConfig.getStatus());
        if (transcoderStreamNameGroupConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(transcoderStreamNameGroupConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static TranscoderStreamNameGroupsConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(-63 - 9, "nquhhS\u007fr%"), string);
        hashMap.put(Severity.valueOf(49 - -52, "1#*8%+?)\u0003/\"5"), string2);
        return (TranscoderStreamNameGroupsConfig)TranscoderStreamNameGroupsConfig.getObjectFromREST(TranscoderStreamNameGroupsConfig.getUrl(hashMap, TranscoderStreamNameGroupsConfig.class), TranscoderStreamNameGroupsConfig.class, wMSClientSecurity);
    }
}

