/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.WMSResponse;
import com.wowza.wms.rest.WMSXMLList;
import com.wowza.wms.rest.WMSXMLVariable;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderEncodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderOverlayDecodeConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderStreamNameGroupConfig;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderTemplate")
@WMSDescription(text="VHost Trancoder Template", get="Retrieves the specified Trancoder Template configuration", put="Updates the specified Trancoder Template configuration", post="Adds the specified Trancoder Template configuration", delete="Deletes the specified Trancoder Template configuration")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates/{templateName}", restVerbs="GET,PUT,POST,DELETE", xmlFilename="{templateName}.xml")
public class TranscoderTemplateConfig
extends ConfigBase
implements Comparable<TranscoderTemplateConfig> {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="name")
    @XStreamAlias(value="Name")
    public String templateName;
    @JsonProperty(value="description")
    @XStreamAlias(value="Description")
    @WMSXMLVariable(xpath="/Root/Transcode/Description/text()")
    public String description;
    @JsonProperty(value="implementation")
    @XStreamAlias(value="Implementation")
    @WMSXMLVariable(xpath="/Root/Transcode/Decode/Video/Implementation/text()")
    public String implementation;
    @JsonProperty(value="deinterlace")
    @XStreamAlias(value="Deinterlace")
    @WMSXMLVariable(xpath="/Root/Transcode/Decode/Video/Deinterlace/text()")
    public boolean deinterlace;
    @JsonProperty(value="encodes")
    @XStreamAlias(value="Encodes")
    @WMSXMLList(xpath="/Root/Transcode/Encodes", keyxpath="/Encode/Name", keyName="encodeName")
    protected List<TranscoderEncodeConfig> encodes;
    @JsonProperty(value="streamNameGroups")
    @XStreamAlias(value="StreamNameGroups")
    @WMSXMLList(xpath="/Root/Transcode/StreamNameGroups", keyxpath="/StreamNameGroup/Name", keyName="groupName")
    protected List<TranscoderStreamNameGroupConfig> streamNameGroups;
    @JsonProperty(value="overlays")
    @XStreamAlias(value="Overlays")
    @WMSXMLList(xpath="/Root/Transcode/Decode/Video/Overlays", keyxpath="/Overlay/Name", keyName="overlayName")
    protected List<TranscoderOverlayDecodeConfig> decodeOverlays;

    public TranscoderTemplateConfig() {
    }

    public TranscoderTemplateConfig(String string, String string2) {
        this.vhostName = string;
        this.templateName = string2;
        this.addToStringKeyMap(Utils.substring("(7/26\r%(#", 39 - -55), string);
        this.addToStringKeyMap(Utils.substring("3-$:'-9+\u00011<7", 42 - -61), string2);
        this.initUrl();
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(102 + -10, "(83/, 6&\n$+\""));
        this.addToStringKeyMapFromRequest(Utils.substring(" ?7*.\u0015=0;", -33 - 9));
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String string) {
        this.implementation = string;
    }

    public boolean isDeinterlace() {
        return this.deinterlace;
    }

    public void setDeinterlace(boolean bl) {
        this.deinterlace = bl;
    }

    public List<TranscoderOverlayDecodeConfig> getDecodeOverlays() {
        return this.decodeOverlays;
    }

    public void setDecodeOverlays(List<TranscoderOverlayDecodeConfig> list) {
        this.decodeOverlays = list;
    }

    public List<TranscoderStreamNameGroupConfig> getStreamNameGroups() {
        return this.streamNameGroups;
    }

    public void setStreamNameGroups(List<TranscoderStreamNameGroupConfig> list) {
        this.streamNameGroups = list;
    }

    public List<TranscoderEncodeConfig> getEncodes() {
        return this.encodes;
    }

    public void setEncodes(List<TranscoderEncodeConfig> list) {
        this.encodes = list;
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Severity.valueOf(341 / 80, "rmit|Gkfi"));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Utils.substring("+qtffzidhh| dt\u007fcxtbrk", 755 / 161);
    }

    @Override
    public String getFilename() {
        return this.getBaseDir() + "/" + this.getXMLFilename();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WMSResponse saveNewObject() throws ConfigBase.ConfigBaseException {
        String string = this.getBaseDir();
        File file = new File(string);
        if (file.exists()) {
            return super.saveNewObject();
        }
        file.mkdirs();
        return super.saveNewObject();
    }

    @Override
    public boolean loadObject() {
        this.templateName = this.stringKeyMap.get(Utils.substring("(83/, 6&\n$+\"", 8 - 44));
        return super.loadObject();
    }

    public static TranscoderTemplateConfig getObjectFromREST(String string, String string2, WMSClientSecurity wMSClientSecurity) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Severity.valueOf(53 * 39, "e|zecVxw~"), string);
        hashMap.put(Utils.substring("!3:(5;/9\u0013?2e", -60 - -49), string2);
        String string3 = TranscoderTemplateConfig.getUrl(hashMap, TranscoderTemplateConfig.class);
        return (TranscoderTemplateConfig)TranscoderTemplateConfig.getObjectFromREST(string3, TranscoderTemplateConfig.class, wMSClientSecurity);
    }

    @Override
    public int compareTo(TranscoderTemplateConfig transcoderTemplateConfig) {
        return this.templateName.compareTo(transcoderTemplateConfig.templateName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WMSResponse copyAction(String string) {
        WMSResponse wMSResponse;
        block9: {
            wMSResponse = new WMSResponse();
            try {
                String string2 = URLDecoder.decode(string, Severity.valueOf(-40 - -4, "\t\t\u0018rx"));
                String string3 = this.getBaseDir() + "/" + this.templateName + Utils.substring("%t`b", -9 - -20);
                String string4 = this.getBaseDir() + "/" + string2 + Utils.substring("&qgg", 90 + 46);
                File file = new File(string3);
                File file2 = new File(string4);
                if (file2.exists()) {
                    wMSResponse.message = Utils.substring("Qcjxek\u007fi-", 1376 / 253) + string2 + Severity.valueOf(9 * 7, "?!-0&%!?g-1#88>");
                    break block9;
                }
                if (!file.exists()) {
                    wMSResponse.message = Utils.substring("Rbeyfjxh.", 1053 / 151) + this.templateName + Severity.valueOf(11 * 33, "k(\"+<p?='t0.>+-");
                } else {
                    TranscoderTemplateConfig.copyDirectory(file, file2);
                    wMSResponse.success = true;
                    wMSResponse.message = Utils.substring("Rbeyfjxh.'", 231 / 35) + string2 + Utils.substring("2<~lz!5''d63$+,98*8\"#)", -21 - 48);
                    TranscoderTemplateConfig transcoderTemplateConfig = this.getNewTemplate(string2);
                    transcoderTemplateConfig.setDescription("");
                    transcoderTemplateConfig.addToSaveFieldList(Severity.valueOf(1028 / 209, "``udz`z\u007feb`"));
                    try {
                        transcoderTemplateConfig.saveObject();
                    }
                    catch (ConfigBase.ConfigBaseException configBaseException) {
                        ConfigBase.log.warn((Object)Utils.substring("Awthz)yjzd`h0E`rzfux||h;Hxsol`vf", 1125 / 247), (Throwable)configBaseException);
                    }
                }
            }
            catch (SecurityException securityException) {
                wMSResponse.message = securityException.getMessage();
                ConfigBase.log.warn((Object)Severity.valueOf(21 * 47, "\u001e./1-`\"-3=,( h\u001d8*\">- 44 s\u00000;'48.>"), (Throwable)securityException);
            }
            catch (IOException iOException) {
                wMSResponse.message = iOException.getMessage();
                ConfigBase.log.warn((Object)Severity.valueOf(1269 / 221, "@tug{*hc}wf~v2Gftxd{v~~n=Jzmqnbp`"), (Throwable)iOException);
            }
        }
        if (wMSResponse.isSuccess()) {
            ConfigBase.log.info((Object)(Utils.substring("M\u0005\u0012\u0016c\u0005\u0015\u000f}h\n%;5m\u001a=1?!0;13%x\r?6,1?+%{b", 25 * 23) + wMSResponse.message));
            return wMSResponse;
        }
        ConfigBase.log.error((Object)(Utils.substring("_K\\D1SC]/6Twic;Ho\u007fqsbmgaw&Smdzgmyk50", 3 * 47) + wMSResponse.message));
        return wMSResponse;
    }

    protected TranscoderTemplateConfig getNewTemplate(String string) {
        return new TranscoderTemplateConfig(this.vhostName, string);
    }
}

