/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rest.vhosts.transcoder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.wowza.wms.rest.ConfigBase;
import com.wowza.wms.rest.Severity;
import com.wowza.wms.rest.ShortObject;
import com.wowza.wms.rest.Utils;
import com.wowza.wms.rest.WMSClientSecurity;
import com.wowza.wms.rest.WMSConfig;
import com.wowza.wms.rest.WMSDescription;
import com.wowza.wms.rest.vhosts.VHostsConfig;
import com.wowza.wms.rest.vhosts.transcoder.TranscoderTemplateConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.annotate.JsonProperty;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;

@JsonAutoDetect(value={JsonMethod.NONE})
@XStreamAlias(value="TranscoderTemplates")
@WMSDescription(text="VHost Transcoder Templates", get="Retrieves the list of Transcoder Template Configurations for the specified VHost", post="Adds a Transcoder Templates Configuration to the specified VHost")
@WMSConfig(restLocation="/v2/servers/{serverName}/vhosts/{vhostName}/transcoder/templates", restVerbs="GET,POST", xmlFilename="")
public class TranscoderTemplatesConfig
extends ConfigBase {
    @XStreamOmitField
    protected String vhostName;
    @JsonProperty(value="templates")
    @XStreamImplicit(itemFieldName="Template")
    private List<ShortObject> a = new ArrayList<ShortObject>();

    public TranscoderTemplatesConfig() {
    }

    public TranscoderTemplatesConfig(String string) {
        this.vhostName = string;
        this.addToStringKeyMap(Utils.substring("snh{}Djah", 416 / 71), string);
        this.initUrl();
    }

    public String getVhostName() {
        return this.vhostName;
    }

    public void setVhostName(String string) {
        this.vhostName = string;
    }

    public List<ShortObject> getTemplates() {
        return this.a;
    }

    public void setTemplates(List<ShortObject> list) {
        this.a = list;
    }

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.addToStringKeyMapFromRequest(Severity.valueOf(60 - -4, "6)-00\u000b'*-"));
    }

    @Override
    public boolean isValid(ConstraintValidatorContext constraintValidatorContext) {
        boolean bl = super.isValid(constraintValidatorContext);
        return bl;
    }

    @Override
    public boolean hasWarnings() {
        boolean bl = false;
        return bl;
    }

    protected String getBaseDir() {
        this.vhostName = this.getStringVariable(Severity.valueOf(935 / 191, "rmit|Gkfi"));
        String string = VHostsConfig.getVHostDir(this.vhostName);
        return string + Severity.valueOf(40 - 9, "0tscmwficm{%\u007fi`~cqew`");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean loadObject() {
        this.vhostName = this.getStringVariable(Severity.valueOf(33 * 11, "=$\"=;\u001e0?6"));
        String string = this.getBaseDir();
        File file = new File(string);
        String[] stringArray = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(Utils.substring("`7==", 18 - 36));
            }
        });
        if (stringArray != null) {
            for (String string2 : stringArray) {
                String string3 = string2.substring(0, string2.length() - 4);
                this.a.add(new ShortObject(string3, this.restURI + "/" + string3));
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Representation post(Representation representation) {
        this.vhostName = this.getStringVariable(Severity.valueOf(51 * 29, "1 &9?\u0002,#*"));
        TranscoderTemplateConfig transcoderTemplateConfig = new TranscoderTemplateConfig(this.vhostName, "");
        Representation representation2 = transcoderTemplateConfig.post(representation, this.getRequest());
        this.setStatus(transcoderTemplateConfig.getStatus());
        if (transcoderTemplateConfig.currentException == null) {
            return representation2;
        }
        this.getResponse().setEntity(transcoderTemplateConfig.currentException.getXML(), MediaType.APPLICATION_XML);
        return representation2;
    }

    public static TranscoderTemplatesConfig getObjectFromREST(String string, WMSClientSecurity wMSClientSecurity) {
        return (TranscoderTemplatesConfig)TranscoderTemplatesConfig.getObjectFromREST(TranscoderTemplatesConfig.getUrl(Severity.valueOf(161 / 46, "uljusFhgn"), string, TranscoderTemplatesConfig.class), TranscoderTemplatesConfig.class, wMSClientSecurity);
    }
}

