/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3;

import com.wowza.io.IRandomAccessReader;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class RandomAccessFile
implements Closeable,
DataInput,
DataOutput {
    private IRandomAccessReader randomAccessReader = null;
    private byte[] buffer = new byte[16];
    private ByteBuffer tmpBuffer;

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
    }

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
    }

    public RandomAccessFile(IRandomAccessReader iRandomAccessReader) {
        this.randomAccessReader = iRandomAccessReader;
        this.tmpBuffer = ByteBuffer.wrap(this.buffer);
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 1);
        return this.buffer[0] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 1);
        return this.buffer[0];
    }

    @Override
    public char readChar() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 1);
        return (char)this.buffer[0];
    }

    @Override
    public double readDouble() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 8);
        this.tmpBuffer.position(0);
        return this.tmpBuffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 4);
        this.tmpBuffer.position(0);
        return this.tmpBuffer.getFloat();
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.randomAccessReader.read(byArray, n, n2);
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.randomAccessReader.read(byArray, 0, byArray.length);
    }

    @Override
    public int readInt() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 4);
        this.tmpBuffer.position(0);
        return this.tmpBuffer.getInt();
    }

    @Override
    public String readLine() throws IOException {
        this.doStackTrace();
        return "";
    }

    @Override
    public long readLong() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 8);
        this.tmpBuffer.position(0);
        return this.tmpBuffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 2);
        this.tmpBuffer.position(0);
        return this.tmpBuffer.getShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        this.doStackTrace();
        return 0;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.doStackTrace();
        return 0;
    }

    @Override
    public String readUTF() throws IOException {
        this.doStackTrace();
        return "";
    }

    @Override
    public void close() throws IOException {
    }

    public long getFilePointer() throws IOException {
        return this.randomAccessReader.getFilePointer();
    }

    public long length() throws IOException {
        return this.randomAccessReader.length();
    }

    public int read() throws IOException {
        this.randomAccessReader.read(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.randomAccessReader.read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.randomAccessReader.read(byArray, 0, byArray.length);
    }

    public void seek(long l) throws IOException {
        this.randomAccessReader.seek(l);
    }

    public void setLength(long l) throws IOException {
        this.doStackTrace();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long l = this.randomAccessReader.getFilePointer();
        this.randomAccessReader.seek(l + (long)n);
        return (int)(this.randomAccessReader.getFilePointer() - l);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void write(int n) throws IOException {
        this.doStackTrace();
    }

    public FileDescriptor getFD() throws IOException {
        this.doStackTrace();
        return null;
    }

    public FileChannel getChannel() {
        this.doStackTrace();
        return null;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeChar(int n) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeShort(int n) throws IOException {
        this.doStackTrace();
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.doStackTrace();
    }

    public void doStackTrace() {
        try {
            String string = null;
            string.substring(12);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RandomAccessFile.class).error("RandomAccessFile: doStackTrace ", (Throwable)exception);
            exception.printStackTrace();
        }
    }
}

