/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiterIterator;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameDelimiter
extends AbstractFilenameComposite {
    private AbstractFilenameComposite afterComposite = null;
    private AbstractFilenameComposite beforeComposite = null;
    private String delimiter = null;

    public FilenameDelimiter() {
    }

    public FilenameDelimiter(FilenameDelimiter filenameDelimiter) {
        super(filenameDelimiter);
        this.delimiter = filenameDelimiter.delimiter;
        this.afterComposite = (AbstractFilenameComposite)TagUtility.copyObject(filenameDelimiter.afterComposite);
        this.beforeComposite = (AbstractFilenameComposite)TagUtility.copyObject(filenameDelimiter.beforeComposite);
    }

    public void setAfterComposite(AbstractFilenameComposite abstractFilenameComposite) {
        this.afterComposite = abstractFilenameComposite;
    }

    public AbstractFilenameComposite getAfterComposite() {
        return this.afterComposite;
    }

    public void setBeforeComposite(AbstractFilenameComposite abstractFilenameComposite) {
        this.beforeComposite = abstractFilenameComposite;
    }

    public AbstractFilenameComposite getBeforeComposite() {
        return this.beforeComposite;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setFrame(AbstractID3v2Frame abstractID3v2Frame) {
        if (abstractID3v2Frame != null) {
            if (this.beforeComposite != null) {
                this.beforeComposite.setFrame(abstractID3v2Frame);
            }
            if (this.afterComposite != null) {
                this.afterComposite.setFrame(abstractID3v2Frame);
            }
        }
    }

    @Override
    public String composeFilename() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.beforeComposite != null) {
            stringBuffer.append(this.beforeComposite.composeFilename());
        }
        stringBuffer.append(this.delimiter);
        stringBuffer.append(' ');
        if (this.afterComposite != null) {
            stringBuffer.append(this.afterComposite.composeFilename());
        }
        return stringBuffer.toString();
    }

    @Override
    public ID3v2_4 createId3Tag() {
        ID3v2_4 iD3v2_4 = null;
        if (this.beforeComposite != null) {
            iD3v2_4 = this.beforeComposite.createId3Tag();
        }
        if (this.afterComposite != null) {
            if (iD3v2_4 != null) {
                iD3v2_4.append(this.afterComposite.createId3Tag());
            } else {
                iD3v2_4 = this.afterComposite.createId3Tag();
            }
        }
        return iD3v2_4;
    }

    @Override
    public Iterator iterator() {
        return new FilenameDelimiterIterator(this);
    }

    @Override
    public void matchAgainstKeyword(Class clazz) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(clazz)) {
            if (this.beforeComposite != null) {
                this.beforeComposite.matchAgainstKeyword(clazz);
            }
            if (this.afterComposite != null) {
                this.afterComposite.matchAgainstKeyword(clazz);
            }
        }
    }

    @Override
    public void matchAgainstTag(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (this.beforeComposite != null) {
                this.beforeComposite.matchAgainstTag(abstractMP3Tag);
            }
            if (this.afterComposite != null) {
                this.afterComposite.matchAgainstTag(abstractMP3Tag);
            }
        }
    }
}

