/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import org.farng.mp3.AbstractMP3FragmentBody;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.RandomAccessFile;

public abstract class AbstractID3v2FrameBody
extends AbstractMP3FragmentBody {
    protected AbstractID3v2FrameBody() {
    }

    protected AbstractID3v2FrameBody(AbstractID3v2FrameBody abstractID3v2FrameBody) {
        super(abstractID3v2FrameBody);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof AbstractID3v2FrameBody && super.equals(object);
    }

    @Override
    protected int readHeader(RandomAccessFile randomAccessFile) throws IOException, InvalidTagException {
        int n;
        byte[] byArray = new byte[3];
        if (AbstractID3v2FrameBody.has6ByteHeader()) {
            randomAccessFile.read(byArray, 0, 3);
            n = (int)((double)byArray[0] * Math.pow(2.0, 16.0) + (double)byArray[1] * Math.pow(2.0, 8.0) + (double)byArray[2]);
        } else {
            n = randomAccessFile.readInt();
            randomAccessFile.skipBytes(2);
        }
        if (n == 0) {
            throw new InvalidTagException("Found empty frame");
        }
        if (n <= 0 || (long)n > randomAccessFile.length()) {
            throw new InvalidTagException("Invalid size for Frame Body");
        }
        return n;
    }

    @Override
    protected void writeHeader(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = new byte[3];
        if (AbstractID3v2FrameBody.has6ByteHeader()) {
            byArray[0] = (byte)((n & 0xFF0000) >> 16);
            byArray[1] = (byte)((n & 0xFF00) >> 8);
            byArray[2] = (byte)(n & 0xFF);
            randomAccessFile.write(byArray);
        } else {
            randomAccessFile.writeInt(n);
            randomAccessFile.skipBytes(2);
        }
    }
}

