/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.Iterator;
import java.util.LinkedList;
import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectID3v2LyricLine;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class ObjectLyrics3Line
extends AbstractMP3Object {
    private LinkedList timeStamp = new LinkedList();
    private String lyric = "";

    public ObjectLyrics3Line(String string) {
        this.identifier = string;
    }

    public ObjectLyrics3Line(ObjectLyrics3Line objectLyrics3Line) {
        super(objectLyrics3Line);
        this.lyric = new String(objectLyrics3Line.lyric);
        for (int i = 0; i < objectLyrics3Line.timeStamp.size(); ++i) {
            ObjectLyrics3TimeStamp objectLyrics3TimeStamp = new ObjectLyrics3TimeStamp((ObjectLyrics3TimeStamp)objectLyrics3Line.timeStamp.get(i));
            this.timeStamp.add(objectLyrics3TimeStamp);
        }
    }

    public void setLyric(String string) {
        this.lyric = string;
    }

    public void setLyric(ObjectID3v2LyricLine objectID3v2LyricLine) {
        this.lyric = objectID3v2LyricLine.getText();
    }

    public String getLyric() {
        return this.lyric;
    }

    @Override
    public int getSize() {
        int n = 0;
        for (int i = 0; i < this.timeStamp.size(); ++i) {
            n += ((ObjectLyrics3TimeStamp)this.timeStamp.get(i)).getSize();
        }
        return n + this.lyric.length();
    }

    public void setTimeStamp(ObjectLyrics3TimeStamp objectLyrics3TimeStamp) {
        this.timeStamp.clear();
        this.timeStamp.add(objectLyrics3TimeStamp);
    }

    public Iterator getTimeStamp() {
        return this.timeStamp.iterator();
    }

    public void addLyric(String string) {
        this.lyric = this.lyric + string;
    }

    public void addLyric(ObjectID3v2LyricLine objectID3v2LyricLine) {
        this.lyric = this.lyric + objectID3v2LyricLine.getText();
    }

    public void addTimeStamp(ObjectLyrics3TimeStamp objectLyrics3TimeStamp) {
        this.timeStamp.add(objectLyrics3TimeStamp);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectLyrics3Line)) {
            return false;
        }
        ObjectLyrics3Line objectLyrics3Line = (ObjectLyrics3Line)object;
        if (!this.lyric.equals(objectLyrics3Line.lyric)) {
            return false;
        }
        if (!this.timeStamp.equals(objectLyrics3Line.timeStamp)) {
            return false;
        }
        return super.equals(object);
    }

    public boolean hasTimeStamp() {
        return !this.timeStamp.isEmpty();
    }

    @Override
    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to line is out of bounds: offset = " + n + ", line.length()" + string.length());
        }
        this.timeStamp = new LinkedList();
        int n2 = string.indexOf("[", n);
        while (n2 >= 0) {
            n = string.indexOf("]", n2) + 1;
            ObjectLyrics3TimeStamp objectLyrics3TimeStamp = new ObjectLyrics3TimeStamp("Time Stamp");
            objectLyrics3TimeStamp.readString(string.substring(n2, n));
            this.timeStamp.add(objectLyrics3TimeStamp);
            n2 = string.indexOf("[", n);
        }
        this.lyric = string.substring(n);
    }

    @Override
    public String toString() {
        String string = "";
        for (int i = 0; i < this.timeStamp.size(); ++i) {
            string = string + this.timeStamp.get(i).toString();
        }
        return "timeStamp = " + string + ", lyric = " + this.lyric + "\n";
    }

    @Override
    public String writeString() {
        String string = "";
        for (int i = 0; i < this.timeStamp.size(); ++i) {
            ObjectLyrics3TimeStamp objectLyrics3TimeStamp = (ObjectLyrics3TimeStamp)this.timeStamp.get(i);
            string = string + objectLyrics3TimeStamp.writeString();
        }
        return string + this.lyric;
    }
}

