/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectLyrics3TimeStamp
extends AbstractMP3Object {
    private long minute = 0L;
    private long second = 0L;
    private byte timeStampFormat = 0;

    public ObjectLyrics3TimeStamp(String string) {
        this.identifier = string;
    }

    public ObjectLyrics3TimeStamp(ObjectLyrics3TimeStamp objectLyrics3TimeStamp) {
        super(objectLyrics3TimeStamp);
        this.minute = objectLyrics3TimeStamp.minute;
        this.second = objectLyrics3TimeStamp.second;
    }

    public void setMinute(long l) {
        this.minute = l;
    }

    public long getMinute() {
        return this.minute;
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setTimeStampFormat(byte by) {
        this.timeStampFormat = by;
    }

    public void setSecond(long l) {
        this.second = l;
    }

    public long getSecond() {
        return this.second;
    }

    @Override
    public int getSize() {
        return 7;
    }

    public void setTimeStamp(long l, byte by) {
        this.minute = (l /= 1000L) / 60L;
        this.second = l % 60L;
        this.timeStampFormat = by;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectLyrics3TimeStamp)) {
            return false;
        }
        ObjectLyrics3TimeStamp objectLyrics3TimeStamp = (ObjectLyrics3TimeStamp)object;
        if (this.minute != objectLyrics3TimeStamp.minute) {
            return false;
        }
        if (this.second != objectLyrics3TimeStamp.second) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Image is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to timeStamp is out of bounds: offset = " + n + ", timeStamp.length()" + string.length());
        }
        if ((string = string.substring(n)).length() == 7) {
            this.minute = Integer.parseInt(string.substring(1, 3));
            this.second = Integer.parseInt(string.substring(4, 6));
        } else {
            this.minute = 0L;
            this.second = 0L;
        }
    }

    @Override
    public String toString() {
        return this.writeString();
    }

    @Override
    public String writeString() {
        String string = "[";
        if (this.minute < 0L) {
            string = string + "00";
        } else {
            if (this.minute < 10L) {
                string = string + '0';
            }
            string = string + Long.toString(this.minute);
        }
        string = string + ':';
        if (this.second < 0L) {
            string = string + "00";
        } else {
            if (this.second < 10L) {
                string = string + '0';
            }
            string = string + Long.toString(this.second);
        }
        string = string + ']';
        return string;
    }
}

