/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectNumberVariableLength
extends AbstractMP3Object {
    int minLength = 1;

    public ObjectNumberVariableLength(String string, int n) {
        this.identifier = string;
        if (n > 0) {
            this.minLength = n;
        }
    }

    public ObjectNumberVariableLength(ObjectNumberVariableLength objectNumberVariableLength) {
        super(objectNumberVariableLength);
        this.minLength = objectNumberVariableLength.minLength;
    }

    public int getMaximumLenth() {
        return 8;
    }

    public int getMinimumLength() {
        return this.minLength;
    }

    public void setMinimumSize(int n) {
        if (n > 0) {
            this.minLength = n;
        }
    }

    @Override
    public int getSize() {
        if (this.value == null) {
            return 0;
        }
        long l = TagUtility.getWholeNumber(this.value);
        int n = 0;
        for (int i = 1; i <= 8; ++i) {
            int n2 = (byte)l & 0xFF;
            if (n2 != 0) {
                n = i;
            }
            l >>= 8;
        }
        return this.minLength > n ? this.minLength : n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ObjectNumberVariableLength)) {
            return false;
        }
        ObjectNumberVariableLength objectNumberVariableLength = (ObjectNumberVariableLength)object;
        if (this.minLength != objectNumberVariableLength.minLength) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public void readByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (n < 0 || n >= byArray.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + n + ", array.length = " + byArray.length);
        }
        long l = 0L;
        for (int i = n; i < byArray.length; ++i) {
            l <<= 8;
            l += (long)byArray[i];
        }
        this.value = new Long(l);
    }

    @Override
    public void readString(String string, int n) {
        if (string == null) {
            throw new NullPointerException("Number string is null");
        }
        if (n < 0 || n >= string.length()) {
            throw new IndexOutOfBoundsException("Offset to number string is out of bounds: offset = " + n + ", string.length()" + string.length());
        }
        this.value = Long.getLong(string.substring(n));
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] byArray;
        int n = this.getSize();
        if (n == 0) {
            byArray = new byte[]{};
        } else {
            long l = TagUtility.getWholeNumber(this.value);
            byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)(l & 0xFFL);
                l >>= 8;
            }
        }
        return byArray;
    }

    @Override
    public String writeString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }
}

