/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import com.wowza.wms.bootstrap.Bootstrap;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;

public class BootstrapConsoleLogger {
    public static final int BUFFERSIZE = 153600;
    public static final int STARTSIZE = 153600;
    public static final String LOG_ACCESS_APPENDER = "serverAccess";
    public static final String LOG_CONSOLE_APPENDER = "stdout";
    private String logPath = null;
    private String propertiesPath = null;
    private int bufferSize = 153600;
    private int startSize = 153600;
    private String logAccessAppender = "serverAccess";
    private String logConsoleAppender = "serverAccess";
    private String charSet = null;
    private int startCount = 20;
    private byte[] delimLine = null;
    private String delimFieldStr = "\t";
    private long filePos = 0L;
    private long lastLength = -1L;
    private byte[] signature = null;
    private long signaturePos = -1L;
    private int signatureLen = 0;
    private String fieldsConsoleStr = "x-severity,x-category,x-event,x-ctx,x-comment";
    private String fieldsAccessStr = "date,time,tz,x-event,x-category,x-severity,x-status,x-ctx,x-comment,x-vhost,x-app,x-appinst,x-duration,s-ip,s-port,s-uri,c-ip,c-proto,c-referrer,c-user-agent,c-client-id,cs-bytes,sc-bytes,x-stream-id,x-spos,cs-stream-bytes,sc-stream-bytes,x-sname,x-sname-query,x-file-name,x-file-ext,x-file-size,x-file-length,x-suri,x-suri-stem,x-suri-query,cs-uri-stem,cs-uri-query";
    private int[] fieldsArr = null;
    private int fieldsCount = -1;
    private byte[] buffer = null;
    private int bufPos = 0;
    private int bufSrch = 0;
    private int bufData = 0;
    private boolean isFirstRun = true;
    private boolean isFirstLog = true;
    private boolean isNewFile = true;

    public void readPropertiesFile() {
        block8: {
            File file;
            if (this.propertiesPath == null || !(file = new File(this.propertiesPath)).exists()) break block8;
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                System.out.println("*** ERROR: BootstrapConsoleLogger.readPropertiesFile[" + this.propertiesPath + "]: " + exception.toString());
            }
            if (!properties.isEmpty()) {
                String string;
                Object object;
                String string2;
                String string3;
                String string4 = properties.getProperty("log4j.appender." + this.logAccessAppender + ".Fields");
                if (string4 != null) {
                    this.fieldsAccessStr = string4;
                }
                if ((string3 = properties.getProperty("log4j.appender." + this.logConsoleAppender + ".Fields")) != null) {
                    this.fieldsConsoleStr = string3;
                }
                if ((string2 = properties.getProperty("log4j.appender." + this.logAccessAppender + ".File")) != null) {
                    object = new HashMap();
                    this.logPath = Bootstrap.expandEnvironmentVariables(string2, object);
                }
                if ((object = properties.getProperty("log4j.appender." + this.logAccessAppender + ".layout.Delimeter")) != null) {
                    this.delimFieldStr = ((String)object).equalsIgnoreCase("tab") ? "\t" : (((String)object).equalsIgnoreCase("space") ? " " : object);
                }
                if ((string = properties.getProperty("log4j.appender." + this.logAccessAppender + ".encoding")) != null) {
                    this.charSet = string;
                }
            }
        }
    }

    public void init() {
        Object object;
        this.readPropertiesFile();
        this.resolveLogFieds();
        String string = System.getProperty("line.separator");
        if (string != null) {
            if (this.charSet != null) {
                try {
                    this.delimLine = string.getBytes(this.charSet);
                }
                catch (Exception exception) {
                    this.delimLine = string.getBytes();
                }
            } else {
                this.delimLine = string.getBytes();
            }
        } else {
            this.delimLine = new byte[2];
            this.delimLine[0] = 13;
            this.delimLine[1] = 10;
        }
        if (this.delimLine.length > 4 && (this.delimLine[0] & 0xFF) >= 254 && (this.delimLine[0] & 0xFF) >= 254) {
            object = new byte[this.delimLine.length - 2];
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = this.delimLine[this.delimLine.length - ((Object)object).length + i];
            }
            this.delimLine = (byte[])object;
        }
        this.buffer = new byte[this.bufferSize];
        try {
            if (this.logPath != null) {
                object = new File(this.logPath);
                System.out.println("Tailing log file: " + ((File)object).getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resolveLogFieds() {
        try {
            int n;
            String[] stringArray = this.fieldsConsoleStr.split(",");
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = stringArray[n].trim();
            }
            this.fieldsArr = new int[stringArray.length];
            for (n = 0; n < this.fieldsArr.length; ++n) {
                this.fieldsArr[n] = -1;
            }
            String[] stringArray2 = this.fieldsAccessStr.split(",");
            this.fieldsCount = stringArray2.length;
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray2[i].trim();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equals(stringArray2[i])) continue;
                    this.fieldsArr[j] = i;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("*** ERROR: BootstrapConsoleLogger.resolveLogFieds[" + this.propertiesPath + "]: " + exception.toString());
        }
    }

    public int fillBuffer() {
        RandomAccessFile randomAccessFile = null;
        int n = 0;
        File file = new File(this.logPath);
        if (file.exists() && file.length() > this.filePos) {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(this.filePos);
                n = randomAccessFile.read(this.buffer, this.bufData, this.buffer.length - this.bufData);
                if (n > 0) {
                    this.bufData += n;
                }
                randomAccessFile.close();
            }
            catch (Exception exception) {
                System.out.println("*** ERROR: BootstrapConsoleLogger.fillBuffer: " + exception.toString());
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public void slideBuffer() {
        if (this.bufPos > 0) {
            System.arraycopy(this.buffer, this.bufPos, this.buffer, 0, this.bufData - this.bufPos);
            this.bufData -= this.bufPos;
            this.bufPos = 0;
        }
    }

    public int bufferDataLen() {
        return this.bufData - this.bufPos;
    }

    public LogLine getNextLine() {
        LogLine logLine;
        block5: {
            logLine = null;
            int n = 0;
            do {
                int n2;
                int n3 = -1;
                if (n > 0 || this.bufferDataLen() < this.delimLine.length) {
                    this.slideBuffer();
                    n3 = this.fillBuffer();
                    this.filePos += (long)n3;
                }
                if (n3 == 0 || this.bufferDataLen() < this.delimLine.length) break block5;
                int n4 = this.bufferDataLen() - (this.delimLine.length - 1);
                for (n2 = this.bufSrch; n2 < n4; ++n2) {
                    int n5;
                    if (this.buffer[this.bufPos + n2] != this.delimLine[0]) continue;
                    for (n5 = 0; n5 < this.delimLine.length && this.buffer[this.bufPos + n2 + n5] == this.delimLine[n5]; ++n5) {
                    }
                    if (n5 != this.delimLine.length) continue;
                    logLine = new LogLine();
                    logLine.bufPos = this.bufPos;
                    logLine.filePos = this.filePos - (long)(this.bufData - this.bufPos);
                    logLine.len = n2;
                    this.bufPos += n2 + this.delimLine.length;
                    this.bufSrch = 0;
                    break;
                }
                if (logLine != null) break block5;
                this.bufSrch = n2;
            } while (++n <= 1);
            if (this.bufData == this.buffer.length) {
                this.bufData = 0;
                this.bufPos = 0;
            }
        }
        return logLine;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String string) {
        this.logPath = string;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public boolean isNewFile() {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        if (this.isFirstRun || this.isNewFile) {
            bl = true;
        } else {
            File file = new File(this.logPath);
            if (file.exists()) {
                long l = file.length();
                if (l < this.lastLength) {
                    bl = true;
                } else {
                    this.lastLength = l;
                    if (this.signature != null) {
                        if (l < this.signaturePos + (long)this.signatureLen) {
                            bl = true;
                        } else {
                            byte[] byArray = new byte[this.signatureLen];
                            try {
                                randomAccessFile = new RandomAccessFile(file, "r");
                                randomAccessFile.seek(this.signaturePos);
                                randomAccessFile.read(byArray);
                                randomAccessFile.close();
                            }
                            catch (Exception exception) {
                                System.out.println("*** ERROR: BootstrapConsoleLogger.isNewFile: " + exception.toString());
                            }
                            if (!Arrays.equals(byArray, this.signature)) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private void resetBuffer() {
        this.bufPos = 0;
        this.bufSrch = 0;
        this.bufData = 0;
    }

    private void resetFile() {
        this.filePos = 0L;
        this.lastLength = -1L;
        this.signature = null;
        this.signaturePos = -1L;
        this.signatureLen = 0;
    }

    private void resetFields() {
        this.fieldsArr = null;
        this.fieldsCount = -1;
    }

    public void moveToFilePos(long l) {
        this.resetBuffer();
        this.filePos = l;
    }

    private void moveToFileEnd(long l) {
        block2: {
            File file = new File(this.logPath);
            if (!file.exists()) break block2;
            long l2 = file.length();
            if (file.length() < (long)this.startSize) {
                this.moveToFilePos(l);
            } else {
                this.moveToFilePos(l2 - (long)this.startSize);
                this.getNextLine();
            }
        }
    }

    public void initFile() {
        LogLine logLine;
        this.resetBuffer();
        this.resetFile();
        while ((logLine = this.getNextLine()) != null) {
            String string;
            if (logLine.len <= 0 || (string = this.toString(logLine)) == null || (string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            this.signature = new byte[logLine.len];
            this.signaturePos = logLine.filePos;
            this.signatureLen = logLine.len;
            System.arraycopy(this.buffer, logLine.bufPos, this.signature, 0, this.signature.length);
            this.moveToFileEnd(logLine.filePos);
            this.isFirstRun = false;
            this.isNewFile = false;
            break;
        }
    }

    private String toString(LogLine logLine) {
        String string = "";
        if (this.charSet == null) {
            string = new String(this.buffer, logLine.bufPos, logLine.len);
        } else {
            try {
                string = new String(this.buffer, logLine.bufPos, logLine.len, this.charSet);
            }
            catch (Exception exception) {
                System.out.println("*** ERROR: BootstrapConsoleLogger.toString: " + exception.toString());
            }
        }
        return string;
    }

    public void run() {
        LogLine logLine;
        if (this.isNewFile()) {
            this.isNewFile = true;
            this.initFile();
        }
        if (this.isNewFile) {
            return;
        }
        ArrayList<String> arrayList = null;
        if (this.isFirstLog) {
            arrayList = new ArrayList<String>();
        }
        while ((logLine = this.getNextLine()) != null) {
            String string = this.toString(logLine);
            if (string == null || (string = string.trim()).length() <= 0) continue;
            String string2 = null;
            if (this.fieldsArr == null) {
                string2 = string;
            } else {
                String[] stringArray = string.split(this.delimFieldStr);
                if (stringArray.length >= this.fieldsCount) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.fieldsArr.length; ++i) {
                        if (this.fieldsArr[i] < 0) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(" ");
                        }
                        stringBuffer.append(stringArray[this.fieldsArr[i]]);
                    }
                    string2 = stringBuffer.toString();
                } else {
                    string2 = string;
                }
            }
            if (string2 == null) continue;
            if (arrayList != null) {
                arrayList.add(string2);
                continue;
            }
            System.out.println(string2);
        }
        if (this.isFirstLog) {
            while (arrayList.size() > this.startCount) {
                arrayList.remove(0);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println((String)arrayList.get(i));
            }
            this.isFirstLog = false;
        }
    }

    public String getPropertiesPath() {
        return this.propertiesPath;
    }

    public void setPropertiesPath(String string) {
        this.propertiesPath = string;
    }

    public String getLogAccessAppender() {
        return this.logAccessAppender;
    }

    public void setLogAccessAppender(String string) {
        this.logAccessAppender = string;
    }

    public String getLogConsoleAppender() {
        return this.logConsoleAppender;
    }

    public void setLogConsoleAppender(String string) {
        this.logConsoleAppender = string;
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void setStartCount(int n) {
        this.startCount = n;
    }

    class LogLine {
        long filePos = -1L;
        int bufPos = -1;
        int len = 0;

        LogLine() {
        }
    }
}

