/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.bootstrap;

import javax.management.MBeanServer;
import javax.management.ObjectName;

public class BootstrapOperatingSystemUtils {
    public static final String MBEAN_OS_DOMAIN = "java.lang";
    public static final String MBEAN_OS_KEY = "type";
    public static final String MBEAN_OS_VALUE = "OperatingSystem";
    public static final String[] MBEAN_OS_ATTR_TOTALPHYSICALMEMORY = new String[]{"TotalPhysicalMemorySize", "TotalPhysicalMemory"};
    public static final String[] MBEAN_OS_ATTR_FREEPHYSICALMEMORY = new String[]{"FreePhysicalMemorySize", "FreePhysicalMemory"};
    public static final String[] MBEAN_OS_ATTR_TOTALSWAPSPACE = new String[]{"TotalSwapSpaceSize", "TotalSwapSpace"};
    public static final String[] MBEAN_OS_ATTR_FREESWAPSPACE = new String[]{"FreeSwapSpaceSize", "FreeSwapSpace"};
    public static final String[] MBEAN_OS_ATTR_AVAILABLEPROCESSORS = new String[]{"AvailableProcessors"};
    public static final String[] MBEAN_OS_ATTR_PROCESSCPUTIME = new String[]{"ProcessCpuTime"};
    public static final String[] MBEAN_OS_ATTR_MAXFILEDESCRIPTOR = new String[]{"MaxFileDescriptorCount", "MaxFileDescriptor", "MAXFILEDES"};
    public static final String[] MBEAN_OS_ATTR_OPENFILEDESCRIPTOR = new String[]{"OpenFileDescriptorCount", "OpenFileDescriptor", "OPENFILEDE"};

    public static long getOperatingSystemLong(MBeanServer mBeanServer, String[] stringArray, long l) {
        long l2 = l;
        if (mBeanServer != null) {
            Object object = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    object = mBeanServer.getAttribute(new ObjectName(MBEAN_OS_DOMAIN, MBEAN_OS_KEY, MBEAN_OS_VALUE), stringArray[i]);
                }
                catch (Exception exception) {
                    object = null;
                }
                if (object != null) break;
            }
            if (object != null) {
                if (object instanceof Long) {
                    l2 = (Long)object;
                } else if (object instanceof Integer) {
                    l2 = ((Integer)object).intValue();
                } else {
                    try {
                        l2 = Long.parseLong(object.toString());
                    }
                    catch (Exception exception) {
                        l2 = l;
                    }
                }
            }
        }
        return l2;
    }

    public static long getTotalPhysicalMemorySize(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_TOTALPHYSICALMEMORY, l);
    }

    public static long getFreePhysicalMemorySize(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_FREEPHYSICALMEMORY, l);
    }

    public static long getTotalSwapSpaceSize(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_TOTALSWAPSPACE, l);
    }

    public static long getFreeSwapSpaceSize(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_FREESWAPSPACE, l);
    }

    public static int getAvailableProcessors(MBeanServer mBeanServer, long l) {
        return (int)BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_AVAILABLEPROCESSORS, l);
    }

    public static long getProcessCpuTime(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_PROCESSCPUTIME, l);
    }

    public static long getMaxFileDescriptorCount(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_MAXFILEDESCRIPTOR, l);
    }

    public static long getOpenFileDescriptorCount(MBeanServer mBeanServer, long l) {
        return BootstrapOperatingSystemUtils.getOperatingSystemLong(mBeanServer, MBEAN_OS_ATTR_OPENFILEDESCRIPTOR, l);
    }
}

