/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.JSON;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.amf.IAMFPacketExtraData;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.live.ILiveReceiver;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import java.util.List;
import java.util.Map;

public abstract class MediaStreamLiveAbstract
extends MediaStream
implements IMediaStreamTimecodeControl {
    protected ILiveReceiver liveReceiver = null;

    public void init(MediaStreamMap mediaStreamMap, int n, WMSProperties wMSProperties) {
        super.init(mediaStreamMap, n, wMSProperties);
        this.liveReceiver.init((IMediaStream)this);
        int n2 = this.getProperties().getPropertyInt(JSON.replace((String)"kfpec}il{ky~~r`pxta", (int)(727 / 121)), 8000);
        this.liveReceiver.setMaximumLiveLatency(n2);
        int n3 = this.getProperties().getPropertyInt(JSON.replace((String)"hg\u007fXhi`iy}_ucAvwzxs", (int)(29 * 9)), 200);
        this.liveReceiver.setMaximumPacketsPerSecond(n3);
        this.liveReceiver.setSrc(n);
    }

    public void startPublishing() {
    }

    public void stopPublishing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getVideoMissing() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.videoSize;
            return this.liveReceiver.getVideoMissing(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDataMissing() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.dataSize;
            return this.liveReceiver.getDataMissing(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAudioMissing() {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            n = this.audioSize;
            return this.liveReceiver.getAudioMissing(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addVideoData(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        Object object = this.lock;
        synchronized (object) {
            l = this.videoTC;
            n3 = this.videoSize;
        }
        this.liveReceiver.addVideoData(byArray, n, n2, n3, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addDataData(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        Object object = this.lock;
        synchronized (object) {
            l = this.dataTC;
            n3 = this.dataSize;
        }
        this.liveReceiver.addDataData(byArray, n, n2, n3, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAudioData(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        Object object = this.lock;
        synchronized (object) {
            l = this.audioTC;
            n3 = this.audioSize;
        }
        this.liveReceiver.addAudioData(byArray, n, n2, n3, l);
    }

    public long getMaxTimecode() {
        return this.liveReceiver.getMaxTimecode();
    }

    public int getPacketCount() {
        return this.liveReceiver.getPacketCount();
    }

    public AMFPacket getLastPacket() {
        return this.liveReceiver.getLastPacket();
    }

    public AMFPacket getLastKeyFrame() {
        return this.liveReceiver.getLastKeyFrame();
    }

    public List<AMFPacket> getPlayPackets() {
        return this.liveReceiver.getPlayPackets();
    }

    public void trim() {
        this.liveReceiver.trim();
    }

    public void publish() {
    }

    public void shutdown() {
        this.liveReceiver.shutdown();
        super.shutdown();
    }

    public void close() {
        this.liveReceiver.close();
        super.close();
    }

    public void resetTimecodes() {
        this.liveReceiver.resetTimecodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateLoggingValues() {
        super.updateLoggingValues();
        if (this.isPlay()) {
            return;
        }
        this.liveReceiver.updateLoggingValues();
    }

    public long getTimecodeOffset() {
        return this.liveReceiver.getTimecodeOffset();
    }

    public long getLastReceivedAudioTC() {
        return this.liveReceiver.getLastReceivedAudioTC();
    }

    public long getLastReceivedVideoTC() {
        return this.liveReceiver.getLastReceivedVideoTC();
    }

    public long getLastReceivedDataTC() {
        return this.liveReceiver.getLastReceivedDataTC();
    }

    public long getLastSentAudioTC() {
        return this.liveReceiver.getLastSentAudioTC();
    }

    public long getLastSentVideoTC() {
        return this.liveReceiver.getLastSentVideoTC();
    }

    public long getLastSentDataTC() {
        return this.liveReceiver.getLastSentDataTC();
    }

    public long getLastFlushAudioTC() {
        return this.liveReceiver.getLastFlushAudioTC();
    }

    public long getLastFlushVideoTC() {
        return this.liveReceiver.getLastFlushVideoTC();
    }

    public long getLastFlushDataTC() {
        return this.liveReceiver.getLastFlushDataTC();
    }

    public long getLastFlushTimecode() {
        return this.liveReceiver.getLastFlushTimecode();
    }

    public long getLastFlushRTTimecode() {
        return this.liveReceiver.getLastFlushRTTimecode();
    }

    public long getLastFlushTime() {
        return this.liveReceiver.getLastFlushTime();
    }

    public long getLastPacketTC() {
        return this.liveReceiver.getLastPacketTC();
    }

    public long getFirstPacketTC() {
        return this.liveReceiver.getFirstPacketTC();
    }

    public AMFPacket getAudioCodecConfigPacket(long l) {
        return this.liveReceiver.getAudioCodecConfigPacket(l);
    }

    public AMFPacket getVideoCodecConfigPacket(long l) {
        return this.liveReceiver.getVideoCodecConfigPacket(l);
    }

    public void addAudioCodecConfigPacket(long l, AMFPacket aMFPacket) {
        this.liveReceiver.addAudioCodecConfigPacket(l, aMFPacket);
    }

    public void addVideoCodecConfigPacket(long l, AMFPacket aMFPacket) {
        this.liveReceiver.addVideoCodecConfigPacket(l, aMFPacket);
    }

    public void flush() {
        this.liveReceiver.flush();
    }

    public void startAudioPacket() {
        this.liveReceiver.startAudioPacket();
    }

    public void startVideoPacket() {
        this.liveReceiver.startVideoPacket();
    }

    public void startDataPacket() {
        this.liveReceiver.startDataPacket();
    }

    public ILiveStreamPacketizer getLiveStreamPacketizer(String string) {
        return this.liveReceiver.getLiveStreamPacketizer(string);
    }

    public int getPublishVideoCodecId() {
        return this.liveReceiver.getVideoCodecId();
    }

    public int getPublishAudioCodecId() {
        return this.liveReceiver.getAudioCodecId();
    }

    public void setPublishVideoCodecId(int n) {
        this.liveReceiver.setVideoCodecId(n);
    }

    public void setPublishAudioCodecId(int n) {
        this.liveReceiver.setAudioCodecId(n);
    }

    public boolean isPublishStreamReady(boolean bl, boolean bl2) {
        return this.liveReceiver.isPublishStreamReady(bl, bl2);
    }

    public void addAudioExtraData(Map<String, IAMFPacketExtraData> map) {
        this.liveReceiver.addAudioExtraData(map);
    }

    public void addVideoExtraData(Map<String, IAMFPacketExtraData> map) {
        this.liveReceiver.addVideoExtraData(map);
    }

    public void addDataExtraData(Map<String, IAMFPacketExtraData> map) {
        this.liveReceiver.addDataExtraData(map);
    }
}

