/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public class VariableSubstitutionTask
extends Task {
    private String sourceFile = "";
    private String destFile = "";
    private List<Substitution> substitutions = new ArrayList<Substitution>();

    public VariableSubstitutionTask() {
        this.setDescription("Wowza Media Systems Variable Substitution");
    }

    public void setSourcefile(String string) {
        this.sourceFile = string.replaceAll("\\\\", "/");
    }

    public void setDestfile(String string) {
        this.destFile = string.replaceAll("\\\\", "/");
    }

    public Substitution createSubstitution() {
        Substitution substitution = new Substitution();
        this.substitutions.add(substitution);
        return substitution;
    }

    public void addSubstitution(Substitution substitution) {
        this.substitutions.add(substitution);
        System.out.println("addSubstitution: " + (Object)((Object)substitution));
    }

    public void execute() throws BuildException {
        File file = new File(this.sourceFile);
        File file2 = new File(this.destFile);
        if (!file.exists()) {
            throw new BuildException("File not found: " + this.sourceFile);
        }
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            LinkedList<Object> linkedList = new LinkedList<Object>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Substitution object2 : this.substitutions) {
                hashMap.put(object2.var, object2.getValue());
            }
            while (bufferedReader.ready()) {
                object = bufferedReader.readLine();
                for (String string : hashMap.keySet()) {
                    if (!((String)object).contains(string)) continue;
                    object = ((String)object).replaceAll("\\$\\{" + string + "\\}", (String)hashMap.get(string));
                }
                linkedList.add(object);
            }
            bufferedReader.close();
            bufferedReader = null;
            System.gc();
            object = new BufferedWriter(new FileWriter(file2));
            for (String string : linkedList) {
                ((Writer)object).write(string);
                ((Writer)object).write("\r\n");
            }
            ((BufferedWriter)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BuildException("Error performing variable substitution", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java -jar <jar> inFile outFile var replace");
            System.exit(1);
        }
        VariableSubstitutionTask variableSubstitutionTask = new VariableSubstitutionTask();
        variableSubstitutionTask.setSourcefile(stringArray[0]);
        variableSubstitutionTask.setDestfile(stringArray[1]);
        Substitution substitution = variableSubstitutionTask.createSubstitution();
        substitution.setVar(stringArray[2]);
        substitution.setValue(stringArray[3]);
        variableSubstitutionTask.addSubstitution(substitution);
        variableSubstitutionTask.execute();
    }

    public static class Substitution
    extends DataType {
        private String var;
        private String val;

        public String getVar() {
            return this.var;
        }

        public void setVar(String string) {
            this.var = string;
        }

        public String getValue() {
            return this.val;
        }

        public void setValue(String string) {
            this.val = string;
        }
    }
}

