@echo off
cls
set CUR_DIR=%cd%
REM Restore next 2 lines and the last line to run from anywhere
REM pushd %cd%
REM cd %~dp0

set CLASSPATH=%cd%\..\lib

echo Verifying running as administrative user
net session >nul 2>&1
if NOT %errorLevel% == 0 (
   echo Administrator privileges are required to update the Wowza Streaming Engine,  Please retry with Administrator privileges
   goto end
   )

echo Verifying Java 1.6 or greater is available
set EXECCSCRIPT=cscript
if not exist "%SystemRoot%\SysWOW64\cscript.exe" goto skip64bitcscript
set EXECCSCRIPT="%SystemRoot%\SysWOW64\cscript.exe"
:skip64bitcscript

%EXECCSCRIPT% //nologo "%~dp0%checkjavahome.vbs"
if not %errorlevel% == 0 goto end

echo Locating Wowza Streaming Engine installation directory
pushd %cd%
cd ..\..\..
set INSTALL_DIR=%cd%
for /D %%d in (bin,conf,lib) DO ( if NOT EXIST "%%d" goto NOT_INSTALL_DIR )
popd

@setlocal enableextensions enabledelayedexpansion

set WSERUNNING="false"

for /F "tokens=* skip=1" %%a in (
 	'wmic process where "commandline like '%%Wowza%%'" get commandline'
) do set CMDLINE="%%a" & call :checkcmdline

if exist cmdline.txt del cmdline.txt

if not %WSERUNNING%=="false" goto end
echo Running Wowza Streaming Engine update installer
"%JAVA_HOME%\bin\java.exe" -DlogLocation="%cd%\.." -Xmx250M -Dcom.wowza.wms.native.base="win" -cp "%CLASSPATH%"\wms-updatetool.jar com.wowza.updatetool.UpdateInstaller -d "%INSTALL_DIR%" %*
goto end

:checkcmdline
echo %CMDLINE% > cmdline.txt
FIND /C /I "wms-bootstrap.jar" cmdline.txt >NUL
if %errorlevel% == 1 goto SERVER_NOT_RUNNING
goto SERVER_IS_RUNNING

:SERVER_NOT_RUNNING
FIND /C /I "wms-winstone" cmdline.txt >NUL
if %errorlevel% == 1 goto MANAGER_NOT_RUNNING
goto MANAGER_IS_RUNNING

:MANAGER_NOT_RUNNING
goto end

:SERVER_IS_RUNNING
echo Wowza Streaming Engine appears to be running.  Please stop it before continuing.
set WSERUNNING="true"
goto end

:MANAGER_IS_RUNNING
echo Wowza Streaming Engine Manager appears to be running.  Please stop it before continuing.
set WSERUNNING="true"
goto end

:NOT_INSTALL_DIR
popd
echo %INSTALL_DIR% does not appear to be a Wowza Streaming Engine install directory.  No update performed.
echo. 
echo WSE Updates should be placed in a sub directory of [INSTALL DIR]\updates directory and then run from the windows sub directory of the update.
echo.
echo An example would be to unzip the update into 
echo.
echo   C:\Program Files (x86)\Wowza Media Systems\Wowza Streaming Engine 4.0.0\updates\Wowza Streaming Engine Update 4.0.0.01
echo.
echo and then change directory to
echo. 
echo   cd C:\Program Files (x86)\Wowza Media Systems\Wowza Streaming Engine 4.0.0\updates\Wowza Streaming Engine Update 4.0.0.01\windows
echo.
echo and executing 
echo.
echo    update.bat 
echo.
echo from there.
:end
REM popd
